/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.util.filter;

import java.io.IOException;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;
import org.eclipse.birt.data.engine.olap.util.filter.InvalidCubePosFilter;
import org.eclipse.birt.data.engine.olap.util.filter.SimpleDiskList;
import org.eclipse.birt.data.engine.olap.util.filter.ValidCubePosFilter;
import org.junit.Assert;
import org.junit.Test;

public class CubePosFilterTest {
    @Test
    public void testValidFilter1() throws DataException, IOException {
        ValidCubePosFilter validCubePosFilter = new ValidCubePosFilter(new String[]{"country", "year", "product"});
        IDiskArray[] simpleDiskLists = new SimpleDiskList[]{new SimpleDiskList(new int[]{1, 2, 3, 4, 6, 8, 9, 10, 11, 18}), new SimpleDiskList(new int[]{11, 12, 13, 14, 6, 8, 9, 10, 11, 18, 19}), new SimpleDiskList(new int[]{1, 3, 5, 7, 9, 18, 29, 40, 51, 58, 69})};
        validCubePosFilter.addDimPositions(simpleDiskLists);
        simpleDiskLists = new SimpleDiskList[]{new SimpleDiskList(new int[]{101, 102, 103}), new SimpleDiskList(new int[]{119}), new SimpleDiskList(new int[]{12, 69})};
        validCubePosFilter.addDimPositions(simpleDiskLists);
        Assert.assertTrue((boolean)validCubePosFilter.getFilterResult(new int[]{101, 119, 12}));
        Assert.assertTrue((boolean)validCubePosFilter.getFilterResult(new int[]{1, 11, 1}));
        Assert.assertTrue((boolean)validCubePosFilter.getFilterResult(new int[]{1, 19, 69}));
        Assert.assertTrue((boolean)validCubePosFilter.getFilterResult(new int[]{18, 19, 69}));
        Assert.assertTrue((boolean)validCubePosFilter.getFilterResult(new int[]{11, 18, 69}));
        Assert.assertTrue((boolean)validCubePosFilter.getFilterResult(new int[]{8, 8, 51}));
        Assert.assertTrue((boolean)validCubePosFilter.getFilterResult(new int[]{1, 11, 69}));
        Assert.assertFalse((boolean)validCubePosFilter.getFilterResult(new int[]{1, 10, 11}));
        Assert.assertFalse((boolean)validCubePosFilter.getFilterResult(new int[3]));
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArray[2] = 69;
        Assert.assertFalse((boolean)validCubePosFilter.getFilterResult(nArray));
        Assert.assertFalse((boolean)validCubePosFilter.getFilterResult(new int[]{1, 119, 69}));
        Assert.assertFalse((boolean)validCubePosFilter.getFilterResult(new int[]{1, 11, 12}));
    }

    @Test
    public void testInvalidFilter1() throws DataException, IOException {
        InvalidCubePosFilter invalidCubePosFilter = new InvalidCubePosFilter(new String[]{"country", "year", "product"});
        IDiskArray[] simpleDiskLists = new SimpleDiskList[]{new SimpleDiskList(new int[]{1, 2, 3, 4, 6, 8, 9, 10, 11, 18}), new SimpleDiskList(new int[]{11, 12, 13, 14, 6, 8, 9, 10, 11, 18, 19}), new SimpleDiskList(new int[]{1, 3, 5, 7, 9, 18, 29, 40, 51, 58, 69})};
        invalidCubePosFilter.addDimPositions(simpleDiskLists);
        simpleDiskLists = new SimpleDiskList[]{new SimpleDiskList(new int[]{101, 102, 103}), new SimpleDiskList(new int[]{119}), new SimpleDiskList(new int[]{12, 69})};
        invalidCubePosFilter.addDimPositions(simpleDiskLists);
        Assert.assertFalse((boolean)invalidCubePosFilter.getFilterResult(new int[]{101, 119, 12}));
        Assert.assertFalse((boolean)invalidCubePosFilter.getFilterResult(new int[]{1, 11, 1}));
        Assert.assertFalse((boolean)invalidCubePosFilter.getFilterResult(new int[]{1, 19, 69}));
        Assert.assertFalse((boolean)invalidCubePosFilter.getFilterResult(new int[]{18, 19, 69}));
        Assert.assertFalse((boolean)invalidCubePosFilter.getFilterResult(new int[]{11, 18, 69}));
        Assert.assertFalse((boolean)invalidCubePosFilter.getFilterResult(new int[]{8, 8, 51}));
        Assert.assertFalse((boolean)invalidCubePosFilter.getFilterResult(new int[]{1, 11, 69}));
        Assert.assertTrue((boolean)invalidCubePosFilter.getFilterResult(new int[]{1, 10, 11}));
        Assert.assertTrue((boolean)invalidCubePosFilter.getFilterResult(new int[3]));
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArray[2] = 69;
        Assert.assertTrue((boolean)invalidCubePosFilter.getFilterResult(nArray));
        Assert.assertTrue((boolean)invalidCubePosFilter.getFilterResult(new int[]{1, 119, 69}));
        Assert.assertTrue((boolean)invalidCubePosFilter.getFilterResult(new int[]{1, 11, 12}));
    }
}

