/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import java.util.List;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class NameSpaceTest
extends BaseTestCase {
    NameSpace nameSpace;
    private static final String reportString = "report";
    private static final String newReportString = "new report";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        SessionHandle sessionHandle = DesignEngine.newSession(null);
        this.designHandle = sessionHandle.createDesign("myDesign");
        this.design = this.designHandle.getDesign();
        NameSpaceTest.assertNotNull((Object)this.design);
        this.nameSpace = new NameSpace();
    }

    public void testInsert() {
        this.design.setName(reportString);
        this.nameSpace.insert((DesignElement)this.design);
        NameSpaceTest.assertTrue((this.nameSpace.getCount() == 1 ? 1 : 0) != 0);
        DesignElement o = this.nameSpace.getElement(reportString);
        NameSpaceTest.assertEquals((Object)this.design, (Object)o);
        this.design.setName(newReportString);
        this.nameSpace.insert((DesignElement)this.design);
        NameSpaceTest.assertTrue((this.nameSpace.getCount() == 2 ? 1 : 0) != 0);
        o = this.nameSpace.getElement(newReportString);
        NameSpaceTest.assertEquals((Object)this.design, (Object)o);
        o = this.nameSpace.getElement(reportString);
        NameSpaceTest.assertEquals((Object)this.design, (Object)o);
    }

    public void testRemove() {
        this.design.setName(reportString);
        this.nameSpace.insert((DesignElement)this.design);
        NameSpaceTest.assertTrue((boolean)this.nameSpace.contains(reportString));
        this.nameSpace.remove((DesignElement)this.design);
        NameSpaceTest.assertFalse((boolean)this.nameSpace.contains(reportString));
        this.design.setName(reportString);
        this.nameSpace.insert((DesignElement)this.design);
        NameSpaceTest.assertTrue((this.nameSpace.getCount() == 1 ? 1 : 0) != 0);
        DesignElement o = this.nameSpace.getElement(reportString);
        NameSpaceTest.assertEquals((Object)this.design, (Object)o);
        this.design.setName(newReportString);
        this.nameSpace.insert((DesignElement)this.design);
        NameSpaceTest.assertTrue((this.nameSpace.getCount() == 2 ? 1 : 0) != 0);
        o = this.nameSpace.getElement(newReportString);
        NameSpaceTest.assertEquals((Object)this.design, (Object)o);
        this.nameSpace.remove((DesignElement)this.design);
        NameSpaceTest.assertTrue((boolean)this.nameSpace.contains(reportString));
        NameSpaceTest.assertFalse((boolean)this.nameSpace.contains(newReportString));
    }

    public void testRename() {
        this.design.setName(reportString);
        this.nameSpace.insert((DesignElement)this.design);
        NameSpaceTest.assertTrue((boolean)this.nameSpace.contains(reportString));
        this.design.setName(newReportString);
        this.nameSpace.rename((DesignElement)this.design, reportString, newReportString);
        NameSpaceTest.assertTrue((boolean)this.nameSpace.contains(newReportString));
        NameSpaceTest.assertFalse((boolean)this.nameSpace.contains(reportString));
        NameSpaceTest.assertTrue((this.nameSpace.getCount() == 1 ? 1 : 0) != 0);
        DesignElement o = this.nameSpace.getElement(newReportString);
        NameSpaceTest.assertEquals((Object)this.design, (Object)o);
        this.design.setName(null);
        this.nameSpace.rename((DesignElement)this.design, newReportString, null);
        NameSpaceTest.assertFalse((boolean)this.nameSpace.contains(newReportString));
    }

    public void testContains() {
        NameSpaceTest.assertFalse((boolean)this.nameSpace.contains(reportString));
        this.design.setName(reportString);
        this.nameSpace.insert((DesignElement)this.design);
        NameSpaceTest.assertTrue((boolean)this.nameSpace.contains(reportString));
        this.design.setName(newReportString);
        NameSpaceTest.assertFalse((boolean)this.nameSpace.contains(newReportString));
        NameSpaceTest.assertTrue((boolean)this.nameSpace.contains(reportString));
        this.nameSpace.insert((DesignElement)this.design);
        NameSpaceTest.assertTrue((boolean)this.nameSpace.contains(newReportString));
    }

    public void testGetElement() {
        this.design.setName(reportString);
        this.nameSpace.insert((DesignElement)this.design);
        NameSpaceTest.assertTrue((this.nameSpace.getCount() == 1 ? 1 : 0) != 0);
        DesignElement o = this.nameSpace.getElement(reportString);
        NameSpaceTest.assertEquals((Object)this.design, (Object)o);
        o = this.nameSpace.getElement(reportString.toUpperCase());
        NameSpaceTest.assertNull((Object)o);
    }

    public void testGetCount() {
        NameSpaceTest.assertTrue((this.nameSpace.getCount() == 0 ? 1 : 0) != 0);
        this.design.setName(reportString);
        this.nameSpace.insert((DesignElement)this.design);
        NameSpaceTest.assertTrue((this.nameSpace.getCount() == 1 ? 1 : 0) != 0);
        this.nameSpace.remove((DesignElement)this.design);
        NameSpaceTest.assertTrue((this.nameSpace.getCount() == 0 ? 1 : 0) != 0);
    }

    public void testGetElementsSequence() throws Exception {
        OdaDataSourceHandle ds = this.designHandle.getElementFactory().newOdaDataSource("Data Source", null);
        this.designHandle.getDataSources().add((DesignElementHandle)ds);
        ds = this.designHandle.getElementFactory().newOdaDataSource("Data Source1", null);
        this.designHandle.getDataSources().add((DesignElementHandle)ds);
        ds = this.designHandle.getElementFactory().newOdaDataSource("Data Source2", null);
        this.designHandle.getDataSources().add((DesignElementHandle)ds);
        List dataSources = this.designHandle.getAllDataSources();
        NameSpaceTest.assertTrue((dataSources.size() == 3 ? 1 : 0) != 0);
        NameSpaceTest.assertEquals((String)"Data Source", (String)((DataSourceHandle)dataSources.get(0)).getName());
        NameSpaceTest.assertEquals((String)"Data Source1", (String)((DataSourceHandle)dataSources.get(1)).getName());
        NameSpaceTest.assertEquals((String)"Data Source2", (String)((DataSourceHandle)dataSources.get(2)).getName());
    }
}

