/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

import java.util.HashMap;
import java.util.List;
import org.eclipse.birt.report.engine.api.IHTMLRenderOption;
import org.eclipse.birt.report.engine.api.IMetadataFilter;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.RenderOption;

public class HTMLRenderOption
extends RenderOption
implements IHTMLRenderOption {
    public HTMLRenderOption(IRenderOption options) {
        super(options);
    }

    public HTMLRenderOption(HashMap options) {
        super(options);
    }

    public HTMLRenderOption() {
    }

    @Override
    public List getInstanceIDs() {
        Object list = this.getOption("InstanceIdList");
        if (list instanceof List) {
            return (List)list;
        }
        return null;
    }

    @Override
    public void setInstanceIDs(List instanceIDs) {
        this.setOption("InstanceIdList", instanceIDs);
    }

    @Override
    public void setEmbeddable(boolean embeddable) {
        if (embeddable) {
            this.setOption("HTMLType", "HTMLNoCSS");
        } else {
            this.setOption("HTMLType", "HTML");
        }
    }

    @Override
    public boolean getEmbeddable() {
        String htmlType = this.getStringOption("HTMLType");
        return "HTMLNoCSS".equals(htmlType);
    }

    @Override
    public void setUserAgent(String userAgent) {
        this.setOption("user-agent", userAgent);
    }

    @Override
    public String getUserAgent() {
        return this.getStringOption("user-agent");
    }

    @Override
    public void setUrlEncoding(String encoding) {
        this.setOption("url-encoding", encoding);
    }

    @Override
    public String getUrlEncoding() {
        return this.getStringOption("url-encoding");
    }

    @Override
    public void setMasterPageContent(boolean show) {
        this.setOption("htmlMasterPageContent", show);
    }

    @Override
    public boolean getMasterPageContent() {
        return this.getBooleanOption("htmlMasterPageContent", true);
    }

    @Override
    public void setHtmlPagination(boolean paginate) {
        this.setOption("htmlPagination", paginate);
    }

    @Override
    public boolean getHtmlPagination() {
        return this.getBooleanOption("htmlPagination", false);
    }

    @Override
    @Deprecated
    public void setIncludeSelectionHandle(boolean option) {
        this.setOption("includeSelectionHandle", option);
    }

    @Override
    @Deprecated
    public boolean getIncludeSelectionHandle() {
        return this.getBooleanOption("includeSelectionHandle", false);
    }

    @Override
    public void setHtmlRtLFlag(boolean flag) {
        this.setOption("RTLFlag", flag);
    }

    @Override
    public boolean getHtmlRtLFlag() {
        return this.getBooleanOption("RTLFlag", false);
    }

    @Override
    public void setHtmlTitle(String htmlTitle) {
        this.setOption("htmlTitle", htmlTitle);
    }

    @Override
    public String getHtmlTitle() {
        return this.getStringOption("htmlTitle");
    }

    @Override
    public void setPageFooterFloatFlag(boolean flag) {
        this.setOption("pageFooterFloatFlag", flag);
    }

    @Override
    public boolean getPageFooterFloatFlag() {
        return this.getBooleanOption("pageFooterFloatFlag", true);
    }

    @Override
    public void setEnableMetadata(boolean enableMetadata) {
        this.setOption("htmlEnableMetadata", enableMetadata);
    }

    @Override
    public boolean getEnableMetadata() {
        return this.getBooleanOption("htmlEnableMetadata", false);
    }

    @Override
    public void setDisplayFilterIcon(boolean displayFilterIcon) {
        this.setOption("htmlDisplayFilterIcon", displayFilterIcon);
    }

    @Override
    public boolean getDisplayFilterIcon() {
        return this.getBooleanOption("htmlDisplayFilterIcon", false);
    }

    @Override
    public void setDisplayGroupIcon(boolean displayGroupIcon) {
        this.setOption("displayGroupIcon", displayGroupIcon);
    }

    @Override
    public boolean getDisplayGroupIcon() {
        return this.getBooleanOption("displayGroupIcon", false);
    }

    @Override
    public String getImageDirectory() {
        return this.getStringOption("imageDirectory");
    }

    @Override
    public void setImageDirectory(String imageDirectory) {
        this.setOption("imageDirectory", imageDirectory);
    }

    @Override
    public String getBaseImageURL() {
        return this.getStringOption("baseImageURL");
    }

    @Override
    public void setBaseImageURL(String baseImageURL) {
        this.setOption("baseImageURL", baseImageURL);
    }

    public void setWrapTemplateTable(boolean wrapTemplateTable) {
        this.options.put("wrapTemplateTable", wrapTemplateTable);
    }

    public boolean getWrapTemplateTable() {
        Object value = this.options.get("wrapTemplateTable");
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }

    public void setLayoutPreference(String layoutPreference) {
        this.options.put("layoutPreference", layoutPreference);
    }

    public String getLayoutPreference() {
        Object value = this.options.get("layoutPreference");
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    public void setEnableAgentStyleEngine(boolean enableAgentStyleEngine) {
        this.options.put("enableAgentStyleEngine", enableAgentStyleEngine);
    }

    public boolean getEnableAgentStyleEngine() {
        Object value = this.options.get("enableAgentStyleEngine");
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }

    public void setOutputMasterPageMargins(boolean outputMasterPageMargins) {
        this.options.put("org.eclipse.birt.report.engine.api.IHTMLRenderOption.outputMasterPageMargins", outputMasterPageMargins);
    }

    public boolean getOutputMasterPageMargins() {
        Object value = this.options.get("org.eclipse.birt.report.engine.api.IHTMLRenderOption.outputMasterPageMargins");
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }

    public void setHTMLIDNamespace(String id) {
        this.setOption("HTMLIDNamespace", id);
    }

    public String getHTMLIDNamespace() {
        return this.getStringOption("HTMLIDNamespace");
    }

    public void setHTMLIndent(boolean indent) {
        this.options.put("HTMLIndent", indent);
    }

    public boolean getHTMLIndent() {
        Object value = this.options.get("HTMLIndent");
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return true;
    }

    public void setMetadataFilter(IMetadataFilter filter) {
        this.setOption("metadataFilter", filter);
    }

    public IMetadataFilter getMetadataFilter() {
        Object filter = this.getOption("metadataFilter");
        if (filter instanceof IMetadataFilter) {
            return (IMetadataFilter)filter;
        }
        return null;
    }

    public void setEnableInlineStyle(boolean inlineStyleFlag) {
        this.options.put("htmlEnableInlineStyle", inlineStyleFlag);
    }

    public boolean getEnableInlineStyle() {
        Object value = this.options.get("htmlEnableInlineStyle");
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }

    public void setViewportMeta(String viewport) {
        this.options.put("viewport", viewport);
    }

    public String getViewportMeta() {
        return this.getStringOption("viewport");
    }

    @Override
    public boolean isEnableCompactMode() {
        return this.getBooleanOption("htmlEnableCompactMode", false);
    }

    @Override
    public void setEnableCompactMode(boolean enableCompactMode) {
        this.setOption("htmlEnableCompactMode", enableCompactMode);
    }

    public void setBirtJsUrl(String birtJsUrl) {
        this.setOption("birtJsUrl", birtJsUrl);
    }

    public String getBirtJsUrl() {
        return this.getStringOption("birtJsUrl");
    }
}

