/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.service;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.api.HTMLActionHandler;
import org.eclipse.birt.report.engine.api.IAction;
import org.eclipse.birt.report.engine.api.IDataAction;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.util.URIUtil;
import org.eclipse.birt.report.service.BirtReportServiceFactory;
import org.eclipse.birt.report.service.api.InputOptions;
import org.eclipse.birt.report.utility.DataUtil;
import org.eclipse.birt.report.utility.ParameterAccessor;
import org.eclipse.birt.report.utility.UrlUtility;

class ViewerHTMLActionHandler
extends HTMLActionHandler {
    private Logger log = Logger.getLogger(ViewerHTMLActionHandler.class.getName());
    protected IReportDocument document = null;
    protected Locale locale = null;
    protected TimeZone timeZone = null;
    protected long page = -1L;
    protected boolean isEmbeddable = false;
    protected boolean isRtl = false;
    protected Boolean isMasterPageContent = null;
    protected String hostFormat = null;
    protected String resourceFolder = null;
    protected Boolean svg = null;
    protected String isDesigner = null;
    protected int pageOverflow = 0;
    protected String viewingSessionId = null;

    public ViewerHTMLActionHandler() {
    }

    public ViewerHTMLActionHandler(IReportDocument document, long page, Locale locale, TimeZone timeZone, boolean isEmbeddable, boolean isRtl, boolean isMasterPageContent, String format, Boolean svg, String isDesigner) {
        this.document = document;
        this.page = page;
        this.locale = locale;
        this.timeZone = timeZone;
        this.isEmbeddable = isEmbeddable;
        this.isRtl = isRtl;
        this.isMasterPageContent = isMasterPageContent ? null : Boolean.FALSE;
        this.hostFormat = format;
        this.svg = svg != false ? Boolean.TRUE : null;
        this.isDesigner = isDesigner;
    }

    public ViewerHTMLActionHandler(Locale locale, TimeZone timeZone, boolean isRtl, boolean isMasterPageContent, String format, Boolean svg, String isDesigner) {
        this.locale = locale;
        this.timeZone = timeZone;
        this.isRtl = isRtl;
        this.isMasterPageContent = isMasterPageContent ? null : Boolean.FALSE;
        this.hostFormat = format;
        this.svg = svg != false ? Boolean.TRUE : null;
        this.isDesigner = isDesigner;
    }

    public String getURL(IAction actionDefn, IReportContext context) {
        if (actionDefn == null) {
            return null;
        }
        switch (actionDefn.getType()) {
            case 2: {
                return this.buildBookmarkAction(actionDefn, context);
            }
            case 1: {
                return this.buildHyperlink(actionDefn, context);
            }
            case 3: {
                return this.buildDrillAction(actionDefn, context);
            }
            case 4: {
                return this.buildDataAction((IDataAction)actionDefn, context);
            }
        }
        return null;
    }

    public String getURL(IAction actionDefn, Object context) {
        if (actionDefn == null) {
            return null;
        }
        if (context instanceof IReportContext) {
            return this.getURL(actionDefn, (IReportContext)context);
        }
        throw new IllegalArgumentException("The context is of wrong type.");
    }

    private String buildHyperlink(IAction action, IReportContext context) {
        ModuleHandle moduleHandle;
        URL url;
        IReportRunnable runnable = context.getReportRunnable();
        String actionURL = action.getActionString();
        if (runnable != null && (url = (moduleHandle = runnable.getDesignHandle().getModuleHandle()).findResource(actionURL, -1)) != null) {
            actionURL = url.toString();
        }
        return actionURL;
    }

    protected String buildBookmarkAction(IAction action, IReportContext context) {
        if (action == null || context == null) {
            return null;
        }
        String baseURL = this.getBaseUrl(context);
        String bookmark = action.getBookmark();
        if (baseURL.lastIndexOf("/frameset") > 0 || baseURL.lastIndexOf("/run") > 0) {
            String func = "catchBookmark('" + ParameterAccessor.htmlEncode(bookmark) + "');";
            return "javascript:try{" + func + "}catch(e){parent." + func + "};";
        }
        StringBuilder link = new StringBuilder();
        boolean realBookmark = false;
        if (this.document != null) {
            long pageNumber = this.document.getPageNumber(action.getBookmark());
            realBookmark = pageNumber == this.page && !this.isEmbeddable;
        }
        try {
            bookmark = URLEncoder.encode(bookmark, "UTF-8");
        }
        catch (UnsupportedEncodingException pageNumber) {
            // empty catch block
        }
        link.append(baseURL);
        link.append("?");
        if (this.document != null) {
            link.append("__document");
            link.append("=");
            String documentName = this.document.getName();
            try {
                documentName = URLEncoder.encode(documentName, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            link.append(documentName);
        } else if (action.getReportName() != null && action.getReportName().length() > 0) {
            link.append("__report");
            link.append("=");
            String reportName = this.getReportName(context, action);
            try {
                reportName = URLEncoder.encode(reportName, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            link.append(reportName);
        } else {
            return "#" + action.getActionString();
        }
        if (this.locale != null) {
            link.append(ParameterAccessor.getQueryParameterString("__locale", this.locale.toString()));
        }
        if (this.timeZone != null) {
            link.append(ParameterAccessor.getQueryParameterString("__timezone", this.timeZone.getID()));
        }
        if (this.isRtl) {
            link.append(ParameterAccessor.getQueryParameterString("__rtl", String.valueOf(this.isRtl)));
        }
        if (this.svg != null) {
            link.append(ParameterAccessor.getQueryParameterString("__svg", String.valueOf(this.svg)));
        }
        if (this.isDesigner != null) {
            link.append(ParameterAccessor.getQueryParameterString("__designer", String.valueOf(this.isDesigner)));
        }
        if (this.pageOverflow > 0) {
            link.append(ParameterAccessor.getQueryParameterString("__pageoverflow", String.valueOf(this.pageOverflow)));
        }
        if (this.isMasterPageContent != null) {
            link.append(ParameterAccessor.getQueryParameterString("__masterpage", String.valueOf(this.isMasterPageContent)));
        }
        try {
            if (this.resourceFolder != null) {
                String res = URLEncoder.encode(this.resourceFolder, "UTF-8");
                link.append(ParameterAccessor.getQueryParameterString("__resourceFolder", res));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (realBookmark) {
            link.append("#");
            link.append(bookmark);
        } else {
            link.append(ParameterAccessor.getQueryParameterString("__bookmark", bookmark));
            if (!action.isBookmark()) {
                link.append(ParameterAccessor.getQueryParameterString("__istoc", "true"));
            }
        }
        return link.toString();
    }

    protected String buildDataAction(IDataAction action, IReportContext context) {
        if (action == null || context == null) {
            return null;
        }
        String actionString = action.getActionString();
        Map params = UrlUtility.extractUriParameters(actionString);
        String anchor = UrlUtility.getAnchor(actionString);
        String encodedPathsString = (String)params.get("__encodedPaths");
        boolean encodePaths = encodedPathsString != null && Boolean.parseBoolean(encodedPathsString);
        String baseURL = this.getBaseUrl(context);
        baseURL = this.createBaseURLWithExtractPattern(baseURL);
        if (this.document != null) {
            String documentName = this.document.getName();
            if (encodePaths) {
                documentName = ParameterAccessor.encodeBase64(documentName);
            }
            params.put("__document", documentName);
        } else if (action.getReportName() != null && action.getReportName().length() > 0) {
            String reportName = this.getReportName(context, (IAction)action);
            if (encodePaths) {
                reportName = ParameterAccessor.encodeBase64(reportName);
            }
            params.put("__report", reportName);
        }
        this.createURLWithExtractInfo(action, params);
        if (this.locale != null) {
            params.put("__locale", this.locale.toString());
        }
        if (this.timeZone != null) {
            params.put("__timezone", this.timeZone.getID());
        }
        if (this.isRtl) {
            params.put("__rtl", String.valueOf(this.isRtl));
        }
        if (this.resourceFolder != null) {
            if (encodePaths) {
                this.resourceFolder = ParameterAccessor.encodeBase64(this.resourceFolder);
            }
            params.put("__resourceFolder", this.resourceFolder);
        }
        if (this.viewingSessionId != null) {
            params.put("__sessionId", this.viewingSessionId);
        }
        return UrlUtility.buildUrl(baseURL, params, anchor);
    }

    private String getBaseUrl(IReportContext context) {
        Object baseURL = context.getRenderOption().getBaseURL();
        String servletPath = (String)context.getRenderOption().getOption("BirtViewerServletPath");
        if (servletPath == null) {
            servletPath = "/preview";
        }
        baseURL = baseURL == null ? servletPath : (String)baseURL + servletPath;
        return baseURL;
    }

    private String encodeParamValue(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            return value;
        }
    }

    protected String buildDrillAction(IAction action, IReportContext context) {
        if (action == null || context == null) {
            return null;
        }
        String baseURL = this.getBaseUrl(context);
        StringBuilder link = new StringBuilder();
        String reportName = this.getReportName(context, action);
        if (reportName != null && !reportName.equals("")) {
            String bookmark;
            link.append(baseURL);
            link.append(reportName.toLowerCase().endsWith(".rptdocument") ? "?__document=" : "?__report=");
            try {
                link.append(URLEncoder.encode(reportName, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            String format = action.getFormat();
            if (format == null || format.length() == 0) {
                format = this.hostFormat;
            }
            if (format != null && format.length() > 0) {
                link.append(ParameterAccessor.getQueryParameterString("__format", format));
            }
            if (action.getParameterBindings() != null) {
                for (Map.Entry entry : action.getParameterBindings().entrySet()) {
                    try {
                        String key = (String)entry.getKey();
                        Object valueObj = entry.getValue();
                        if (valueObj == null) continue;
                        if (valueObj instanceof List) {
                            valueObj = ((List)valueObj).size() == 1 ? ((List)valueObj).get(0) : ((List)valueObj).toArray();
                        }
                        Object[] values = valueObj instanceof Object[] ? (Object[])valueObj : new Object[]{valueObj};
                        int i = 0;
                        while (i < values.length) {
                            String value = DataUtil.getDisplayValue(values[i], this.timeZone);
                            if (value != null) {
                                link.append(ParameterAccessor.getQueryParameterString(URLEncoder.encode(key, "UTF-8"), URLEncoder.encode(value, "UTF-8")));
                            } else {
                                link.append(ParameterAccessor.getQueryParameterString("__isnull", URLEncoder.encode(key, "UTF-8")));
                            }
                            ++i;
                        }
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                }
                if (!reportName.toLowerCase().endsWith(".rptdocument") && baseURL.lastIndexOf("/frameset") > 0) {
                    link.append(ParameterAccessor.getQueryParameterString("__overwrite", String.valueOf(true)));
                }
            }
            if (this.locale != null) {
                link.append(ParameterAccessor.getQueryParameterString("__locale", this.locale.toString()));
            }
            if (this.timeZone != null) {
                link.append(ParameterAccessor.getQueryParameterString("__timezone", this.encodeParamValue(this.timeZone.getID())));
            }
            if (this.isRtl) {
                link.append(ParameterAccessor.getQueryParameterString("__rtl", String.valueOf(this.isRtl)));
            }
            if (this.svg != null) {
                link.append(ParameterAccessor.getQueryParameterString("__svg", String.valueOf(this.svg)));
            }
            if (this.isDesigner != null) {
                link.append(ParameterAccessor.getQueryParameterString("__designer", String.valueOf(this.isDesigner)));
            }
            if (this.pageOverflow > 0) {
                link.append(ParameterAccessor.getQueryParameterString("__pageoverflow", String.valueOf(this.pageOverflow)));
            }
            if (this.isMasterPageContent != null) {
                link.append(ParameterAccessor.getQueryParameterString("__masterpage", String.valueOf(this.isMasterPageContent)));
            }
            try {
                if (this.resourceFolder != null) {
                    String res = URLEncoder.encode(this.resourceFolder, "UTF-8");
                    link.append(ParameterAccessor.getQueryParameterString("__resourceFolder", res));
                }
            }
            catch (UnsupportedEncodingException res) {
                // empty catch block
            }
            if ((bookmark = action.getBookmark()) != null) {
                try {
                    if (baseURL.lastIndexOf("/preview") > 0 || "pdf".equalsIgnoreCase(format)) {
                        if (!action.isBookmark() && reportName.toLowerCase().endsWith(".rptdocument")) {
                            InputOptions options = new InputOptions();
                            options.setOption("locale", this.locale);
                            options.setOption("timeZone", this.timeZone);
                            bookmark = BirtReportServiceFactory.getReportService().findTocByName(reportName, bookmark, options);
                        }
                        if (bookmark != null) {
                            link.append("#");
                            link.append(URLEncoder.encode(bookmark, "UTF-8"));
                        }
                    } else {
                        bookmark = URLEncoder.encode(bookmark, "UTF-8");
                        link.append(ParameterAccessor.getQueryParameterString("__bookmark", bookmark));
                        if (!action.isBookmark()) {
                            link.append(ParameterAccessor.getQueryParameterString("__istoc", "true"));
                        }
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        }
        return link.toString();
    }

    private String getReportName(IReportContext context, IAction action) {
        assert (context != null);
        assert (action != null);
        String reportName = action.getReportName();
        if (reportName != null) {
            if (reportName.startsWith("/") && reportName.indexOf(58) == -1 && !new File(reportName).exists()) {
                return reportName;
            }
            IReportRunnable runnable = context.getReportRunnable();
            if (runnable != null) {
                ModuleHandle moduleHandle = runnable.getDesignHandle().getModuleHandle();
                if (ParameterAccessor.isWorkingFolderAccessOnly()) {
                    String fullPath = URIUtil.resolveAbsolutePath((String)moduleHandle.getSystemId().toExternalForm(), (String)reportName);
                    reportName = URIUtil.getRelativePath((String)ParameterAccessor.workingFolder, (String)fullPath);
                } else {
                    URL url = moduleHandle.findResource(reportName, -1);
                    if (url != null) {
                        if ("file".equals(url.getProtocol())) {
                            try {
                                reportName = new File(url.toURI()).getPath();
                            }
                            catch (URISyntaxException uRISyntaxException) {}
                        } else {
                            reportName = url.toExternalForm();
                        }
                    }
                }
            }
        }
        return reportName;
    }

    public String getResourceFolder() {
        return this.resourceFolder;
    }

    public void setResourceFolder(String resourceFolder) {
        this.resourceFolder = resourceFolder;
    }

    private String createBaseURLWithExtractPattern(String baseURL) {
        String url = baseURL;
        while (url.endsWith("/")) {
            url = url.substring(0, url.length() - 2);
        }
        int index = url.lastIndexOf("/");
        if (index >= 0) {
            url = url.substring(0, index);
        }
        return url + "/extract";
    }

    private void createURLWithExtractInfo(IDataAction action, Map params) {
        assert (action != null);
        assert (params != null);
        if (action.getDataType() != null) {
            params.put("__extractformat", action.getDataType());
        }
        if (action.getInstanceID() != null) {
            params.put("__instanceid", action.getInstanceID().toUniqueString());
        }
        if (action.getBookmark() != null) {
            params.put("__bookmark", action.getBookmark());
        }
    }

    public int getPageOverflow() {
        return this.pageOverflow;
    }

    public void setPageOverflow(int pageOverflow) {
        this.pageOverflow = pageOverflow;
    }

    public String getViewingSessionId() {
        return this.viewingSessionId;
    }

    public void setViewingSessionId(String viewingSessionId) {
        this.viewingSessionId = viewingSessionId;
    }
}

