/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.service;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.framework.IPlatformContext;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.core.framework.PlatformConfig;
import org.eclipse.birt.core.framework.PlatformServletContext;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSourceDesign;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.data.adapter.api.IModelAdapter;
import org.eclipse.birt.report.data.adapter.api.IRequestInfo;
import org.eclipse.birt.report.engine.api.DataExtractionOption;
import org.eclipse.birt.report.engine.api.EmitterInfo;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineConstants;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLActionHandler;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.HTMLServerImageHandler;
import org.eclipse.birt.report.engine.api.IDataExtractionTask;
import org.eclipse.birt.report.engine.api.IEngineTask;
import org.eclipse.birt.report.engine.api.IExtractionOption;
import org.eclipse.birt.report.engine.api.IGetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.IHTMLActionHandler;
import org.eclipse.birt.report.engine.api.IHTMLImageHandler;
import org.eclipse.birt.report.engine.api.IHTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IRenderTask;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportEngineFactory;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IResultMetaData;
import org.eclipse.birt.report.engine.api.IResultSetItem;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.IRunTask;
import org.eclipse.birt.report.engine.api.IScalarParameterDefn;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.api.PDFRenderOption;
import org.eclipse.birt.report.engine.api.RenderOption;
import org.eclipse.birt.report.engine.api.ReportParameterConverter;
import org.eclipse.birt.report.exception.ViewerException;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ListingHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.resource.BirtResources;
import org.eclipse.birt.report.service.ViewerHTMLActionHandler;
import org.eclipse.birt.report.service.api.InputOptions;
import org.eclipse.birt.report.service.api.ReportServiceException;
import org.eclipse.birt.report.session.IViewingSession;
import org.eclipse.birt.report.session.ViewingSessionUtil;
import org.eclipse.birt.report.soapengine.api.Column;
import org.eclipse.birt.report.soapengine.api.ResultSet;
import org.eclipse.birt.report.utility.BirtUtility;
import org.eclipse.birt.report.utility.DataExtractionParameterUtil;
import org.eclipse.birt.report.utility.DataUtil;
import org.eclipse.birt.report.utility.LoggingUtil;
import org.eclipse.birt.report.utility.ParameterAccessor;

public class ReportEngineService {
    private static ReportEngineService instance;
    private IReportEngine engine = null;
    private EngineConfig config = null;
    private HTMLServerImageHandler imageHandler = null;

    private ReportEngineService(ServletContext servletContext) {
        System.setProperty("RUN_UNDER_ECLIPSE", "false");
        if (servletContext == null) {
            return;
        }
        ParameterAccessor.initParameters(servletContext);
        this.config = new EngineConfig();
        HTMLRenderOption emitterConfig = new HTMLRenderOption();
        emitterConfig.setActionHandler((IHTMLActionHandler)new HTMLActionHandler());
        this.imageHandler = new HTMLServerImageHandler();
        emitterConfig.setImageHandler((IHTMLImageHandler)this.imageHandler);
        this.config.getEmitterConfigs().put("html", emitterConfig);
        String logLevel = ParameterAccessor.logLevel;
        Level level = logLevel != null && logLevel.length() > 0 ? Level.parse(logLevel) : Level.OFF;
        this.config.setLogConfig(ParameterAccessor.logFolder, level);
        String scriptLibDir = ParameterAccessor.scriptLibDir;
        ArrayList jarFileList = new ArrayList();
        if (scriptLibDir != null) {
            File dir = new File(scriptLibDir);
            this.getAllJarFiles(dir, jarFileList);
        }
        StringBuilder scriptlibClassPath = new StringBuilder();
        int i = 0;
        while (i < jarFileList.size()) {
            String p = null;
            try {
                p = ((File)jarFileList.get(i)).getCanonicalPath();
            }
            catch (IOException e) {
                p = ((File)jarFileList.get(i)).getAbsolutePath();
            }
            if (p != null && p.length() > 0) {
                if (scriptlibClassPath.length() > 0) {
                    scriptlibClassPath.append(EngineConstants.PROPERTYSEPARATOR);
                }
                scriptlibClassPath.append(p);
            }
            ++i;
        }
        Map<String, Object> appContext = new HashMap<String, Object>();
        appContext.put("webapplication.projectclasspath", scriptlibClassPath.toString());
        ClassLoader appClassLoader = BirtUtility.getAppClassLoader();
        if (appClassLoader == null) {
            appClassLoader = ReportEngineService.class.getClassLoader();
        }
        appContext.put("PARENT_CLASSLOADER", appClassLoader);
        appContext = BirtUtility.getAppContext(appContext);
        this.config.getAppContext().putAll(appContext);
        this.config.setEngineHome("");
        this.config.setMaxRowsPerQuery(ParameterAccessor.maxRows);
        LoggingUtil.configureLoggers(ParameterAccessor.loggers, level, ParameterAccessor.logFolder);
    }

    public static ReportEngineService getInstance() {
        return instance;
    }

    public static synchronized void initEngineInstance(ServletConfig servletConfig) throws BirtException {
        ReportEngineService.initEngineInstance(servletConfig.getServletContext());
    }

    public static synchronized void initEngineInstance(ServletContext servletContext) throws BirtException {
        if (instance != null) {
            return;
        }
        instance = new ReportEngineService(servletContext);
    }

    private void getAllJarFiles(File dir, ArrayList fileList) {
        if (dir.exists() && dir.isDirectory()) {
            File[] files = dir.listFiles();
            if (files == null) {
                return;
            }
            int i = 0;
            while (i < files.length) {
                File file = files[i];
                if (file.isFile()) {
                    if (file.getName().endsWith(".jar")) {
                        fileList.add(file);
                    }
                } else if (file.isDirectory()) {
                    this.getAllJarFiles(file, fileList);
                }
                ++i;
            }
        }
    }

    @Deprecated
    public synchronized void setEngineContext(ServletContext servletContext, HttpServletRequest request) throws BirtException {
        this.setEngineContext(servletContext);
    }

    public synchronized void setEngineContext(ServletContext servletContext) throws BirtException {
        if (this.engine == null) {
            PlatformServletContext platformContext = new PlatformServletContext(servletContext);
            this.config.setPlatformContext((IPlatformContext)platformContext);
            Platform.startup((PlatformConfig)this.config);
            IReportEngineFactory factory = (IReportEngineFactory)Platform.createFactoryObject((String)"org.eclipse.birt.report.engine.ReportEngineFactory");
            if (factory == null) {
                throw new ViewerException("birt.viewer.reportServiceException.STARTUP_REPORTENGINE_ERROR");
            }
            this.engine = factory.createReportEngine(this.config);
            ParameterAccessor.supportedFormats = this.engine.getSupportedFormats();
            ParameterAccessor.supportedDataExtractions = this.engine.getDataExtractionFormatInfo();
            HashMap<String, EmitterInfo> supportedEmitters = new HashMap<String, EmitterInfo>();
            EmitterInfo[] emitterInfos = this.engine.getEmitterInfo();
            int i = 0;
            while (i < emitterInfos.length) {
                EmitterInfo emitterInfo = emitterInfos[i];
                supportedEmitters.put(emitterInfo.getID(), emitterInfo);
                ++i;
            }
            ParameterAccessor.supportedEmitters = supportedEmitters;
        }
    }

    public IReportRunnable openReportDesign(String report, Map options) throws EngineException {
        File file = new File(report);
        if (!file.exists()) {
            throw new EngineException("Error.DesignFileNotFound", (Object)report);
        }
        try {
            FileInputStream in = new FileInputStream(file);
            String systemId = report;
            try {
                systemId = file.toURI().toURL().toString();
            }
            catch (MalformedURLException ue) {
                systemId = report;
            }
            return this.engine.openReportDesign(systemId, (InputStream)in, options);
        }
        catch (FileNotFoundException ioe) {
            throw new EngineException("Error.DesignFileNotFound", (Object)report);
        }
    }

    public IReportRunnable openReportDesign(String systemId, InputStream reportStream, Map options) throws EngineException {
        return this.engine.openReportDesign(systemId, reportStream, options);
    }

    @Deprecated
    public IGetParameterDefinitionTask createGetParameterDefinitionTask(IReportRunnable runnable) {
        IGetParameterDefinitionTask task = null;
        try {
            task = this.engine.createGetParameterDefinitionTask(runnable);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return task;
    }

    public IGetParameterDefinitionTask createGetParameterDefinitionTask(IReportRunnable runnable, InputOptions options) {
        IGetParameterDefinitionTask task = null;
        try {
            HttpServletRequest request = (HttpServletRequest)options.getOption("request");
            Locale locale = (Locale)options.getOption("locale");
            TimeZone timeZone = (TimeZone)options.getOption("timeZone");
            task = this.engine.createGetParameterDefinitionTask(runnable);
            task.setLocale(locale);
            com.ibm.icu.util.TimeZone tz = BirtUtility.toICUTimeZone(timeZone);
            if (tz != null) {
                task.setTimeZone(tz);
            }
            Map context = BirtUtility.getAppContext(request);
            task.setAppContext(context);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return task;
    }

    public IReportDocument openReportDocument(String systemId, String docName, Map options) throws RemoteException {
        if (docName == null) {
            return null;
        }
        IReportDocument document = null;
        try {
            document = this.engine.openReportDocument(systemId, docName, options);
        }
        catch (EngineException e) {
            this.throwDummyException((Exception)((Object)e));
        }
        return document;
    }

    public void renderImage(String imageId, HttpServletRequest request, OutputStream outputStream) throws RemoteException {
        assert (this.imageHandler != null);
        try {
            IViewingSession session = ViewingSessionUtil.getSession(request);
            if (session == null) {
                throw new ReportServiceException(BirtResources.getMessage("birt.viewer.error.noviewingsession"));
            }
            this.imageHandler.getImage(outputStream, session.getImageTempFolder(), imageId);
        }
        catch (BirtException | ReportServiceException e) {
            this.throwDummyException((Exception)e);
        }
    }

    private HTMLRenderOption createHTMLRenderOption(boolean svgFlag, String servletPath, HttpServletRequest request, IViewingSession session) {
        Object baseURL = null;
        if (!ParameterAccessor.isDesigner()) {
            baseURL = ParameterAccessor.getBaseURL();
        }
        if (baseURL == null) {
            baseURL = ParameterAccessor.isOpenAsAttachment(request) || !"html".equalsIgnoreCase(ParameterAccessor.getFormat(request)) ? request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() : "";
        }
        baseURL = (String)baseURL + request.getContextPath();
        HTMLRenderOption renderOption = new HTMLRenderOption();
        renderOption.setImageDirectory(session.getImageTempFolder());
        renderOption.setBaseImageURL(this.createBaseImageUrl(session, (String)baseURL));
        renderOption.setBaseURL((String)baseURL);
        if (servletPath == null || servletPath.length() == 0) {
            servletPath = "/run";
        }
        renderOption.setOption("BirtViewerServletPath", (Object)servletPath);
        renderOption.setEnableAgentStyleEngine(ParameterAccessor.isAgentStyle(request));
        renderOption.setSupportedImageFormats(svgFlag ? "PNG;GIF;JPG;BMP;SWF;SVG" : "PNG;GIF;JPG;BMP;SWF");
        return renderOption;
    }

    private String createBaseImageUrl(IViewingSession session, String baseURL) {
        Object sessionIdPart = "";
        if (session != null) {
            sessionIdPart = "__sessionId=" + session.getId() + "&";
        }
        return baseURL + "/preview?" + (String)sessionIdPart + "__imageid=";
    }

    private PDFRenderOption createPDFRenderOption(String servletPath, HttpServletRequest request, int pageOverflow, boolean isDesigner, boolean isPDF) {
        Object baseURL = null;
        if (!isDesigner) {
            baseURL = ParameterAccessor.getBaseURL();
        }
        if (baseURL == null) {
            baseURL = ParameterAccessor.isOpenAsAttachment(request) ? request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() : "";
        }
        baseURL = (String)baseURL + request.getContextPath();
        PDFRenderOption renderOption = new PDFRenderOption();
        renderOption.setBaseURL((String)baseURL);
        if (servletPath == null || servletPath.length() == 0) {
            servletPath = "/run";
        }
        renderOption.setOption("BirtViewerServletPath", (Object)servletPath);
        renderOption.setSupportedImageFormats(isPDF ? "PNG;GIF;JPG;BMP;SVG" : "PNG;GIF;JPG;BMP");
        switch (pageOverflow) {
            case 0: {
                renderOption.setOption("pdfRenderOption.pageOverflow", (Object)4);
                break;
            }
            case 1: {
                renderOption.setOption("pdfRenderOption.pageOverflow", (Object)8);
                break;
            }
            case 2: {
                renderOption.setOption("pdfRenderOption.fitToPage", (Object)Boolean.TRUE);
                break;
            }
            default: {
                renderOption.setOption("pdfRenderOption.pageOverflow", (Object)4);
            }
        }
        renderOption.setOption("pdfRenderOption.pagebreakPaginationOnly", (Object)Boolean.FALSE);
        return renderOption;
    }

    @Deprecated
    public void runAndRenderReport(HttpServletRequest request, IReportRunnable runnable, OutputStream outputStream, String format, Locale locale, boolean rtl, Map parameters, boolean masterPage, boolean svgFlag) throws RemoteException {
        this.runAndRenderReport(request, runnable, outputStream, format, locale, rtl, parameters, masterPage, svgFlag, null, null, null, null, null, null, null);
    }

    @Deprecated
    public void runAndRenderReport(HttpServletRequest request, IReportRunnable runnable, OutputStream outputStream, String format, Locale locale, boolean rtl, Map parameters, boolean masterPage, boolean svgFlag, Map displayTexts, String servletPath, String reportTitle) throws RemoteException {
        this.runAndRenderReport(request, runnable, outputStream, format, locale, rtl, parameters, masterPage, svgFlag, null, null, null, displayTexts, servletPath, reportTitle, null);
    }

    @Deprecated
    public void runAndRenderReport(HttpServletRequest request, IReportRunnable runnable, OutputStream outputStream, String format, Locale locale, boolean rtl, Map parameters, boolean masterPage, boolean svgFlag, Map displayTexts, String servletPath, String reportTitle, Integer maxRows) throws RemoteException {
        this.runAndRenderReport(request, runnable, outputStream, format, locale, rtl, parameters, masterPage, svgFlag, null, null, null, displayTexts, servletPath, reportTitle, maxRows);
    }

    @Deprecated
    public void runAndRenderReport(HttpServletRequest request, IReportRunnable runnable, OutputStream outputStream, String format, Locale locale, boolean rtl, Map parameters, boolean masterPage, boolean svgFlag, Boolean embeddable, List activeIds, RenderOption renderOption, Map displayTexts, String iServletPath, String reportTitle, Integer maxRows) throws RemoteException {
        InputOptions inputOptions = new InputOptions();
        inputOptions.setOption("request", request);
        inputOptions.setOption("locale", locale);
        inputOptions.setOption("isMasterPageContent", masterPage);
        inputOptions.setOption("svgFlag", svgFlag);
        inputOptions.setOption("rtl", rtl);
        inputOptions.setOption("format", format);
        inputOptions.setOption("servletPath", iServletPath);
        this.runAndRenderReport(runnable, outputStream, inputOptions, parameters, embeddable, activeIds, renderOption, displayTexts, reportTitle, maxRows);
    }

    public void runAndRenderReport(IReportRunnable runnable, OutputStream outputStream, InputOptions inputOptions, Map parameters, Boolean embeddable, List activeIds, RenderOption aRenderOption, Map displayTexts, String reportTitle, Integer maxRows) throws RemoteException {
        assert (runnable != null);
        IRunAndRenderTask runAndRenderTask = null;
        try {
            runAndRenderTask = this.createRunAndRenderTask(runnable, outputStream, inputOptions, parameters, embeddable, activeIds, aRenderOption, displayTexts, reportTitle, maxRows);
        }
        catch (ReportServiceException e) {
            this.throwDummyException(e);
        }
        boolean isDesigner = this.isDesigner(inputOptions);
        HttpServletRequest request = (HttpServletRequest)inputOptions.getOption("request");
        BirtUtility.addTask(request, (IEngineTask)runAndRenderTask);
        try {
            try {
                runAndRenderTask.run();
            }
            catch (BirtException e) {
                this.throwDummyException((Exception)((Object)e));
                BirtUtility.removeTask(request);
                if (isDesigner) {
                    BirtUtility.error(request, runAndRenderTask.getErrors());
                }
                runAndRenderTask.close();
            }
        }
        finally {
            BirtUtility.removeTask(request);
            if (isDesigner) {
                BirtUtility.error(request, runAndRenderTask.getErrors());
            }
            runAndRenderTask.close();
        }
    }

    private IRunAndRenderTask createRunAndRenderTask(IReportRunnable runnable, OutputStream outputStream, InputOptions inputOptions, Map parameters, Boolean embeddable, List activeIds, RenderOption aRenderOption, Map displayTexts, String reportTitle, Integer maxRows) throws ReportServiceException {
        RenderOption renderOption = aRenderOption;
        HttpServletRequest request = (HttpServletRequest)inputOptions.getOption("request");
        Locale locale = (Locale)inputOptions.getOption("locale");
        TimeZone timeZone = (TimeZone)inputOptions.getOption("timeZone");
        Boolean isMasterPageContent = (Boolean)inputOptions.getOption("isMasterPageContent");
        boolean masterPage = isMasterPageContent == null ? true : isMasterPageContent;
        Boolean svgFlag = (Boolean)inputOptions.getOption("svgFlag");
        String format = (String)inputOptions.getOption("format");
        String emitterId = (String)inputOptions.getOption("emitterId");
        boolean rtl = this.isRtl(inputOptions);
        boolean isDesigner = this.isDesigner(inputOptions);
        int pageOverflow = this.getPageOverflow(inputOptions);
        String iServletPath = (String)inputOptions.getOption("servletPath");
        String servletPath = iServletPath;
        if (servletPath == null) {
            servletPath = request.getServletPath();
        }
        IRunAndRenderTask runAndRenderTask = this.engine.createRunAndRenderTask(runnable);
        runAndRenderTask.setLocale(locale);
        com.ibm.icu.util.TimeZone tz = BirtUtility.toICUTimeZone(timeZone);
        if (tz != null) {
            runAndRenderTask.setTimeZone(tz);
        }
        if (parameters != null) {
            runAndRenderTask.setParameterValues(parameters);
        }
        if (displayTexts != null) {
            Iterator keys = displayTexts.keySet().iterator();
            while (keys.hasNext()) {
                String paramName = DataUtil.getString(keys.next());
                String displayText = DataUtil.getString(displayTexts.get(paramName));
                runAndRenderTask.setParameterDisplayText(paramName, displayText);
            }
        }
        if (maxRows != null) {
            runAndRenderTask.setMaxRowsPerQuery(maxRows.intValue());
        }
        Map context = BirtUtility.getAppContext(request);
        runAndRenderTask.setAppContext(context);
        ViewerHTMLActionHandler handler = new ViewerHTMLActionHandler(locale, timeZone, rtl, masterPage, format, svgFlag, Boolean.toString(isDesigner));
        handler.setPageOverflow(pageOverflow);
        String resourceFolder = ParameterAccessor.getParameter(request, "__resourceFolder");
        handler.setResourceFolder(resourceFolder);
        IViewingSession session = ViewingSessionUtil.getSession(request);
        if (!ParameterAccessor.isPDFLayout(format)) {
            if (session != null) {
                handler.setViewingSessionId(session.getId());
            } else {
                throw new IllegalStateException(BirtResources.getMessage("birt.viewer.error.noviewingsession"));
            }
        }
        if (renderOption == null) {
            if (ParameterAccessor.isPDFLayout(format)) {
                renderOption = this.createPDFRenderOption(servletPath, request, pageOverflow, isDesigner, "pdf".equalsIgnoreCase(format));
            } else {
                if (!"html".equalsIgnoreCase(format)) {
                    svgFlag = false;
                }
                renderOption = this.createHTMLRenderOption(svgFlag, servletPath, request, session);
            }
        }
        renderOption.setOutputStream(outputStream);
        renderOption.setOutputFormat(format);
        renderOption.setEmitterID(emitterId);
        renderOption.setOption("htmlMasterPageContent", (Object)masterPage);
        renderOption.setActionHandler((IHTMLActionHandler)handler);
        if (reportTitle != null) {
            renderOption.setOption("htmlTitle", (Object)reportTitle);
        }
        if (renderOption instanceof IHTMLRenderOption) {
            boolean isEmbeddable = false;
            if (embeddable != null) {
                isEmbeddable = embeddable;
            }
            if ("/run".equalsIgnoreCase(servletPath)) {
                isEmbeddable = true;
            }
            ((IHTMLRenderOption)renderOption).setEmbeddable(isEmbeddable);
        }
        renderOption.setOption("InstanceIdList", (Object)activeIds);
        this.initializeEmitterConfigs(request, renderOption.getOptions());
        runAndRenderTask.setRenderOption((IRenderOption)renderOption);
        return runAndRenderTask;
    }

    private void throwDummyException(Exception e) throws DummyRemoteException {
        if (e instanceof ReportServiceException) {
            throw new DummyRemoteException(e);
        }
        throw new DummyRemoteException(new ReportServiceException(e.getLocalizedMessage(), e));
    }

    private boolean isRtl(InputOptions inputOptions) {
        Boolean isRtl = (Boolean)inputOptions.getOption("rtl");
        boolean rtl = isRtl == null ? false : isRtl;
        return rtl;
    }

    private int getPageOverflow(InputOptions inputOptions) {
        Integer pageOverflowInt = (Integer)inputOptions.getOption("pageOverflow");
        int pageOverflow = pageOverflowInt != null ? pageOverflowInt : 0;
        return pageOverflow;
    }

    private boolean isDesigner(InputOptions inputOptions) {
        Boolean isDesignerBool = (Boolean)inputOptions.getOption("isDesigner");
        boolean isDesigner = false;
        if (isDesignerBool != null) {
            isDesigner = isDesignerBool;
        }
        return isDesigner;
    }

    private void initializeEmitterConfigs(HttpServletRequest request, Map config) {
        if (config == null) {
            return;
        }
        for (Map.Entry entry : request.getParameterMap().entrySet()) {
            String name = String.valueOf(entry.getKey());
            if (!name.startsWith("__")) continue;
            config.put(name.substring(2), ParameterAccessor.getParameter(request, name));
        }
    }

    @Deprecated
    public void runReport(HttpServletRequest request, IReportRunnable runnable, String documentName, Locale locale, Map parameters) throws RemoteException {
        this.runReport(request, runnable, documentName, locale, parameters, null, null);
    }

    @Deprecated
    public void runReport(HttpServletRequest request, IReportRunnable runnable, String documentName, Locale locale, Map parameters, Map displayTexts) throws RemoteException {
        this.runReport(request, runnable, documentName, locale, parameters, displayTexts, null);
    }

    @Deprecated
    private void runReport(HttpServletRequest request, IReportRunnable runnable, String documentName, Locale locale, Map parameters, Map displayTexts, Object object) throws RemoteException {
        this.runReport(request, runnable, documentName, locale, null, parameters, displayTexts, null);
    }

    public List<Exception> runReport(HttpServletRequest request, IReportRunnable runnable, String documentName, Locale locale, TimeZone timeZone, Map parameters, Map displayTexts, Integer maxRows) throws RemoteException {
        assert (runnable != null);
        IRunTask runTask = this.engine.createRunTask(runnable);
        runTask.setLocale(locale);
        com.ibm.icu.util.TimeZone tz = BirtUtility.toICUTimeZone(timeZone);
        if (tz != null) {
            runTask.setTimeZone(tz);
        }
        runTask.setParameterValues(parameters);
        if (maxRows != null) {
            runTask.setMaxRowsPerQuery(maxRows.intValue());
        }
        BirtUtility.addTask(request, (IEngineTask)runTask);
        if (displayTexts != null) {
            Iterator keys = displayTexts.keySet().iterator();
            while (keys.hasNext()) {
                String paramName = DataUtil.getString(keys.next());
                String displayText = DataUtil.getString(displayTexts.get(paramName));
                runTask.setParameterDisplayText(paramName, displayText);
            }
        }
        Map context = BirtUtility.getAppContext(request);
        runTask.setAppContext(context);
        try {
            try {
                runTask.run(documentName);
            }
            catch (BirtException e) {
                File doc = new File(documentName);
                if (doc != null) {
                    doc.delete();
                }
                this.throwDummyException((Exception)((Object)e));
                BirtUtility.removeTask(request);
                List errors = runTask.getErrors();
                if (ParameterAccessor.isDesigner()) {
                    BirtUtility.error(request, runTask.getErrors());
                }
                runTask.close();
                if (!errors.isEmpty()) {
                    return errors;
                }
            }
        }
        finally {
            BirtUtility.removeTask(request);
            List errors = runTask.getErrors();
            if (ParameterAccessor.isDesigner()) {
                BirtUtility.error(request, runTask.getErrors());
            }
            runTask.close();
            if (!errors.isEmpty()) {
                return errors;
            }
        }
        return null;
    }

    @Deprecated
    public ByteArrayOutputStream renderReport(HttpServletRequest request, IReportDocument reportDocument, long pageNumber, boolean masterPage, boolean svgFlag, List activeIds, Locale locale, boolean rtl) throws RemoteException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.renderReport(out, request, reportDocument, null, pageNumber, null, masterPage, svgFlag, activeIds, locale, rtl, null);
        return out;
    }

    public ByteArrayOutputStream renderReport(HttpServletRequest request, IReportDocument reportDocument, String format, long pageNumber, boolean masterPage, boolean svgFlag, List activeIds, Locale locale, boolean rtl) throws RemoteException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.renderReport(out, request, reportDocument, format, pageNumber, null, masterPage, svgFlag, activeIds, locale, rtl, null);
        return out;
    }

    @Deprecated
    public void renderReport(OutputStream os, HttpServletRequest request, IReportDocument reportDocument, long pageNumber, String pageRange, boolean masterPage, boolean svgFlag, List activeIds, Locale locale, boolean rtl, String iServletPath) throws RemoteException {
        this.renderReport(os, request, reportDocument, null, pageNumber, pageRange, masterPage, svgFlag, activeIds, locale, rtl, iServletPath);
    }

    @Deprecated
    public void renderReport(OutputStream out, HttpServletRequest request, IReportDocument reportDocument, String format, long pageNumber, String pageRange, boolean masterPage, boolean svgFlag, List activeIds, Locale locale, boolean rtl, String iServletPath) throws RemoteException {
        InputOptions inputOptions = new InputOptions();
        inputOptions.setOption("request", request);
        inputOptions.setOption("locale", locale);
        inputOptions.setOption("isMasterPageContent", masterPage);
        inputOptions.setOption("svgFlag", svgFlag);
        inputOptions.setOption("rtl", rtl);
        inputOptions.setOption("format", format);
        inputOptions.setOption("servletPath", iServletPath);
        this.renderReport(out, reportDocument, pageNumber, pageRange, inputOptions, activeIds);
    }

    public void renderReport(OutputStream out, IReportDocument reportDocument, long pageNumber, String pageRange, InputOptions inputOptions, List activeIds) throws RemoteException {
        if (out == null) {
            return;
        }
        HttpServletRequest request = (HttpServletRequest)inputOptions.getOption("request");
        String format = (String)inputOptions.getOption("format");
        String iServletPath = (String)inputOptions.getOption("servletPath");
        IRenderTask renderTask = null;
        try {
            renderTask = this.createRenderTask(out, reportDocument, inputOptions, pageNumber, activeIds);
        }
        catch (ReportServiceException e) {
            this.throwDummyException(e);
        }
        String servletPath = iServletPath;
        if (servletPath == null) {
            servletPath = request.getServletPath();
        }
        try {
            try {
                if (pageNumber > 0L) {
                    renderTask.setPageNumber(pageNumber);
                }
                if (!(pageRange == null || "/frameset".equalsIgnoreCase(servletPath) && "html".equalsIgnoreCase(format))) {
                    renderTask.setPageRange(pageRange);
                }
                renderTask.render();
            }
            catch (EngineException e) {
                this.throwDummyException((Exception)((Object)e));
                BirtUtility.removeTask(request);
                if (ParameterAccessor.isDesigner()) {
                    BirtUtility.error(request, renderTask.getErrors());
                }
                renderTask.close();
            }
        }
        finally {
            BirtUtility.removeTask(request);
            if (ParameterAccessor.isDesigner()) {
                BirtUtility.error(request, renderTask.getErrors());
            }
            renderTask.close();
        }
    }

    private IRenderTask createRenderTask(OutputStream out, IReportDocument reportDocument, InputOptions inputOptions, long pageNumber, List activeIds) throws ReportServiceException {
        HttpServletRequest request = (HttpServletRequest)inputOptions.getOption("request");
        Locale locale = (Locale)inputOptions.getOption("locale");
        TimeZone timeZone = (TimeZone)inputOptions.getOption("timeZone");
        Boolean isMasterPageContent = (Boolean)inputOptions.getOption("isMasterPageContent");
        boolean masterPage = isMasterPageContent == null ? true : isMasterPageContent;
        Boolean svgFlag = (Boolean)inputOptions.getOption("svgFlag");
        String format = (String)inputOptions.getOption("format");
        String emitterId = (String)inputOptions.getOption("emitterId");
        String iServletPath = (String)inputOptions.getOption("servletPath");
        boolean rtl = this.isRtl(inputOptions);
        boolean isDesigner = this.isDesigner(inputOptions);
        int pageOverflow = this.getPageOverflow(inputOptions);
        if (reportDocument == null) {
            throw new ReportServiceException(BirtResources.getMessage("birt.viewer.actionException.NO_REPORT_DOCUMENT"));
        }
        String servletPath = iServletPath;
        if (servletPath == null) {
            servletPath = request.getServletPath();
        }
        IRenderTask renderTask = this.engine.createRenderTask(reportDocument);
        BirtUtility.addTask(request, (IEngineTask)renderTask);
        Map context = BirtUtility.getAppContext(request);
        renderTask.setAppContext(context);
        PDFRenderOption renderOption = null;
        if (format == null) {
            format = ParameterAccessor.getFormat(request);
        }
        if (ParameterAccessor.isPDFLayout(format)) {
            renderOption = this.createPDFRenderOption(servletPath, request, pageOverflow, ParameterAccessor.isDesigner(), "pdf".equalsIgnoreCase(format));
        } else {
            IViewingSession session;
            if (!"html".equalsIgnoreCase(format)) {
                svgFlag = false;
            }
            if ((session = ViewingSessionUtil.getSession(request)) == null) {
                throw new IllegalStateException(BirtResources.getMessage("birt.viewer.error.noviewingsession"));
            }
            renderOption = this.createHTMLRenderOption(svgFlag, servletPath, request, session);
        }
        if (!"xls".equalsIgnoreCase(format)) {
            renderOption.setOption("htmlPagination", (Object)Boolean.TRUE);
        }
        renderOption.setOutputStream(out);
        renderOption.setOutputFormat(format);
        renderOption.setEmitterID(emitterId);
        ViewerHTMLActionHandler handler = null;
        if (ParameterAccessor.isPDFLayout(format)) {
            handler = new ViewerHTMLActionHandler(reportDocument, pageNumber, locale, timeZone, false, rtl, masterPage, format, svgFlag, Boolean.toString(isDesigner));
        } else {
            boolean isEmbeddable = false;
            if ("/frameset".equalsIgnoreCase(servletPath) || "/run".equalsIgnoreCase(servletPath)) {
                isEmbeddable = true;
            }
            if (renderOption instanceof IHTMLRenderOption) {
                ((IHTMLRenderOption)renderOption).setEmbeddable(isEmbeddable);
            }
            renderOption.setOption("InstanceIdList", (Object)activeIds);
            renderOption.setOption("htmlMasterPageContent", (Object)masterPage);
            handler = new ViewerHTMLActionHandler(reportDocument, pageNumber, locale, timeZone, isEmbeddable, rtl, masterPage, format, svgFlag, Boolean.toString(isDesigner));
            IViewingSession session = ViewingSessionUtil.getSession(request);
            if (session == null) {
                throw new ReportServiceException(BirtResources.getMessage("birt.viewer.error.noviewingsession"));
            }
            handler.setViewingSessionId(session.getId());
        }
        handler.setPageOverflow(pageOverflow);
        String resourceFolder = ParameterAccessor.getParameter(request, "__resourceFolder");
        handler.setResourceFolder(resourceFolder);
        renderOption.setActionHandler((IHTMLActionHandler)handler);
        if (pageNumber >= 0L) {
            this.initializeEmitterConfigs(request, renderOption.getOptions());
        }
        renderTask.setRenderOption((IRenderOption)renderOption);
        renderTask.setLocale(locale);
        com.ibm.icu.util.TimeZone tz = BirtUtility.toICUTimeZone(timeZone);
        if (tz != null) {
            renderTask.setTimeZone(tz);
        }
        return renderTask;
    }

    @Deprecated
    public void renderReportlet(OutputStream os, HttpServletRequest request, IReportDocument reportDocument, String reportletId, boolean masterPage, boolean svgFlag, List activeIds, Locale locale, boolean rtl) throws RemoteException {
        this.renderReportlet(os, request, reportDocument, reportletId, null, masterPage, svgFlag, activeIds, locale, rtl, null);
    }

    @Deprecated
    public void renderReportlet(OutputStream os, HttpServletRequest request, IReportDocument reportDocument, String reportletId, boolean masterPage, boolean svgFlag, List activeIds, Locale locale, boolean rtl, String iServletPath) throws RemoteException {
        this.renderReportlet(os, request, reportDocument, reportletId, null, masterPage, svgFlag, activeIds, locale, rtl, iServletPath);
    }

    @Deprecated
    public OutputStream renderReportlet(HttpServletRequest request, IReportDocument reportDocument, String reportletId, String format, boolean masterPage, boolean svgFlag, List activeIds, Locale locale, boolean rtl, String iServletPath) throws RemoteException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.renderReportlet(out, request, reportDocument, reportletId, format, masterPage, svgFlag, activeIds, locale, rtl, iServletPath);
        return out;
    }

    @Deprecated
    public void renderReportlet(OutputStream out, HttpServletRequest request, IReportDocument reportDocument, String reportletId, String format, boolean masterPage, boolean svgFlag, List activeIds, Locale locale, boolean rtl, String iServletPath) throws RemoteException {
        InputOptions inputOptions = new InputOptions();
        inputOptions.setOption("request", request);
        inputOptions.setOption("locale", locale);
        inputOptions.setOption("isMasterPageContent", masterPage);
        inputOptions.setOption("svgFlag", svgFlag);
        inputOptions.setOption("rtl", rtl);
        inputOptions.setOption("format", format);
        inputOptions.setOption("servletPath", iServletPath);
        this.renderReportlet(out, reportDocument, inputOptions, reportletId, activeIds);
    }

    public void renderReportlet(OutputStream out, IReportDocument reportDocument, InputOptions inputOptions, String reportletId, List activeIds) throws RemoteException {
        if (out == null) {
            return;
        }
        HttpServletRequest request = (HttpServletRequest)inputOptions.getOption("request");
        IRenderTask renderTask = null;
        try {
            renderTask = this.createRenderTask(out, reportDocument, inputOptions, -1L, activeIds);
        }
        catch (ReportServiceException e) {
            this.throwDummyException(e);
        }
        try {
            try {
                if (ParameterAccessor.isIidReportlet(request)) {
                    InstanceID instanceId = InstanceID.parse((String)reportletId);
                    renderTask.setInstanceID(instanceId);
                } else {
                    renderTask.setReportlet(reportletId);
                }
                renderTask.render();
            }
            catch (EngineException e) {
                this.throwDummyException((Exception)((Object)e));
                BirtUtility.removeTask(request);
                if (ParameterAccessor.isDesigner()) {
                    BirtUtility.error(request, renderTask.getErrors());
                }
                renderTask.close();
            }
        }
        finally {
            BirtUtility.removeTask(request);
            if (ParameterAccessor.isDesigner()) {
                BirtUtility.error(request, renderTask.getErrors());
            }
            renderTask.close();
        }
    }

    public ResultSet[] getResultSets(IReportDocument document) throws RemoteException {
        assert (document != null);
        ResultSet[] resultSetArray = null;
        try (IDataExtractionTask dataTask = this.engine.createDataExtractionTask(document);){
            try {
                List resultSets = dataTask.getResultSetList();
                resultSetArray = new ResultSet[resultSets.size()];
                if (resultSets.size() > 0) {
                    int k = 0;
                    while (k < resultSets.size()) {
                        resultSetArray[k] = new ResultSet();
                        IResultSetItem resultSetItem = (IResultSetItem)resultSets.get(k);
                        assert (resultSetItem != null);
                        resultSetArray[k].setQueryName(resultSetItem.getResultSetName());
                        IResultMetaData metaData = resultSetItem.getResultMetaData();
                        assert (metaData != null);
                        ArrayList<Column> columnArray = new ArrayList<Column>();
                        int i = 0;
                        while (i < metaData.getColumnCount()) {
                            if (metaData.getAllowExport(i)) {
                                Column column = new Column();
                                String name = metaData.getColumnName(i);
                                column.setName(name);
                                String label = metaData.getColumnLabel(i);
                                if (label == null || label.length() <= 0) {
                                    label = name;
                                }
                                column.setLabel(label);
                                column.setVisibility(true);
                                columnArray.add(column);
                            }
                            ++i;
                        }
                        resultSetArray[k].setColumn(columnArray.toArray(new Column[0]));
                        ++k;
                    }
                }
            }
            catch (Exception e) {
                this.throwDummyException(e);
                dataTask.close();
            }
        }
        return resultSetArray;
    }

    public void extractDataEx(IReportDocument document, String aExtractFormat, String extractExtension, String resultSetName, String instanceId, Collection columns, Locale locale, TimeZone timeZone, Map options, OutputStream out) throws RemoteException {
        assert (document != null);
        String extractFormat = aExtractFormat;
        try (IDataExtractionTask dataTask = null;){
            try {
                if (extractFormat == null || "".equals(extractFormat)) {
                    extractFormat = ParameterAccessor.getExtractFormat(extractExtension);
                }
                String[] columnNames = DataExtractionParameterUtil.getColumnNames(columns);
                dataTask = this.engine.createDataExtractionTask(document);
                if (resultSetName != null) {
                    dataTask.selectResultSet(resultSetName);
                }
                if (instanceId != null) {
                    dataTask.setInstanceID(InstanceID.parse((String)instanceId));
                }
                dataTask.setLocale(locale);
                com.ibm.icu.util.TimeZone tz = BirtUtility.toICUTimeZone(timeZone);
                if (tz != null) {
                    dataTask.setTimeZone(tz);
                }
                DataExtractionOption extractOption = null;
                extractOption = "csv".equals(extractFormat) ? DataExtractionParameterUtil.createCSVOptions(columnNames, locale, timeZone, options) : DataExtractionParameterUtil.createOptions(null, columnNames, locale, timeZone, options);
                extractOption.setOutputFormat(extractFormat);
                extractOption.setExtension(extractExtension);
                extractOption.setOutputStream(out);
                if (columnNames != null && columnNames.length > 0) {
                    dataTask.selectColumns(columnNames);
                }
                dataTask.extract((IExtractionOption)extractOption);
            }
            catch (BirtException e) {
                this.throwDummyException((Exception)((Object)e));
                if (dataTask != null) {
                    dataTask.close();
                }
            }
        }
    }

    @Deprecated
    public void extractData(IReportDocument document, String resultSetName, Collection columns, Locale locale, OutputStream outputStream, String encoding) throws RemoteException {
        this.extractData(document, resultSetName, columns, locale, outputStream, encoding, ",".charAt(0), false);
    }

    @Deprecated
    public void extractData(IReportDocument document, String resultSetName, Collection columns, Locale locale, OutputStream outputStream, String encoding, char sep, boolean isExportDataType) throws RemoteException {
        assert (document != null);
        assert (resultSetName != null && resultSetName.length() > 0);
        assert (columns != null && !columns.isEmpty());
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("__sep", Character.toString(sep));
        options.put("__exportdatatype", isExportDataType);
        options.put("__exportencoding", encoding);
        this.extractDataEx(document, "csv", "org.eclipse.birt.report.engine.dataextraction.csv", resultSetName, null, columns, locale, null, options, outputStream);
    }

    @Deprecated
    public HashMap parseParameters(HttpServletRequest request, IGetParameterDefinitionTask task, Map configVars, Locale locale) {
        assert (task != null);
        HashMap<String, Object> params = new HashMap<String, Object>();
        Collection parameterList = task.getParameterDefns(false);
        for (IScalarParameterDefn parameterObj : parameterList) {
            String paramValue = null;
            Object paramValueObj = null;
            String paramName = parameterObj.getName();
            String format = parameterObj.getDisplayFormat();
            ReportParameterConverter converter = new ReportParameterConverter(format, locale);
            if (ParameterAccessor.isReportParameterExist(request, paramName)) {
                paramValue = ParameterAccessor.getReportParameter(request, paramName, paramValue);
                paramValueObj = converter.parse(paramValue, parameterObj.getDataType());
            } else if (ParameterAccessor.isDesigner() && configVars.containsKey(paramName)) {
                String configValue = (String)configVars.get(paramName);
                ReportParameterConverter cfgConverter = new ReportParameterConverter(format, Locale.US);
                paramValueObj = cfgConverter.parse(configValue, parameterObj.getDataType());
            } else {
                paramValueObj = task.getDefaultValue(parameterObj.getName());
            }
            params.put(paramName, paramValueObj);
        }
        return params;
    }

    @Deprecated
    public boolean validateParameters(IGetParameterDefinitionTask task, Map parameters) {
        assert (task != null);
        assert (parameters != null);
        boolean missingParameter = false;
        Collection parameterList = task.getParameterDefns(false);
        for (IScalarParameterDefn parameterObj : parameterList) {
            String parameterStringValue;
            String parameterName = parameterObj.getName();
            Object parameterValue = parameters.get(parameterName);
            if (parameterObj.isHidden()) continue;
            if (parameterValue == null && !parameterObj.allowNull()) {
                missingParameter = true;
                break;
            }
            if (1 != parameterObj.getDataType() || (parameterStringValue = (String)parameterValue) == null || parameterStringValue.length() > 0 || parameterObj.allowBlank()) continue;
            missingParameter = true;
            break;
        }
        return missingParameter;
    }

    public void clearCache(DataSetHandle dataSet) throws BirtException {
        DataRequestSession requestSession = null;
        try {
            DataSessionContext context = new DataSessionContext(3, dataSet.getModuleHandle(), null);
            requestSession = DataRequestSession.newSession((DataSessionContext)context);
            IModelAdapter modelAdaptor = requestSession.getModelAdaptor();
            DataSourceHandle dataSource = dataSet.getDataSource();
            BaseDataSourceDesign sourceDesign = modelAdaptor.adaptDataSource(dataSource);
            BaseDataSetDesign dataSetDesign = modelAdaptor.adaptDataSet(dataSet);
            requestSession.clearCache((IBaseDataSourceDesign)sourceDesign, (IBaseDataSetDesign)dataSetDesign);
        }
        finally {
            if (requestSession != null) {
                requestSession.shutdown();
            }
        }
    }

    public List getColumnValueSet(String bindingName, DesignElementHandle elementHandle, IRequestInfo requestInfo) throws BirtException {
        if (bindingName == null || elementHandle == null || !(elementHandle instanceof ReportItemHandle)) {
            return Collections.EMPTY_LIST;
        }
        ReportItemHandle reportItem = this.getBindingHolder(elementHandle);
        if (reportItem == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList selectValueList = new ArrayList();
        DataRequestSession session = DataRequestSession.newSession((DataSessionContext)new DataSessionContext(3, reportItem.getModuleHandle()));
        selectValueList.addAll(session.getColumnValueSet(reportItem.getDataSet(), reportItem.paramBindingsIterator(), reportItem.columnBindingsIterator(), bindingName, requestInfo));
        session.shutdown();
        return selectValueList;
    }

    public List getColumnValueSet(String bindingName, DesignElementHandle elementHandle) throws BirtException {
        if (bindingName == null || elementHandle == null || !(elementHandle instanceof ReportItemHandle)) {
            return Collections.EMPTY_LIST;
        }
        ReportItemHandle reportItem = this.getBindingHolder(elementHandle);
        if (reportItem == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList selectValueList = new ArrayList();
        DataRequestSession session = DataRequestSession.newSession((DataSessionContext)new DataSessionContext(3, reportItem.getModuleHandle()));
        selectValueList.addAll(session.getColumnValueSet(reportItem.getDataSet(), reportItem.paramBindingsIterator(), reportItem.columnBindingsIterator(), bindingName));
        session.shutdown();
        return selectValueList;
    }

    private ReportItemHandle getBindingHolder(DesignElementHandle handle) {
        if (handle instanceof ReportElementHandle) {
            if (handle instanceof ListingHandle) {
                return (ReportItemHandle)handle;
            }
            if (handle instanceof ReportItemHandle && (((ReportItemHandle)handle).getDataSet() != null || ((ReportItemHandle)handle).columnBindingsIterator().hasNext())) {
                return (ReportItemHandle)handle;
            }
            ReportItemHandle result = this.getBindingHolder(handle.getContainer());
            if (result == null && handle instanceof ReportItemHandle) {
                result = (ReportItemHandle)handle;
            }
            return result;
        }
        return null;
    }

    @Deprecated
    public String getMIMEType(String format) {
        return this.engine.getMIMEType(format);
    }

    public EngineConfig getEngineConfig() {
        return this.config;
    }

    public static void shutdown() {
        instance = null;
    }

    @Deprecated
    public static class DummyRemoteException
    extends RemoteException {
        private static final long serialVersionUID = 1L;

        public DummyRemoteException(Throwable cause) {
            super(null, cause);
        }
    }
}

