/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.birt.emitters.excel;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.ITaskOption;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.IListGroupContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITableGroupContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.css.engine.CSSEngine;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import uk.co.spudsoft.birt.emitters.excel.EmitterServices;
import uk.co.spudsoft.birt.emitters.excel.HandlerState;
import uk.co.spudsoft.birt.emitters.excel.StyleManager;
import uk.co.spudsoft.birt.emitters.excel.StyleManagerUtils;
import uk.co.spudsoft.birt.emitters.excel.framework.ExcelEmitterPlugin;
import uk.co.spudsoft.birt.emitters.excel.framework.Logger;
import uk.co.spudsoft.birt.emitters.excel.handlers.PageHandler;

public abstract class ExcelEmitter
implements IContentEmitter {
    public static final String DEBUG = "ExcelEmitter.DEBUG";
    public static final String REMOVE_BLANK_ROWS = "ExcelEmitter.RemoveBlankRows";
    public static final String ROTATION_PROP = "ExcelEmitter.Rotation";
    public static final String FORCEAUTOCOLWIDTHS_PROP = "ExcelEmitter.ForceAutoColWidths";
    public static final String SINGLE_SHEET = "ExcelEmitter.SingleSheet";
    public static final String SINGLE_SHEET_PAGE_BREAKS = "ExcelEmitter.SingleSheetWithPageBreaks";
    public static final String IMAGE_SCALING_CELL_DIMENSION = "ExcelEmitter.ImageScalingToCellDimension";
    public static final String PRINT_BREAK_AFTER = "ExcelEmitter.InsertPrintBreakAfter";
    public static final String DISABLE_GROUPING = "ExcelEmitter.DisableGrouping";
    public static final String STRUCTURED_HEADER = "ExcelEmitter.StructuredHeader";
    public static final String CUSTOM_NUMBER_FORMAT = "ExcelEmitter.CustomNumberFormat";
    public static final String AUTO_FILTER = "ExcelEmitter.AutoFilter";
    public static final String SHEET_PASSWORD = "ExcelEmitter.SheetProtectPassword";
    public static final String GROUP_SUMMARY_HEADER = "ExcelEmitter.GroupSummaryHeader";
    public static final String FREEZE_PANES = "ExcelEmitter.FreezePanes";
    public static final String BLANK_ROW_AFTER_TOP_LEVEL_TABLE = "ExcelEmitter.BlankRowAfterTopLevelTable";
    public static final String SPANNED_ROW_HEIGHT = "ExcelEmitter.SpannedRowHeight";
    public static final String NEST_TABLE_IN_LAST_CELL = "ExcelEmitter.NestedTableInLastCell";
    public static final int SPANNED_ROW_HEIGHT_SPREAD = 0;
    public static final int SPANNED_ROW_HEIGHT_FIRST = 1;
    public static final int SPANNED_ROW_HEIGHT_IGNORED = 2;
    public static final String PRINT_SCALE = "ExcelEmitter.PrintScale";
    public static final String PRINT_PAGES_WIDE = "ExcelEmitter.PrintPagesWide";
    public static final String PRINT_PAGES_HIGH = "ExcelEmitter.PrintPagesHigh";
    public static final String DISPLAYFORMULAS_PROP = "ExcelEmitter.DisplayFormulas";
    public static final String DISPLAYGRIDLINES_PROP = "ExcelEmitter.DisplayGridlines";
    public static final String DISPLAYROWCOLHEADINGS_PROP = "ExcelEmitter.DisplayRowColHeadings";
    public static final String DISPLAYZEROS_PROP = "ExcelEmitter.DisplayZeros";
    public static final String VALUE_AS_FORMULA = "ExcelEmitter.ValueAsFormula";
    public static final String FORMULA = "ExcelEmitter.Formula";
    public static final String TEMPLATE_FILE = "ExcelEmitter.TemplateFile";
    public static final String STREAMING_XLSX = "ExcelEmitter.StreamingXlsx";
    public static final String FORCE_RECALCULATION = "ExcelEmitter.ForceRecalculation";
    public static final String PRINTGRIDLINES_PROP = "ExcelEmitter.PrintGridlines";
    public static final String PRINTROWCOLHEADINGS_PROP = "ExcelEmitter.PrintRowColHeadings";
    public static final String PRINTFITTOPAGE_PROP = "ExcelEmitter.PrintFitToPage";
    public static final String DISPLAY_SHEET_ZOOM = "ExcelEmitter.DisplaySheetZoom";
    public static final String PAGE_PREVIEW = "ExcelEmitter.PagePreview";
    public static final String DISPLAY_TEXT_INDENT = "ExcelEmitter.DisplayTextIndent";
    public static final String TEXT_INDENT_MODE = "ExcelEmitter.TextIndentMode";
    public static final short poiExcelDisplaySheetZoomScaleMin = 10;
    public static final short poiExcelDisplaySheetZoomScaleMax = 400;
    public static final short poiExcelPrintScaleMin = 10;
    public static final short poiExcelPrintScaleMax = 400;
    public static final String poiExcelPreviewPageLayout = "PageLayout";
    public static final String poiExcelPreviewPageBreak = "PageBreak";
    public static final String TEXT_INDENT_MODE_SPACING_CELL = "SpacingCell";
    public static final String TEXT_INDENT_MODE_SPACING_ELEMENT = "SpacingElement";
    public static final String TEXT_INDENT_MODE_SPACING_ALL = "SpacingAll";
    protected Logger log;
    protected OutputStream reportOutputStream;
    protected boolean outputStreamOpened;
    protected String reportOutputFilename;
    private HandlerState handlerState;
    private IRenderOption renderOptions;
    private IPageContent lastPage;
    private StyleManagerUtils.Factory utilsFactory;

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected ExcelEmitter(StyleManagerUtils.Factory utilsFactory) {
        block3: {
            super();
            this.utilsFactory = utilsFactory;
            try {
                this.log = ExcelEmitterPlugin.getDefault() != null ? ExcelEmitterPlugin.getDefault().getLogger() : new Logger(this.getClass().getPackage().getName());
                this.log.debug(new Object[]{"ExcelEmitter"});
                break block3;
            }
            catch (Exception ex) {
                t /* !! */  = ex;
                ** while (t /* !! */  != null)
            }
lbl-1000:
            // 1 sources

            {
                this.log.debug(new Object[]{t /* !! */ .getMessage()});
                t /* !! */ .printStackTrace();
                t /* !! */  = t /* !! */ .getCause();
                continue;
            }
        }
    }

    protected abstract Workbook createWorkbook();

    protected abstract Workbook createSWorkbook();

    protected abstract Workbook openWorkbook(File var1) throws IOException;

    @Override
    public void initialize(IEmitterServices service) throws BirtException {
        this.renderOptions = service.getRenderOption();
        boolean debug = EmitterServices.booleanOption((ITaskOption)this.renderOptions, null, DEBUG, false);
        this.log.setDebug(debug);
        this.log.debug("inintialize");
        this.reportOutputStream = service.getRenderOption().getOutputStream();
        this.reportOutputFilename = service.getRenderOption().getOutputFileName();
        if (this.reportOutputStream == null && (this.reportOutputFilename == null || this.reportOutputFilename.isEmpty())) {
            throw new BirtException(EmitterServices.getPluginName(), "Neither output stream nor output filename have been specified", null);
        }
    }

    @Override
    public void start(IReportContent report) throws BirtException {
        Workbook wb;
        this.log.addPrefix('>');
        this.log.info(0, "start:" + report.toString(), null);
        String templatePath = EmitterServices.stringOption((ITaskOption)this.renderOptions, report, TEMPLATE_FILE, null);
        if (templatePath != null) {
            File templateFile;
            URL templateURL = report.getReportContext().getResource(templatePath);
            try {
                templateFile = new File(templateURL.toURI());
            }
            catch (URISyntaxException ex) {
                throw new BirtException(EmitterServices.getPluginName(), "Unable locate template resource for " + templatePath, (Object)ex);
            }
            try {
                wb = this.openWorkbook(templateFile);
            }
            catch (IOException ex) {
                throw new BirtException(EmitterServices.getPluginName(), "Unable to open template workbook for " + templateFile.toString(), (Object)ex);
            }
        }
        wb = EmitterServices.booleanOption((ITaskOption)this.renderOptions, report, STREAMING_XLSX, false) ? this.createSWorkbook() : this.createWorkbook();
        CSSEngine cssEngine = report.getRoot().getCSSEngine();
        StyleManagerUtils smu = this.utilsFactory.create(this.log);
        StyleManager sm = new StyleManager(wb, this.log, smu, cssEngine, report.getReportContext().getLocale());
        this.handlerState = new HandlerState(this, this.log, smu, wb, sm, this.renderOptions);
        this.handlerState.setHandler(new PageHandler(this.log, null));
        if (EmitterServices.booleanOption((ITaskOption)this.handlerState.getRenderOptions(), report, SINGLE_SHEET_PAGE_BREAKS, false)) {
            this.handlerState.getRenderOptions().setOption(SINGLE_SHEET, Boolean.TRUE);
        }
        if (EmitterServices.booleanOption((ITaskOption)this.renderOptions, report, FORCE_RECALCULATION, false)) {
            wb.setForceFormulaRecalculation(true);
        }
    }

    @Override
    public void end(IReportContent report) throws BirtException {
        if (EmitterServices.booleanOption((ITaskOption)this.handlerState.getRenderOptions(), report, SINGLE_SHEET, false)) {
            this.handlerState.reportEnding = true;
            this.handlerState.getHandler().endPage(this.handlerState, this.lastPage);
        }
        this.log.removePrefix('>');
        this.log.debug("end:", report);
        String reportTitle = this.handlerState.correctSheetName(report.getTitle());
        if (this.handlerState.getWb().getNumberOfSheets() == 1 && reportTitle != null) {
            this.handlerState.getWb().setSheetName(0, reportTitle);
        }
        OutputStream outputStream = this.reportOutputStream;
        try {
            try {
                if (outputStream == null && this.reportOutputFilename != null && !this.reportOutputFilename.isEmpty()) {
                    try {
                        outputStream = new FileOutputStream(this.reportOutputFilename);
                    }
                    catch (IOException ex) {
                        this.log.warn(0, "File \"" + this.reportOutputFilename + "\" cannot be opened for writing", ex);
                        throw new BirtException(EmitterServices.getPluginName(), "Unable to open file (\"{}\") for writing", new Object[]{this.reportOutputFilename}, null, (Throwable)ex);
                    }
                }
                this.handlerState.getWb().write(outputStream);
            }
            catch (Throwable ex) {
                this.log.debug("ex:", ex.toString());
                ex.printStackTrace();
                throw new BirtException(EmitterServices.getPluginName(), "Unable to save file (\"{}\")", new Object[]{this.reportOutputFilename}, null, ex);
            }
        }
        catch (Throwable throwable) {
            if (this.reportOutputStream == null) {
                try {
                    outputStream.close();
                }
                catch (IOException ex) {
                    this.log.debug("ex:", ex.toString());
                }
            }
            if (this.handlerState.getWb() instanceof SXSSFWorkbook) {
                try {
                    ((SXSSFWorkbook)this.handlerState.getWb()).close();
                }
                catch (IOException ex) {
                    this.log.debug("ex:", ex.toString());
                }
            }
            this.handlerState = null;
            this.reportOutputFilename = null;
            this.reportOutputStream = null;
            throw throwable;
        }
        if (this.reportOutputStream == null) {
            try {
                outputStream.close();
            }
            catch (IOException ex) {
                this.log.debug("ex:", ex.toString());
            }
        }
        if (this.handlerState.getWb() instanceof SXSSFWorkbook) {
            try {
                ((SXSSFWorkbook)this.handlerState.getWb()).close();
            }
            catch (IOException ex) {
                this.log.debug("ex:", ex.toString());
            }
        }
        this.handlerState = null;
        this.reportOutputFilename = null;
        this.reportOutputStream = null;
    }

    @Override
    public void startPage(IPageContent page) throws BirtException {
        this.log.addPrefix('P');
        this.log.debug(this.handlerState, "startPage: ");
        this.handlerState.getHandler().startPage(this.handlerState, page);
    }

    @Override
    public void endPage(IPageContent page) throws BirtException {
        this.lastPage = page;
        this.log.debug(this.handlerState, "endPage: ");
        this.handlerState.getHandler().endPage(this.handlerState, page);
        this.log.removePrefix('P');
    }

    @Override
    public void startTable(ITableContent table) throws BirtException {
        this.log.addPrefix('T');
        this.log.debug(this.handlerState, "startTable: ");
        this.handlerState.getHandler().startTable(this.handlerState, table);
    }

    @Override
    public void endTable(ITableContent table) throws BirtException {
        this.log.debug(this.handlerState, "endTable: ");
        this.handlerState.getHandler().endTable(this.handlerState, table);
        this.log.removePrefix('T');
    }

    @Override
    public void startTableBand(ITableBandContent band) throws BirtException {
        this.log.addPrefix('B');
        this.log.debug(this.handlerState, "startTableBand: ");
        this.handlerState.getHandler().startTableBand(this.handlerState, band);
    }

    @Override
    public void endTableBand(ITableBandContent band) throws BirtException {
        this.log.debug(this.handlerState, "endTableBand: ");
        this.handlerState.getHandler().endTableBand(this.handlerState, band);
        this.log.removePrefix('B');
    }

    @Override
    public void startRow(IRowContent row) throws BirtException {
        this.log.addPrefix('R');
        this.log.debug(this.handlerState, "startRow: ");
        this.handlerState.getHandler().startRow(this.handlerState, row);
    }

    @Override
    public void endRow(IRowContent row) throws BirtException {
        this.log.debug(this.handlerState, "endRow: ");
        this.handlerState.getHandler().endRow(this.handlerState, row);
        this.log.removePrefix('R');
    }

    @Override
    public void startCell(ICellContent cell) throws BirtException {
        this.log.addPrefix('C');
        this.log.debug(this.handlerState, "startCell: ");
        this.handlerState.getHandler().startCell(this.handlerState, cell);
    }

    @Override
    public void endCell(ICellContent cell) throws BirtException {
        this.log.debug(this.handlerState, "endCell: ");
        this.handlerState.getHandler().endCell(this.handlerState, cell);
        this.log.removePrefix('C');
    }

    @Override
    public void startList(IListContent list) throws BirtException {
        this.log.addPrefix('L');
        this.log.debug(this.handlerState, "startList: ");
        this.handlerState.getHandler().startList(this.handlerState, list);
    }

    @Override
    public void endList(IListContent list) throws BirtException {
        this.log.debug(this.handlerState, "endList: ");
        this.handlerState.getHandler().endList(this.handlerState, list);
        this.log.removePrefix('L');
    }

    @Override
    public void startListBand(IListBandContent listBand) throws BirtException {
        this.log.addPrefix('B');
        this.log.debug(this.handlerState, "startListBand: ");
        this.handlerState.getHandler().startListBand(this.handlerState, listBand);
    }

    @Override
    public void endListBand(IListBandContent listBand) throws BirtException {
        this.log.debug(this.handlerState, "endListBand: ");
        this.handlerState.getHandler().endListBand(this.handlerState, listBand);
        this.log.removePrefix('B');
    }

    @Override
    public void startContainer(IContainerContent container) throws BirtException {
        this.log.addPrefix('O');
        this.log.debug(this.handlerState, "startContainer: ");
        this.handlerState.getHandler().startContainer(this.handlerState, container);
    }

    @Override
    public void endContainer(IContainerContent container) throws BirtException {
        this.log.debug(this.handlerState, "endContainer: ");
        this.handlerState.getHandler().endContainer(this.handlerState, container);
        this.log.removePrefix('O');
    }

    @Override
    public void startText(ITextContent text) throws BirtException {
        this.log.debug(this.handlerState, "startText: ");
        this.handlerState.getHandler().emitText(this.handlerState, text);
    }

    @Override
    public void startData(IDataContent data) throws BirtException {
        this.log.debug(this.handlerState, "startData: ");
        this.handlerState.getHandler().emitData(this.handlerState, data);
    }

    @Override
    public void startLabel(ILabelContent label) throws BirtException {
        this.log.debug(this.handlerState, "startLabel: ");
        this.handlerState.getHandler().emitLabel(this.handlerState, label);
    }

    @Override
    public void startAutoText(IAutoTextContent autoText) throws BirtException {
        this.log.debug(this.handlerState, "startAutoText: ");
        this.handlerState.getHandler().emitAutoText(this.handlerState, autoText);
    }

    @Override
    public void startForeign(IForeignContent foreign) throws BirtException {
        this.log.debug(this.handlerState, "startForeign: ");
        this.handlerState.getHandler().emitForeign(this.handlerState, foreign);
    }

    @Override
    public void startImage(IImageContent image) throws BirtException {
        this.log.debug(this.handlerState, "startImage: ");
        this.handlerState.getHandler().emitImage(this.handlerState, image);
    }

    @Override
    public void startContent(IContent content) throws BirtException {
        this.log.addPrefix('N');
        this.log.debug(this.handlerState, "startContent: ");
        this.handlerState.getHandler().startContent(this.handlerState, content);
    }

    @Override
    public void endContent(IContent content) throws BirtException {
        this.log.debug(this.handlerState, "endContent: ");
        this.handlerState.getHandler().endContent(this.handlerState, content);
        this.log.removePrefix('N');
    }

    @Override
    public void startGroup(IGroupContent group) throws BirtException {
        this.log.debug(this.handlerState, "startGroup: ");
        this.handlerState.getHandler().startGroup(this.handlerState, group);
    }

    @Override
    public void endGroup(IGroupContent group) throws BirtException {
        this.log.debug(this.handlerState, "endGroup: ");
        this.handlerState.getHandler().endGroup(this.handlerState, group);
    }

    @Override
    public void startTableGroup(ITableGroupContent group) throws BirtException {
        this.log.addPrefix('G');
        this.log.debug(this.handlerState, "startTableGroup: ");
        this.handlerState.getHandler().startTableGroup(this.handlerState, group);
    }

    @Override
    public void endTableGroup(ITableGroupContent group) throws BirtException {
        this.log.debug(this.handlerState, "endTableGroup: ");
        this.handlerState.getHandler().endTableGroup(this.handlerState, group);
        this.log.removePrefix('G');
    }

    @Override
    public void startListGroup(IListGroupContent group) throws BirtException {
        this.log.addPrefix('G');
        this.log.debug(this.handlerState, "startListGroup: ");
        this.handlerState.getHandler().startListGroup(this.handlerState, group);
    }

    @Override
    public void endListGroup(IListGroupContent group) throws BirtException {
        this.log.debug(this.handlerState, "endListGroup: ");
        this.handlerState.getHandler().endListGroup(this.handlerState, group);
        this.log.removePrefix('G');
    }
}

