/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import java.util.HashMap;
import java.util.Map;
import org.w3c.tidy.AttVal;
import org.w3c.tidy.AttrCheckImpl;
import org.w3c.tidy.Attribute;
import org.w3c.tidy.Dict;
import org.w3c.tidy.HtmlVersion;

public class AttributeTable {
    protected static Attribute attrHref;
    protected static Attribute attrSrc;
    protected static Attribute attrId;
    protected static Attribute attrName;
    protected static Attribute attrSummary;
    protected static Attribute attrAlt;
    protected static Attribute attrLongdesc;
    protected static Attribute attrUsemap;
    protected static Attribute attrIsmap;
    protected static Attribute attrLanguage;
    protected static Attribute attrType;
    protected static Attribute attrTitle;
    protected static Attribute attrXmlns;
    protected static Attribute attrValue;
    protected static Attribute attrContent;
    protected static Attribute attrDatafld;
    protected static Attribute attrWidth;
    protected static Attribute attrHeight;
    private static AttributeTable defaultAttributeTable;
    private static final Attribute[] ATTRS;
    private Map<String, Attribute> attributeMap = new HashMap<String, Attribute>();

    public Attribute lookup(String name) {
        return this.attributeMap.get(name);
    }

    public Attribute install(Attribute attr) {
        return this.attributeMap.put(attr.getName(), attr);
    }

    public Attribute findAttribute(AttVal attval) {
        if (attval.attribute != null) {
            Attribute np = this.lookup(attval.attribute);
            return np;
        }
        return null;
    }

    public boolean isUrl(String attrname) {
        Attribute np = this.lookup(attrname);
        return np != null && np.getAttrchk() == AttrCheckImpl.URL;
    }

    public boolean isScript(String attrname) {
        Attribute np = this.lookup(attrname);
        return np != null && np.getAttrchk() == AttrCheckImpl.SCRIPT;
    }

    public boolean isLiteralAttribute(String attrname) {
        Attribute np = this.lookup(attrname);
        return np != null && np.isLiteral();
    }

    public void declareLiteralAttrib(String name) {
        Attribute attrib = this.lookup(name);
        if (attrib == null) {
            attrib = this.install(new Attribute(name, Dict.VERS_PROPRIETARY, null));
        }
        attrib.setLiteral(true);
    }

    public static AttributeTable getDefaultAttributeTable() {
        if (defaultAttributeTable == null) {
            defaultAttributeTable = new AttributeTable();
            for (Attribute ATTR : ATTRS) {
                defaultAttributeTable.install(ATTR);
            }
            attrHref = defaultAttributeTable.lookup("href");
            attrSrc = defaultAttributeTable.lookup("src");
            attrId = defaultAttributeTable.lookup("id");
            attrName = defaultAttributeTable.lookup("name");
            attrSummary = defaultAttributeTable.lookup("summary");
            attrAlt = defaultAttributeTable.lookup("alt");
            attrLongdesc = defaultAttributeTable.lookup("longdesc");
            attrUsemap = defaultAttributeTable.lookup("usemap");
            attrIsmap = defaultAttributeTable.lookup("ismap");
            attrLanguage = defaultAttributeTable.lookup("language");
            attrType = defaultAttributeTable.lookup("type");
            attrTitle = defaultAttributeTable.lookup("title");
            attrXmlns = defaultAttributeTable.lookup("xmlns");
            attrValue = defaultAttributeTable.lookup("value");
            attrContent = defaultAttributeTable.lookup("content");
            attrDatafld = defaultAttributeTable.lookup("datafld");
            attrWidth = defaultAttributeTable.lookup("width");
            attrHeight = defaultAttributeTable.lookup("height");
            attrAlt.setNowrap(true);
            attrValue.setNowrap(true);
            attrContent.setNowrap(true);
        }
        return defaultAttributeTable;
    }

    static {
        ATTRS = new Attribute[]{new Attribute("abbr", Dict.VERS_HTML40, AttrCheckImpl.TEXT), new Attribute("accept-charset", Dict.VERS_HTML40, AttrCheckImpl.CHARSET), new Attribute("accept", Dict.VERS_ALL, AttrCheckImpl.TYPE), new Attribute("accesskey", Dict.VERS_HTML40, AttrCheckImpl.CHARACTER), new Attribute("action", Dict.VERS_ALL, AttrCheckImpl.URL), new Attribute("add_date", Dict.VERS_NETSCAPE, AttrCheckImpl.TEXT), new Attribute("align", Dict.VERS_ALL, AttrCheckImpl.ALIGN), new Attribute("alink", Dict.VERS_LOOSE, AttrCheckImpl.COLOR), new Attribute("alt", Dict.VERS_ALL, AttrCheckImpl.TEXT), new Attribute("archive", Dict.VERS_HTML40, AttrCheckImpl.URLS), new Attribute("axis", Dict.VERS_HTML40, AttrCheckImpl.TEXT), new Attribute("background", Dict.VERS_LOOSE, AttrCheckImpl.URL), new Attribute("bgcolor", Dict.VERS_LOOSE, AttrCheckImpl.COLOR), new Attribute("bgproperties", Dict.VERS_PROPRIETARY, AttrCheckImpl.TEXT), new Attribute("border", Dict.VERS_ALL, AttrCheckImpl.BOOL), new Attribute("bordercolor", Dict.VERS_MICROSOFT, AttrCheckImpl.COLOR), new Attribute("bottommargin", Dict.VERS_MICROSOFT, AttrCheckImpl.NUMBER), new Attribute("cellpadding", Dict.VERS_FROM32, AttrCheckImpl.LENGTH), new Attribute("cellspacing", Dict.VERS_FROM32, AttrCheckImpl.LENGTH), new Attribute("char", Dict.VERS_HTML40, AttrCheckImpl.CHARACTER), new Attribute("charoff", Dict.VERS_HTML40, AttrCheckImpl.LENGTH), new Attribute("charset", Dict.VERS_HTML40, AttrCheckImpl.CHARSET), new Attribute("checked", Dict.VERS_ALL, AttrCheckImpl.BOOL), new Attribute("cite", Dict.VERS_HTML40, AttrCheckImpl.URL), new Attribute("class", Dict.VERS_HTML40, AttrCheckImpl.TEXT), new Attribute("classid", Dict.VERS_HTML40, AttrCheckImpl.URL), new Attribute("clear", Dict.VERS_LOOSE, AttrCheckImpl.CLEAR), new Attribute("code", Dict.VERS_LOOSE, AttrCheckImpl.TEXT), new Attribute("codebase", Dict.VERS_HTML40, AttrCheckImpl.URL), new Attribute("codetype", Dict.VERS_HTML40, AttrCheckImpl.TYPE), new Attribute("color", Dict.VERS_LOOSE, AttrCheckImpl.COLOR), new Attribute("cols", Dict.VERS_IFRAME, AttrCheckImpl.COLS), new Attribute("colspan", Dict.VERS_FROM32, AttrCheckImpl.NUMBER), new Attribute("compact", Dict.VERS_ALL, AttrCheckImpl.BOOL), new Attribute("content", Dict.VERS_ALL, AttrCheckImpl.TEXT), new Attribute("coords", Dict.VERS_FROM32, AttrCheckImpl.COORDS), new Attribute("data", Dict.VERS_HTML40, AttrCheckImpl.URL), new Attribute("datafld", Dict.VERS_MICROSOFT, AttrCheckImpl.TEXT), new Attribute("dataformatas", Dict.VERS_MICROSOFT, AttrCheckImpl.TEXT), new Attribute("datapagesize", Dict.VERS_MICROSOFT, AttrCheckImpl.NUMBER), new Attribute("datasrc", Dict.VERS_MICROSOFT, AttrCheckImpl.URL), new Attribute("datetime", Dict.VERS_HTML40, AttrCheckImpl.DATE), new Attribute("declare", Dict.VERS_HTML40, AttrCheckImpl.BOOL), new Attribute("defer", Dict.VERS_HTML40, AttrCheckImpl.BOOL), new Attribute("dir", Dict.VERS_HTML40, AttrCheckImpl.TEXTDIR), new Attribute("disabled", Dict.VERS_HTML40, AttrCheckImpl.BOOL), new Attribute("enctype", Dict.VERS_ALL, AttrCheckImpl.TYPE), new Attribute("face", Dict.VERS_LOOSE, AttrCheckImpl.TEXT), new Attribute("for", Dict.VERS_HTML40, AttrCheckImpl.IDREF), new Attribute("frame", Dict.VERS_HTML40, AttrCheckImpl.TFRAME), new Attribute("frameborder", Dict.combine(Dict.VERS_IFRAME, (Enum[])new HtmlVersion[]{HtmlVersion.FRAMESET}), AttrCheckImpl.FBORDER), new Attribute("framespacing", Dict.VERS_PROPRIETARY, AttrCheckImpl.NUMBER), new Attribute("gridx", Dict.VERS_PROPRIETARY, AttrCheckImpl.NUMBER), new Attribute("gridy", Dict.VERS_PROPRIETARY, AttrCheckImpl.NUMBER), new Attribute("headers", Dict.VERS_HTML40, AttrCheckImpl.IDREF), new Attribute("height", Dict.VERS_ALL, AttrCheckImpl.LENGTH), new Attribute("href", Dict.VERS_ALL, AttrCheckImpl.URL), new Attribute("hreflang", Dict.VERS_HTML40, AttrCheckImpl.LANG), new Attribute("hspace", Dict.VERS_ALL, AttrCheckImpl.NUMBER), new Attribute("http-equiv", Dict.VERS_ALL, AttrCheckImpl.TEXT), new Attribute("id", Dict.VERS_HTML40, AttrCheckImpl.ID), new Attribute("ismap", Dict.VERS_ALL, AttrCheckImpl.BOOL), new Attribute("label", Dict.VERS_HTML40, AttrCheckImpl.TEXT), new Attribute("lang", Dict.VERS_HTML40, AttrCheckImpl.LANG), new Attribute("language", Dict.VERS_LOOSE, AttrCheckImpl.TEXT), new Attribute("last_modified", Dict.VERS_NETSCAPE, AttrCheckImpl.TEXT), new Attribute("last_visit", Dict.VERS_NETSCAPE, AttrCheckImpl.TEXT), new Attribute("leftmargin", Dict.VERS_MICROSOFT, AttrCheckImpl.NUMBER), new Attribute("link", Dict.VERS_LOOSE, AttrCheckImpl.COLOR), new Attribute("longdesc", Dict.VERS_HTML40, AttrCheckImpl.URL), new Attribute("lowsrc", Dict.VERS_PROPRIETARY, AttrCheckImpl.URL), new Attribute("marginheight", Dict.VERS_IFRAME, AttrCheckImpl.NUMBER), new Attribute("marginwidth", Dict.VERS_IFRAME, AttrCheckImpl.NUMBER), new Attribute("maxlength", Dict.VERS_ALL, AttrCheckImpl.NUMBER), new Attribute("media", Dict.VERS_HTML40, AttrCheckImpl.MEDIA), new Attribute("method", Dict.VERS_ALL, AttrCheckImpl.FSUBMIT), new Attribute("multiple", Dict.VERS_ALL, AttrCheckImpl.BOOL), new Attribute("name", Dict.VERS_ALL, AttrCheckImpl.NAME), new Attribute("nohref", Dict.VERS_FROM32, AttrCheckImpl.BOOL), new Attribute("noresize", Dict.VERS_FRAMESET, AttrCheckImpl.BOOL), new Attribute("noshade", Dict.VERS_LOOSE, AttrCheckImpl.BOOL), new Attribute("nowrap", Dict.VERS_LOOSE, AttrCheckImpl.BOOL), new Attribute("object", Dict.VERS_HTML40_LOOSE, AttrCheckImpl.TEXT), new Attribute("onblur", Dict.VERS_EVENTS, AttrCheckImpl.SCRIPT), new Attribute("onchange", Dict.VERS_EVENTS, AttrCheckImpl.SCRIPT), new Attribute("onclick", Dict.VERS_EVENTS, AttrCheckImpl.SCRIPT), new Attribute("ondblclick", Dict.VERS_EVENTS, AttrCheckImpl.SCRIPT), new Attribute("onkeydown", Dict.VERS_EVENTS, AttrCheckImpl.SCRIPT), new Attribute("onkeypress", Dict.VERS_EVENTS, AttrCheckImpl.SCRIPT), new Attribute("onkeyup", Dict.VERS_EVENTS, AttrCheckImpl.SCRIPT), new Attribute("onload", Dict.VERS_EVENTS, AttrCheckImpl.SCRIPT), new Attribute("onmousedown", Dict.VERS_EVENTS, AttrCheckImpl.SCRIPT), new Attribute("onmousemove", Dict.VERS_EVENTS, AttrCheckImpl.SCRIPT), new Attribute("onmouseout", Dict.VERS_EVENTS, AttrCheckImpl.SCRIPT), new Attribute("onmouseover", Dict.VERS_EVENTS, AttrCheckImpl.SCRIPT), new Attribute("onmouseup", Dict.VERS_EVENTS, AttrCheckImpl.SCRIPT), new Attribute("onsubmit", Dict.VERS_EVENTS, AttrCheckImpl.SCRIPT), new Attribute("onreset", Dict.VERS_EVENTS, AttrCheckImpl.SCRIPT), new Attribute("onselect", Dict.VERS_EVENTS, AttrCheckImpl.SCRIPT), new Attribute("onunload", Dict.VERS_EVENTS, AttrCheckImpl.SCRIPT), new Attribute("onfocus", Dict.VERS_EVENTS, AttrCheckImpl.SCRIPT), new Attribute("onafterupdate", Dict.VERS_MICROSOFT, AttrCheckImpl.SCRIPT), new Attribute("onbeforeupdate", Dict.VERS_MICROSOFT, AttrCheckImpl.SCRIPT), new Attribute("onerrorupdate", Dict.VERS_MICROSOFT, AttrCheckImpl.SCRIPT), new Attribute("onrowenter", Dict.VERS_MICROSOFT, AttrCheckImpl.SCRIPT), new Attribute("onrowexit", Dict.VERS_MICROSOFT, AttrCheckImpl.SCRIPT), new Attribute("onbeforeunload", Dict.VERS_MICROSOFT, AttrCheckImpl.SCRIPT), new Attribute("ondatasetchanged", Dict.VERS_MICROSOFT, AttrCheckImpl.SCRIPT), new Attribute("ondataavailable", Dict.VERS_MICROSOFT, AttrCheckImpl.SCRIPT), new Attribute("ondatasetcomplete", Dict.VERS_MICROSOFT, AttrCheckImpl.SCRIPT), new Attribute("profile", Dict.VERS_HTML40, AttrCheckImpl.URL), new Attribute("prompt", Dict.VERS_LOOSE, AttrCheckImpl.TEXT), new Attribute("readonly", Dict.VERS_HTML40, AttrCheckImpl.BOOL), new Attribute("rel", Dict.VERS_ALL, AttrCheckImpl.LINKTYPES), new Attribute("rev", Dict.VERS_ALL, AttrCheckImpl.LINKTYPES), new Attribute("rightmargin", Dict.VERS_MICROSOFT, AttrCheckImpl.NUMBER), new Attribute("rows", Dict.VERS_ALL, AttrCheckImpl.NUMBER), new Attribute("rowspan", Dict.VERS_ALL, AttrCheckImpl.NUMBER), new Attribute("rules", Dict.VERS_HTML40, AttrCheckImpl.TRULES), new Attribute("scheme", Dict.VERS_HTML40, AttrCheckImpl.TEXT), new Attribute("scope", Dict.VERS_HTML40, AttrCheckImpl.SCOPE), new Attribute("scrolling", Dict.VERS_IFRAME, AttrCheckImpl.SCROLL), new Attribute("selected", Dict.VERS_ALL, AttrCheckImpl.BOOL), new Attribute("shape", Dict.VERS_FROM32, AttrCheckImpl.SHAPE), new Attribute("showgrid", Dict.VERS_PROPRIETARY, AttrCheckImpl.BOOL), new Attribute("showgridx", Dict.VERS_PROPRIETARY, AttrCheckImpl.BOOL), new Attribute("showgridy", Dict.VERS_PROPRIETARY, AttrCheckImpl.BOOL), new Attribute("size", Dict.VERS_LOOSE, AttrCheckImpl.NUMBER), new Attribute("span", Dict.VERS_HTML40, AttrCheckImpl.NUMBER), new Attribute("src", Dict.VERS_ALL, AttrCheckImpl.URL), new Attribute("standby", Dict.VERS_HTML40, AttrCheckImpl.TEXT), new Attribute("start", Dict.VERS_ALL, AttrCheckImpl.NUMBER), new Attribute("style", Dict.VERS_HTML40, AttrCheckImpl.TEXT), new Attribute("summary", Dict.VERS_HTML40, AttrCheckImpl.TEXT), new Attribute("tabindex", Dict.VERS_HTML40, AttrCheckImpl.NUMBER), new Attribute("target", Dict.VERS_HTML40, AttrCheckImpl.TARGET), new Attribute("text", Dict.VERS_LOOSE, AttrCheckImpl.COLOR), new Attribute("title", Dict.VERS_HTML40, AttrCheckImpl.TEXT), new Attribute("topmargin", Dict.VERS_MICROSOFT, AttrCheckImpl.NUMBER), new Attribute("type", Dict.VERS_FROM32, AttrCheckImpl.TYPE), new Attribute("usemap", Dict.VERS_ALL, AttrCheckImpl.BOOL), new Attribute("valign", Dict.VERS_FROM32, AttrCheckImpl.VALIGN), new Attribute("value", Dict.VERS_ALL, AttrCheckImpl.TEXT), new Attribute("valuetype", Dict.VERS_HTML40, AttrCheckImpl.VTYPE), new Attribute("version", Dict.VERS_ALL, AttrCheckImpl.TEXT), new Attribute("vlink", Dict.VERS_LOOSE, AttrCheckImpl.COLOR), new Attribute("vspace", Dict.VERS_LOOSE, AttrCheckImpl.NUMBER), new Attribute("width", Dict.VERS_ALL, AttrCheckImpl.LENGTH), new Attribute("wrap", Dict.VERS_NETSCAPE, AttrCheckImpl.TEXT), new Attribute("xml:lang", Dict.VERS_XML, AttrCheckImpl.TEXT), new Attribute("xml:space", Dict.VERS_XML, AttrCheckImpl.TEXT), new Attribute("xmlns", Dict.VERS_ALL, AttrCheckImpl.TEXT), new Attribute("rbspan", Dict.VERS_XHTML11, AttrCheckImpl.NUMBER)};
    }
}

