/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.re;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.extension.ReportItemPreparationBase;
import org.eclipse.birt.report.item.crosstab.core.CrosstabException;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.core.script.internal.handler.CrosstabPreparationHandler;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;

public class CrosstabReportItemPreparation
extends ReportItemPreparationBase {
    @Override
    public void prepare() throws BirtException {
        if (!(this.handle instanceof ExtendedItemHandle)) {
            return;
        }
        CrosstabReportItemHandle crosstab = (CrosstabReportItemHandle)((ExtendedItemHandle)this.handle).getReportItem();
        if (crosstab == null) {
            return;
        }
        Object hideDetail = this.handle.getProperty("hideDetail");
        if (hideDetail != null) {
            if (hideDetail.toString().toLowerCase().equals("row")) {
                this.hideDetail(crosstab, true);
            } else if (hideDetail.toString().toLowerCase().equals("column")) {
                this.hideDetail(crosstab, false);
            } else {
                throw new CrosstabException(Messages.getString("CrosstabReportItemPreparation.Exception.HideDetailPropertyValueIsWrong", new String[]{"hideDetail", "row", "column"}));
            }
        }
        ExtendedItemHandle modelHandle = (ExtendedItemHandle)crosstab.getModelHandle();
        String javaClass = modelHandle.getEventHandlerClass();
        String script = modelHandle.getOnPrepare();
        if (javaClass != null && javaClass.trim().length() > 0 || script != null && script.trim().length() > 0) {
            this.context.evaluate("1");
        }
        new CrosstabPreparationHandler(crosstab, this.context).handle();
    }

    private void hideDetail(CrosstabReportItemHandle crosstab, boolean hideRow) throws BirtException {
        String ZERO = "0in";
        for (MeasureViewHandle mv : crosstab.getAllMeasures()) {
            AggregationCellHandle cell = mv.getCell();
            if (hideRow) {
                this.clearCellContents(cell);
                this.clearCellContents(mv.getAggregationCell(cell.getDimensionName(0), cell.getLevelName(0), null, null));
                continue;
            }
            cell.getModelHandle().setProperty("width", "0in");
        }
        if (hideRow) {
            int dimCount = crosstab.getDimensionCount(0);
            int i = 0;
            while (i < dimCount) {
                DimensionViewHandle dim = crosstab.getDimension(0, i);
                int j = 0;
                while (j < dim.getLevelCount()) {
                    LevelViewHandle level = dim.getLevel(j);
                    this.clearCellContents(level.getCell());
                    ++j;
                }
                ++i;
            }
            this.handle.setProperty("hideMeasureHeader", true);
        }
        int NO_PAGE_BREAK = 10000;
        crosstab.getModelHandle().setProperty(hideRow ? "rowPageBreakInterval" : "columnPageBreakInterval", 10000);
        ((ReportDesignHandle)crosstab.getModuleHandle()).setLayoutPreference("fixed layout");
    }

    private void clearCellContents(CrosstabCellHandle cell) throws BirtException {
        if (cell != null) {
            cell.getModelHandle().setProperty("borderTopStyle", "none");
            cell.getModelHandle().setProperty("borderBottomStyle", "none");
            cell.getModelHandle().setProperty("borderLeftStyle", "none");
            cell.getModelHandle().setProperty("borderRightStyle", "none");
            String ZERO = "0pt";
            cell.getModelHandle().setProperty("paddingTop", "0pt");
            cell.getModelHandle().setProperty("paddingBottom", "0pt");
            cell.getModelHandle().setProperty("paddingLeft", "0pt");
            cell.getModelHandle().setProperty("paddingRight", "0pt");
            for (Object child : cell.getContents()) {
                if (!(child instanceof DesignElementHandle)) continue;
                DesignElementHandle designElement = (DesignElementHandle)child;
                designElement.setProperty("display", "none");
            }
        }
    }
}

