/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.script;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.JavascriptEvalUtil;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.ExprEvaluateUtil;
import org.eclipse.birt.data.engine.i18n.DataResourceHandle;
import org.eclipse.birt.data.engine.impl.ExprManager;
import org.eclipse.birt.data.engine.impl.IExecutorHelper;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JSResultSetRow
extends ScriptableObject {
    private IResultIterator odiResult;
    private ExprManager exprManager;
    private Scriptable scope;
    private IExecutorHelper helper;
    private ScriptContext cx;
    private int currRowIndex;
    private Map valueCacheMap;
    private static final long serialVersionUID = 649424371394281464L;

    public JSResultSetRow(IResultIterator odiResult, ExprManager exprManager, Scriptable scope, IExecutorHelper helper, ScriptContext cx) {
        this.odiResult = odiResult;
        this.exprManager = exprManager;
        this.scope = scope;
        this.helper = helper;
        this.cx = cx;
        this.currRowIndex = -1;
        this.valueCacheMap = new HashMap();
    }

    public JSResultSetRow(IResultIterator odiResult, JSResultSetRow jsResult) {
        this(odiResult, jsResult.exprManager, jsResult.scope, jsResult.helper, jsResult.cx);
    }

    public String getClassName() {
        return "ResultSetRow";
    }

    public boolean has(int index, Scriptable start) {
        return this.has(String.valueOf(index), start);
    }

    public boolean has(String name, Scriptable start) {
        try {
            return this.exprManager.getExpr(name) != null;
        }
        catch (DataException e) {
            return false;
        }
    }

    public Object get(int index, Scriptable start) {
        return this.get(String.valueOf(index), start);
    }

    public Object get(String name, Scriptable start) {
        if ("_outer".equalsIgnoreCase(name)) {
            if (this.helper.getParent() != null) {
                return this.helper.getParent().getScriptable();
            }
            throw Context.reportRuntimeError((String)DataResourceHandle.getInstance().getMessage("data.engine.NoOuterResultsExist"));
        }
        int rowIndex = -1;
        try {
            rowIndex = this.odiResult.getCurrentResultIndex();
        }
        catch (BirtException birtException) {
            // empty catch block
        }
        if ("__rownum".equalsIgnoreCase(name) || "0".equalsIgnoreCase(name)) {
            return rowIndex;
        }
        if (rowIndex == this.currRowIndex && this.valueCacheMap.containsKey(name)) {
            return this.valueCacheMap.get(name);
        }
        Object value = null;
        try {
            IBinding binding = this.exprManager.getBinding(name);
            if (binding == null) {
                throw Context.reportRuntimeError((String)DataResourceHandle.getInstance().getMessage("data.engine.InvalidBoundColumnName", new String[]{name}));
            }
            if (binding.getAggrFunction() != null) {
                return JavascriptEvalUtil.convertToJavascriptValue(DataTypeUtil.convert(this.odiResult.getAggrValue(name), binding.getDataType()), this.scope);
            }
            IBaseExpression dataExpr = this.exprManager.getExpr(name);
            if (dataExpr == null) {
                throw Context.reportRuntimeError((String)DataResourceHandle.getInstance().getMessage("data.engine.InvalidBoundColumnName", new String[]{name}));
            }
            value = ExprEvaluateUtil.evaluateValue(dataExpr, this.odiResult.getCurrentResultIndex(), this.odiResult.getCurrentResult(), this.scope, this.cx);
            value = JavascriptEvalUtil.convertToJavascriptValue(DataTypeUtil.convert(value, binding.getDataType()), this.scope);
        }
        catch (BirtException e) {
            throw Context.reportRuntimeError((String)e.getLocalizedMessage());
        }
        if (this.currRowIndex != rowIndex) {
            this.valueCacheMap.clear();
            this.currRowIndex = rowIndex;
        }
        this.valueCacheMap.put(name, value);
        return value;
    }

    public Object getValue(IResultObject rsObject, int index, String name) throws DataException {
        Object value = null;
        if (name.startsWith("_{")) {
            try {
                value = rsObject.getFieldValue(name);
            }
            catch (DataException dataException) {}
        } else {
            IBaseExpression dataExpr = this.exprManager.getExpr(name);
            try {
                value = ExprEvaluateUtil.evaluateValue(dataExpr, -1, rsObject, this.scope, this.cx);
            }
            catch (BirtException birtException) {
                // empty catch block
            }
        }
        return value;
    }

    public void put(int index, Scriptable scope, Object value) {
        throw new IllegalArgumentException("Put value on result set row is not supported.");
    }

    public void put(String name, Scriptable scope, Object value) {
        throw new IllegalArgumentException("Put value on result set row is not supported.");
    }

    public IResultIterator getOdiResult() {
        return this.odiResult;
    }

    public IBinding getBinding(String name) throws DataException {
        return this.exprManager.getBinding(name);
    }
}

