/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.ij;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.List;
import org.apache.derby.iapi.tools.ToolUtils;
import org.apache.derby.impl.tools.ij.ijResultImpl;

public class ijMultipleResultSetResult
extends ijResultImpl {
    private ArrayList<ResultSet> resultSets = new ArrayList();
    private int[] displayColumns = null;
    private int[] columnWidths = null;

    public ijMultipleResultSetResult(List<ResultSet> resultSets, int[] display, int[] widths) throws SQLException {
        this.resultSets.addAll(resultSets);
        this.displayColumns = ToolUtils.copy(display);
        this.columnWidths = ToolUtils.copy(widths);
    }

    public void addResultSet(ResultSet rs) {
        this.resultSets.add(rs);
    }

    @Override
    public boolean isMultipleResultSetResult() {
        return true;
    }

    @Override
    public List<ResultSet> getMultipleResultSets() {
        return new ArrayList<ResultSet>(this.resultSets);
    }

    @Override
    public void closeStatement() throws SQLException {
        if (this.resultSets != null) {
            ResultSet rs = null;
            for (int i = 0; i < this.resultSets.size(); ++i) {
                rs = this.resultSets.get(i);
                if (rs.getStatement() != null) {
                    rs.getStatement().close();
                    continue;
                }
                rs.close();
            }
        }
    }

    @Override
    public int[] getColumnDisplayList() {
        return ToolUtils.copy(this.displayColumns);
    }

    @Override
    public int[] getColumnWidthList() {
        return ToolUtils.copy(this.columnWidths);
    }

    @Override
    public SQLWarning getSQLWarnings() throws SQLException {
        SQLWarning warning = null;
        ResultSet rs = null;
        for (int i = 0; i < this.resultSets.size(); ++i) {
            rs = this.resultSets.get(i);
            if (rs.getWarnings() == null) continue;
            if (warning == null) {
                warning = rs.getWarnings();
                continue;
            }
            warning.setNextWarning(rs.getWarnings());
        }
        return warning;
    }

    @Override
    public void clearSQLWarnings() throws SQLException {
        for (int i = 0; i < this.resultSets.size(); ++i) {
            this.resultSets.get(i).clearWarnings();
        }
    }
}

