/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;

class SubstituteExpressionVisitor
implements Visitor {
    private ValueNode source;
    private ValueNode target;
    private Class<?> skipOverClass;

    SubstituteExpressionVisitor(ValueNode s, ValueNode t, Class<?> skipThisClass) {
        this.source = s;
        this.target = t;
        this.skipOverClass = skipThisClass;
    }

    ValueNode getSource() {
        return this.source;
    }

    @Override
    public Visitable visit(Visitable node) throws StandardException {
        if (!(node instanceof ValueNode)) {
            return node;
        }
        ValueNode nd = (ValueNode)node;
        if (nd.isEquivalent(this.source)) {
            return this.target;
        }
        return node;
    }

    @Override
    public boolean stopTraversal() {
        return false;
    }

    @Override
    public boolean skipChildren(Visitable node) {
        return this.skipOverClass == null ? false : this.skipOverClass.isInstance(node);
    }

    @Override
    public boolean visitChildrenFirst(Visitable node) {
        return false;
    }
}

