/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.table;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.Area;
import org.apache.fop.area.Block;
import org.apache.fop.area.Trait;
import org.apache.fop.fo.flow.Marker;
import org.apache.fop.fo.flow.table.GridUnit;
import org.apache.fop.fo.flow.table.PrimaryGridUnit;
import org.apache.fop.fo.flow.table.Table;
import org.apache.fop.fo.flow.table.TableCell;
import org.apache.fop.fo.flow.table.TableColumn;
import org.apache.fop.fo.flow.table.TableFooter;
import org.apache.fop.fo.flow.table.TableHeader;
import org.apache.fop.fo.flow.table.TablePart;
import org.apache.fop.fo.flow.table.TableRow;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.layoutmgr.AbstractLayoutManager;
import org.apache.fop.layoutmgr.AreaAdditionUtil;
import org.apache.fop.layoutmgr.BlockStackingLayoutManager;
import org.apache.fop.layoutmgr.ElementListObserver;
import org.apache.fop.layoutmgr.ElementListUtils;
import org.apache.fop.layoutmgr.Keep;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.LocalBreaker;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.RetrieveTableMarkerLayoutManager;
import org.apache.fop.layoutmgr.SpaceResolver;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.table.RowPainter;
import org.apache.fop.layoutmgr.table.TableLayoutManager;
import org.apache.fop.traits.BorderProps;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.util.ListUtil;

public class TableCellLayoutManager
extends BlockStackingLayoutManager {
    private static Log log = LogFactory.getLog(TableCellLayoutManager.class);
    private PrimaryGridUnit primaryGridUnit;
    private Block curBlockArea;
    private int xoffset;
    private int yoffset;
    private int cellIPD;
    private int totalHeight;
    private int usedBPD;
    private boolean emptyCell = true;
    private boolean isDescendantOfTableFooter;
    private boolean isDescendantOfTableHeader;
    private boolean hasRetrieveTableMarker;
    private boolean hasRepeatedHeader;
    private boolean savedAddAreasArguments;
    private PositionIterator savedParentIter;
    private LayoutContext savedLayoutContext;
    private int[] savedSpannedGridRowHeights;
    private int savedStartRow;
    private int savedEndRow;
    private int savedBorderBeforeWhich;
    private int savedBorderAfterWhich;
    private boolean savedFirstOnPage;
    private boolean savedLastOnPage;
    private RowPainter savedPainter;
    private int savedFirstRowHeight;
    private boolean flushArea = true;
    private boolean isLastTrait;

    public TableCellLayoutManager(TableCell node, PrimaryGridUnit pgu) {
        super(node);
        this.setGeneratesBlockArea(true);
        this.primaryGridUnit = pgu;
        this.isDescendantOfTableHeader = node.getParent().getParent() instanceof TableHeader || node.getParent() instanceof TableHeader;
        this.isDescendantOfTableFooter = node.getParent().getParent() instanceof TableFooter || node.getParent() instanceof TableFooter;
        this.hasRetrieveTableMarker = node.hasRetrieveTableMarker();
    }

    public TableCell getTableCell() {
        return (TableCell)this.fobj;
    }

    private boolean isSeparateBorderModel() {
        return this.getTable().isSeparateBorderModel();
    }

    public Table getTable() {
        return this.getTableCell().getTable();
    }

    public void setHasRepeatedHeader(boolean hasRepeatedHeader) {
        this.hasRepeatedHeader = hasRepeatedHeader;
    }

    @Override
    protected int getIPIndents() {
        int[] startEndBorderWidths = this.primaryGridUnit.getStartEndBorderWidths();
        this.startIndent = startEndBorderWidths[0];
        this.endIndent = startEndBorderWidths[1];
        if (this.isSeparateBorderModel()) {
            int borderSep = this.getTable().getBorderSeparation().getLengthPair().getIPD().getLength().getValue(this);
            this.startIndent += borderSep / 2;
            this.endIndent += borderSep / 2;
        } else {
            this.startIndent /= 2;
            this.endIndent /= 2;
        }
        this.startIndent += this.getTableCell().getCommonBorderPaddingBackground().getPaddingStart(false, this);
        this.endIndent += this.getTableCell().getCommonBorderPaddingBackground().getPaddingEnd(false, this);
        return this.startIndent + this.endIndent;
    }

    @Override
    public List getNextKnuthElements(LayoutContext context, int alignment) {
        KnuthElement lastItem;
        List returnedList;
        LayoutManager curLM;
        MinOptMax stackLimit = context.getStackLimitBP();
        this.cellIPD = this.referenceIPD = context.getRefIPD();
        this.cellIPD -= this.getIPIndents();
        LinkedList<ListElement> contentList = new LinkedList<ListElement>();
        LinkedList<KnuthBox> returnList = new LinkedList<KnuthBox>();
        LayoutManager prevLM = null;
        while ((curLM = this.getChildLM()) != null) {
            LayoutContext childLC = LayoutContext.newInstance();
            childLC.setStackLimitBP(context.getStackLimitBP().minus(stackLimit));
            childLC.setRefIPD(this.cellIPD);
            returnedList = curLM.getNextKnuthElements(childLC, alignment);
            if (childLC.isKeepWithNextPending()) {
                log.debug((Object)"child LM signals pending keep with next");
            }
            if (contentList.isEmpty() && childLC.isKeepWithPreviousPending()) {
                this.primaryGridUnit.setKeepWithPrevious(childLC.getKeepWithPreviousPending());
                childLC.clearKeepWithPreviousPending();
            }
            if (prevLM != null && !ElementListUtils.endsWithForcedBreak(contentList)) {
                this.addInBetweenBreak(contentList, context, childLC);
            }
            contentList.addAll(returnedList);
            if (returnedList.isEmpty()) continue;
            if (childLC.isKeepWithNextPending()) {
                context.updateKeepWithNextPending(childLC.getKeepWithNextPending());
                childLC.clearKeepWithNextPending();
            }
            prevLM = curLM;
        }
        this.primaryGridUnit.setKeepWithNext(context.getKeepWithNextPending());
        returnedList = new LinkedList();
        if (!contentList.isEmpty()) {
            this.wrapPositionElements(contentList, returnList);
        } else {
            returnList.add(new KnuthBox(0, this.notifyPos(new Position(this)), true));
        }
        SpaceResolver.resolveElementList(returnList);
        if (((KnuthElement)returnList.get(0)).isForcedBreak()) {
            this.primaryGridUnit.setBreakBefore(((KnuthPenalty)returnList.get(0)).getBreakClass());
            returnList.remove(0);
            assert (!returnList.isEmpty());
        }
        if ((lastItem = (KnuthElement)ListUtil.getLast(returnList)).isForcedBreak()) {
            KnuthPenalty p = (KnuthPenalty)lastItem;
            this.primaryGridUnit.setBreakAfter(p.getBreakClass());
            p.setPenalty(0);
        }
        this.setFinished(true);
        return returnList;
    }

    public void setYOffset(int off) {
        this.yoffset = off;
    }

    public void setXOffset(int off) {
        this.xoffset = off;
    }

    public void setContentHeight(int h) {
        this.usedBPD = h;
    }

    public void setTotalHeight(int h) {
        this.totalHeight = h;
    }

    private void clearRetrieveTableMarkerChildNodes(List<LayoutManager> childrenLMs) {
        if (childrenLMs == null) {
            return;
        }
        int n = childrenLMs.size();
        for (LayoutManager lm : childrenLMs) {
            if (lm == null) {
                return;
            }
            if (lm instanceof RetrieveTableMarkerLayoutManager) {
                ((AbstractLayoutManager)lm).getFObj().clearChildNodes();
                continue;
            }
            List lms = lm.getChildLMs();
            this.clearRetrieveTableMarkerChildNodes(lms);
        }
    }

    private boolean isDescendantOfTableHeaderOrFooter() {
        return this.isDescendantOfTableFooter || this.isDescendantOfTableHeader;
    }

    private void saveAddAreasArguments(PositionIterator parentIter, LayoutContext layoutContext, int[] spannedGridRowHeights, int startRow, int endRow, int borderBeforeWhich, int borderAfterWhich, boolean firstOnPage, boolean lastOnPage, RowPainter painter, int firstRowHeight) {
        if (this.savedAddAreasArguments) {
            return;
        }
        if (this.isDescendantOfTableHeader) {
            this.savedAddAreasArguments = true;
            this.savedParentIter = null;
            this.savedLayoutContext = null;
            this.savedSpannedGridRowHeights = spannedGridRowHeights;
            this.savedStartRow = startRow;
            this.savedEndRow = endRow;
            this.savedBorderBeforeWhich = borderBeforeWhich;
            this.savedBorderAfterWhich = borderAfterWhich;
            this.savedFirstOnPage = firstOnPage;
            this.savedLastOnPage = lastOnPage;
            this.savedPainter = painter;
            this.savedFirstRowHeight = firstRowHeight;
            TableLayoutManager parentTableLayoutManager = this.getTableLayoutManager();
            parentTableLayoutManager.saveTableHeaderTableCellLayoutManagers(this);
            this.flushArea = false;
        }
    }

    private TableLayoutManager getTableLayoutManager() {
        LayoutManager parentLM = this.getParent();
        while (!(parentLM instanceof TableLayoutManager)) {
            parentLM = parentLM.getParent();
        }
        TableLayoutManager tlm = (TableLayoutManager)parentLM;
        return tlm;
    }

    protected void repeatAddAreas() {
        if (this.savedAddAreasArguments) {
            this.addAreas(this.savedParentIter, this.savedLayoutContext, this.savedSpannedGridRowHeights, this.savedStartRow, this.savedEndRow, this.savedBorderBeforeWhich, this.savedBorderAfterWhich, this.savedFirstOnPage, this.savedLastOnPage, this.savedPainter, this.savedFirstRowHeight);
            this.savedAddAreasArguments = false;
        }
    }

    public void addAreas(PositionIterator parentIter, LayoutContext layoutContext, int[] spannedGridRowHeights, int startRow, int endRow, int borderBeforeWhich, int borderAfterWhich, boolean firstOnPage, boolean lastOnPage, RowPainter painter, int firstRowHeight) {
        int paddingRectBPD;
        this.getParentArea(null);
        this.addId();
        int borderBeforeWidth = this.primaryGridUnit.getBeforeBorderWidth(startRow, borderBeforeWhich);
        int borderAfterWidth = this.primaryGridUnit.getAfterBorderWidth(endRow, borderAfterWhich);
        CommonBorderPaddingBackground padding = this.primaryGridUnit.getCell().getCommonBorderPaddingBackground();
        int cellBPD = paddingRectBPD = this.totalHeight - borderBeforeWidth - borderAfterWidth;
        cellBPD -= padding.getPaddingBefore(borderBeforeWhich == 2, this);
        cellBPD -= padding.getPaddingAfter(borderAfterWhich == 2, this);
        this.addBackgroundAreas(painter, firstRowHeight, borderBeforeWidth, paddingRectBPD);
        if (this.isSeparateBorderModel()) {
            if (!this.emptyCell || this.getTableCell().showEmptyCells()) {
                if (borderBeforeWidth > 0) {
                    int halfBorderSepBPD = this.getTableCell().getTable().getBorderSeparation().getBPD().getLength().getValue() / 2;
                    TableCellLayoutManager.adjustYOffset(this.curBlockArea, halfBorderSepBPD);
                }
                TraitSetter.addBorders(this.curBlockArea, this.getTableCell().getCommonBorderPaddingBackground(), borderBeforeWidth == 0, borderAfterWidth == 0, false, false, this);
            }
        } else {
            boolean inLastColumn;
            boolean inFirstColumn = this.primaryGridUnit.getColIndex() == 0;
            boolean bl = inLastColumn = this.primaryGridUnit.getColIndex() + this.getTableCell().getNumberColumnsSpanned() == this.getTable().getNumberOfColumns();
            if (!this.primaryGridUnit.hasSpanning()) {
                TableCellLayoutManager.adjustYOffset(this.curBlockArea, -borderBeforeWidth);
                boolean[] outer = new boolean[]{firstOnPage, lastOnPage, inFirstColumn, inLastColumn};
                TraitSetter.addCollapsingBorders(this.curBlockArea, this.primaryGridUnit.getBorderBefore(borderBeforeWhich), this.primaryGridUnit.getBorderAfter(borderAfterWhich), this.primaryGridUnit.getBorderStart(), this.primaryGridUnit.getBorderEnd(), outer);
            } else {
                int borderWidth;
                CommonBorderPaddingBackground.BorderInfo border;
                GridUnit gu;
                int x;
                TableCellLayoutManager.adjustYOffset(this.curBlockArea, borderBeforeWidth);
                Block[][] blocks = new Block[this.getTableCell().getNumberRowsSpanned()][this.getTableCell().getNumberColumnsSpanned()];
                GridUnit[] gridUnits = this.primaryGridUnit.getRows().get(startRow);
                int level = this.getTableCell().getBidiLevelRecursive();
                for (x = 0; x < this.getTableCell().getNumberColumnsSpanned(); ++x) {
                    gu = gridUnits[x];
                    border = gu.getBorderBefore(borderBeforeWhich);
                    borderWidth = border.getRetainedWidth() / 2;
                    if (borderWidth <= 0) continue;
                    this.addBorder(blocks, startRow, x, Trait.BORDER_BEFORE, border, firstOnPage, level);
                    TableCellLayoutManager.adjustYOffset(blocks[startRow][x], -borderWidth);
                    TableCellLayoutManager.adjustBPD(blocks[startRow][x], -borderWidth);
                }
                gridUnits = this.primaryGridUnit.getRows().get(endRow);
                for (x = 0; x < this.getTableCell().getNumberColumnsSpanned(); ++x) {
                    gu = gridUnits[x];
                    border = gu.getBorderAfter(borderAfterWhich);
                    borderWidth = border.getRetainedWidth() / 2;
                    if (borderWidth <= 0) continue;
                    this.addBorder(blocks, endRow, x, Trait.BORDER_AFTER, border, lastOnPage, level);
                    TableCellLayoutManager.adjustBPD(blocks[endRow][x], -borderWidth);
                }
                for (int y = startRow; y <= endRow; ++y) {
                    gridUnits = this.primaryGridUnit.getRows().get(y);
                    CommonBorderPaddingBackground.BorderInfo border2 = gridUnits[0].getBorderStart();
                    int borderWidth2 = border2.getRetainedWidth() / 2;
                    if (borderWidth2 > 0) {
                        if (level == 1) {
                            this.addBorder(blocks, y, gridUnits.length - 1, Trait.BORDER_START, border2, inFirstColumn, level);
                            TableCellLayoutManager.adjustIPD(blocks[y][gridUnits.length - 1], -borderWidth2);
                        } else {
                            this.addBorder(blocks, y, 0, Trait.BORDER_START, border2, inFirstColumn, level);
                            TableCellLayoutManager.adjustXOffset(blocks[y][0], borderWidth2);
                            TableCellLayoutManager.adjustIPD(blocks[y][0], -borderWidth2);
                        }
                    }
                    if ((borderWidth2 = (border2 = gridUnits[gridUnits.length - 1].getBorderEnd()).getRetainedWidth() / 2) <= 0) continue;
                    if (level == 1) {
                        this.addBorder(blocks, y, 0, Trait.BORDER_END, border2, inLastColumn, level);
                        TableCellLayoutManager.adjustXOffset(blocks[y][0], borderWidth2);
                        TableCellLayoutManager.adjustIPD(blocks[y][0], -borderWidth2);
                        continue;
                    }
                    this.addBorder(blocks, y, gridUnits.length - 1, Trait.BORDER_END, border2, inLastColumn, level);
                    TableCellLayoutManager.adjustIPD(blocks[y][gridUnits.length - 1], -borderWidth2);
                }
                int dy = this.yoffset;
                for (int y = startRow; y <= endRow; ++y) {
                    int bpd = spannedGridRowHeights[y - startRow];
                    int dx = this.xoffset;
                    for (int x2 = 0; x2 < gridUnits.length; ++x2) {
                        int ipd = this.getTable().getColumn(this.primaryGridUnit.getColIndex() + x2).getColumnWidth().getValue(this.getParent());
                        if (blocks[y][x2] != null) {
                            Block block = blocks[y][x2];
                            TableCellLayoutManager.adjustYOffset(block, dy);
                            TableCellLayoutManager.adjustXOffset(block, dx);
                            TableCellLayoutManager.adjustIPD(block, ipd);
                            TableCellLayoutManager.adjustBPD(block, bpd);
                            this.parentLayoutManager.addChildArea(block);
                        }
                        dx += ipd;
                    }
                    dy += bpd;
                }
            }
        }
        TraitSetter.addPadding(this.curBlockArea, padding, borderBeforeWhich == 2, borderAfterWhich == 2, false, false, this);
        if (this.usedBPD < cellBPD) {
            if (this.getTableCell().getDisplayAlign() == 23) {
                Block space = new Block();
                space.setChangeBarList(this.getChangeBarList());
                space.setBPD((cellBPD - this.usedBPD) / 2);
                space.setBidiLevel(this.getTableCell().getBidiLevelRecursive());
                this.curBlockArea.addBlock(space);
            } else if (this.getTableCell().getDisplayAlign() == 3) {
                Block space = new Block();
                space.setChangeBarList(this.getChangeBarList());
                space.setBPD(cellBPD - this.usedBPD);
                space.setBidiLevel(this.getTableCell().getBidiLevelRecursive());
                this.curBlockArea.addBlock(space);
            }
        }
        if (this.isDescendantOfTableHeaderOrFooter() && this.hasRetrieveTableMarker) {
            if (this.isDescendantOfTableHeader && !this.savedAddAreasArguments) {
                this.saveAddAreasArguments(parentIter, layoutContext, spannedGridRowHeights, startRow, endRow, borderBeforeWhich, borderAfterWhich, firstOnPage, lastOnPage, painter, firstRowHeight);
            }
            this.recreateChildrenLMs();
            int displayAlign = ((TableCell)this.getFObj()).getDisplayAlign();
            TableCellBreaker breaker = new TableCellBreaker(this, this.cellIPD, displayAlign);
            breaker.setDescendantOfTableFooter(this.isDescendantOfTableHeader);
            if (this.isDescendantOfTableHeader) {
                breaker.setRepeatedHeader(this.hasRepeatedHeader);
            } else {
                breaker.setRepeatedFooter(layoutContext.treatAsArtifact());
            }
            breaker.doLayout(this.usedBPD, false);
            this.clearRetrieveTableMarkerChildNodes(this.getChildLMs());
        }
        if (!this.hasRetrieveTableMarker) {
            AreaAdditionUtil.addAreas(this, parentIter, layoutContext);
        }
        this.curBlockArea.setBPD(cellBPD);
        if (!this.isSeparateBorderModel() || !this.emptyCell || this.getTableCell().showEmptyCells()) {
            TraitSetter.addBackground(this.curBlockArea, this.getTableCell().getCommonBorderPaddingBackground(), this);
        }
        if (this.flushArea) {
            this.flush();
        } else {
            this.flushArea = true;
        }
        this.curBlockArea = null;
        this.notifyEndOfLayout();
    }

    private void addBackgroundAreas(RowPainter painter, int firstRowHeight, int borderBeforeWidth, int paddingRectBPD) {
        TableRow row;
        TablePart body;
        TableColumn column = this.getTable().getColumn(this.primaryGridUnit.getColIndex());
        if (column.getCommonBorderPaddingBackground().hasBackground()) {
            Block colBackgroundArea = this.getBackgroundArea(paddingRectBPD, borderBeforeWidth);
            ((TableLayoutManager)this.parentLayoutManager).registerColumnBackgroundArea(column, colBackgroundArea, -this.startIndent);
        }
        if ((body = this.primaryGridUnit.getTablePart()).getCommonBorderPaddingBackground().hasBackground()) {
            painter.registerPartBackgroundArea(this.getBackgroundArea(paddingRectBPD, borderBeforeWidth));
        }
        if ((row = this.primaryGridUnit.getRow()) != null && row.getCommonBorderPaddingBackground().hasBackground()) {
            Block rowBackgroundArea = this.getBackgroundArea(paddingRectBPD, borderBeforeWidth);
            ((TableLayoutManager)this.parentLayoutManager).addBackgroundArea(rowBackgroundArea);
            TraitSetter.addBackground(rowBackgroundArea, row.getCommonBorderPaddingBackground(), this.parentLayoutManager, -this.xoffset - this.startIndent, -borderBeforeWidth, this.parentLayoutManager.getContentAreaIPD(), firstRowHeight);
        }
    }

    private void addBorder(Block[][] blocks, int i, int j, Integer side, CommonBorderPaddingBackground.BorderInfo border, boolean outer, int level) {
        if (blocks[i][j] == null) {
            blocks[i][j] = new Block();
            blocks[i][j].setChangeBarList(this.getChangeBarList());
            blocks[i][j].addTrait(Trait.IS_REFERENCE_AREA, Boolean.TRUE);
            blocks[i][j].setPositioning(2);
            blocks[i][j].setBidiLevel(level);
        }
        blocks[i][j].addTrait(side, BorderProps.makeRectangular(border.getStyle(), border.getRetainedWidth(), border.getColor(), outer ? BorderProps.Mode.COLLAPSE_OUTER : BorderProps.Mode.COLLAPSE_INNER));
    }

    private static void adjustXOffset(Block block, int amount) {
        block.setXOffset(block.getXOffset() + amount);
    }

    private static void adjustYOffset(Block block, int amount) {
        block.setYOffset(block.getYOffset() + amount);
    }

    private static void adjustIPD(Block block, int amount) {
        block.setIPD(block.getIPD() + amount);
    }

    private static void adjustBPD(Block block, int amount) {
        block.setBPD(block.getBPD() + amount);
    }

    private Block getBackgroundArea(int bpd, int borderBeforeWidth) {
        CommonBorderPaddingBackground padding = this.getTableCell().getCommonBorderPaddingBackground();
        int paddingStart = padding.getPaddingStart(false, this);
        int paddingEnd = padding.getPaddingEnd(false, this);
        Block block = new Block();
        block.setChangeBarList(this.getChangeBarList());
        TraitSetter.setProducerID(block, this.getTable().getId());
        block.setPositioning(2);
        block.setIPD(this.cellIPD + paddingStart + paddingEnd);
        block.setBPD(bpd);
        block.setXOffset(this.xoffset + this.startIndent - paddingStart);
        block.setYOffset(this.yoffset + borderBeforeWidth);
        block.setBidiLevel(this.getTableCell().getBidiLevelRecursive());
        return block;
    }

    @Override
    public Area getParentArea(Area childArea) {
        if (this.curBlockArea == null) {
            this.curBlockArea = new Block();
            this.curBlockArea.setChangeBarList(this.getChangeBarList());
            this.curBlockArea.addTrait(Trait.IS_REFERENCE_AREA, Boolean.TRUE);
            TraitSetter.setProducerID(this.curBlockArea, this.getTableCell().getId());
            this.curBlockArea.setPositioning(2);
            this.curBlockArea.setXOffset(this.xoffset + this.startIndent);
            this.curBlockArea.setYOffset(this.yoffset);
            this.curBlockArea.setIPD(this.cellIPD);
            this.curBlockArea.setBidiLevel(this.getTableCell().getBidiLevelRecursive());
            this.parentLayoutManager.getParentArea(this.curBlockArea);
            this.setCurrentArea(this.curBlockArea);
        }
        return this.curBlockArea;
    }

    @Override
    public void addChildArea(Area childArea) {
        if (this.curBlockArea != null && childArea instanceof Block) {
            this.curBlockArea.addBlock((Block)childArea);
        }
    }

    @Override
    public int negotiateBPDAdjustment(int adj, KnuthElement lastElement) {
        return 0;
    }

    @Override
    public void discardSpace(KnuthGlue spaceGlue) {
    }

    @Override
    public Keep getKeepTogether() {
        return Keep.KEEP_AUTO;
    }

    @Override
    public Keep getKeepWithNext() {
        return Keep.KEEP_AUTO;
    }

    @Override
    public Keep getKeepWithPrevious() {
        return Keep.KEEP_AUTO;
    }

    @Override
    public int getContentAreaIPD() {
        return this.cellIPD;
    }

    @Override
    public int getContentAreaBPD() {
        if (this.curBlockArea != null) {
            return this.curBlockArea.getBPD();
        }
        log.error((Object)"getContentAreaBPD called on unknown BPD");
        return -1;
    }

    @Override
    public boolean getGeneratesReferenceArea() {
        return true;
    }

    @Override
    public boolean getGeneratesBlockArea() {
        return true;
    }

    @Override
    protected void registerMarkers(boolean isStarting, boolean isFirst, boolean isLast) {
        Map<String, Marker> markers = this.getTableCell().getMarkers();
        if (markers != null) {
            this.getCurrentPV().registerMarkers(markers, isStarting, isFirst, isLast && this.isLastTrait);
            if (!this.isDescendantOfTableHeaderOrFooter()) {
                this.getTableLayoutManager().registerMarkers(markers, isStarting, isFirst, isLast && this.isLastTrait);
            }
        }
    }

    void setLastTrait(boolean isLast) {
        this.isLastTrait = isLast;
    }

    @Override
    public void setParent(LayoutManager lm) {
        this.parentLayoutManager = lm;
        if (this.hasRetrieveTableMarker) {
            this.getTableLayoutManager().flagAsHavingRetrieveTableMarker();
        }
    }

    private static class TableCellBreaker
    extends LocalBreaker {
        public TableCellBreaker(TableCellLayoutManager lm, int ipd, int displayAlign) {
            super(lm, ipd, displayAlign);
        }

        @Override
        protected void observeElementList(List elementList) {
            String elementListID = this.lm.getParent().getFObj().getId() + "-" + this.lm.getFObj().getId();
            ElementListObserver.observe(elementList, "table-cell", elementListID);
        }
    }
}

