/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.actions;

import java.util.ArrayList;
import org.eclipse.birt.report.designer.core.mediator.IMediatorRequest;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.util.mediator.request.ReportRequest;
import org.eclipse.birt.report.designer.internal.ui.processor.ElementProcessorFactory;
import org.eclipse.birt.report.designer.internal.ui.processor.IElementProcessor;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.views.actions.AbstractGlobalSelectionAction;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.jface.viewers.ISelectionProvider;

public class GlobalInsertAction
extends AbstractGlobalSelectionAction {
    private String dataType;

    protected GlobalInsertAction(ISelectionProvider provider, String id, String dataType) {
        super(provider, id);
        this.dataType = dataType;
    }

    protected boolean calculateEnabled() {
        SlotHandle container = this.getContainer();
        if (container != null) {
            return container.getElementHandle().canContain(container.getSlotID(), this.dataType);
        }
        return false;
    }

    private SlotHandle getContainer() {
        SlotHandle container = null;
        if (this.getSelectedObjects().size() == 1) {
            int slotId;
            Object selected = this.getSelectedObjects().get(0);
            if (selected instanceof SlotHandle) {
                container = (SlotHandle)selected;
            } else if (selected instanceof DesignElementHandle && (slotId = DEUtil.getDefaultSlotID(selected)) != -1) {
                container = ((DesignElementHandle)selected).getSlot(slotId);
            }
        }
        return container;
    }

    public void run() {
        if (SessionHandleAdapter.getInstance().getReportDesignHandle() == null) {
            return;
        }
        CommandStack stack = SessionHandleAdapter.getInstance().getReportDesignHandle().getCommandStack();
        IElementProcessor processor = ElementProcessorFactory.createProcessor(this.dataType);
        stack.startTrans(processor.getCreateTransactionLabel());
        DesignElementHandle handle = processor.createElement(null);
        if (handle == null) {
            stack.rollback();
        } else {
            try {
                this.getContainer().add(handle);
            }
            catch (Exception e) {
                stack.rollback();
                ExceptionHandler.handle(e);
                return;
            }
        }
        if (handle instanceof ExtendedItemHandle && ElementProcessorFactory.createProcessor(handle) != null && !ElementProcessorFactory.createProcessor(handle).editElement(handle)) {
            stack.rollback();
            return;
        }
        stack.commit();
        this.synWithMediator(handle);
        super.run();
    }

    private void synWithMediator(DesignElementHandle handle) {
        ArrayList<DesignElementHandle> list = new ArrayList<DesignElementHandle>();
        list.add(handle);
        ReportRequest r = new ReportRequest();
        r.setType((Object)"create element");
        r.setSelectionObject(list);
        SessionHandleAdapter.getInstance().getMediator().notifyRequest((IMediatorRequest)r);
    }
}

