/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.data.engine.api.aggregation.AggregationManager;
import org.eclipse.birt.data.engine.api.aggregation.IAggrFunction;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.i18n.DataResourceHandle;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationFunctionDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.Node;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.Row4Aggregation;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.RowHashKey;

public class MergeRow4Aggregation {
    private Map<RowHashKey, Node> rowMap;
    private int cacheSize;
    private int nodeSize;
    private IAggrFunction aggrFunc;
    private Node firstNode;
    private Node lastNode;
    private int measureIndexes;
    private int parameterColIndex;

    MergeRow4Aggregation(int cacheSize, AggregationFunctionDefinition aggregation, int measureIndexes, int parameterColIndex) throws DataException {
        this.cacheSize = cacheSize;
        if (aggregation != null) {
            this.aggrFunc = AggregationManager.getInstance().getAggregation(aggregation.getFunctionName());
            if (this.aggrFunc == null) {
                throw new DataException(DataResourceHandle.getInstance().getMessage("data.olap.UnsupportedFunction") + aggregation.getFunctionName());
            }
            this.parameterColIndex = parameterColIndex;
            this.measureIndexes = measureIndexes;
        }
        this.rowMap = new HashMap<RowHashKey, Node>();
        this.nodeSize = 0;
    }

    /*
     * Unable to fully structure code
     */
    public Row4Aggregation push(Row4Aggregation row) throws DataException {
        block4: {
            block3: {
                hashKey = new RowHashKey(row.getLevelMembers(), row.getParameterValues());
                mapNode = this.rowMap.get(hashKey);
                if (mapNode != null) break block3;
                this.addNode(row);
                if (this.nodeSize > this.cacheSize) {
                    popNode = this.popNode();
                    return popNode.row;
                }
                break block4;
            }
            if (mapNode.accumulator != null) ** GOTO lbl16
            while (row.nextMeasures()) {
                mapNode.row.addMeasure(row.getMeasures());
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                mapNode.accumulator.onRow(this.getAccumulatorParameter(row));
lbl16:
                // 2 sources

                ** while (row.nextMeasures())
            }
        }
        return null;
    }

    private Object[] getAccumulatorParameter(Row4Aggregation row) {
        Object[] parameters = null;
        if (this.parameterColIndex == -1) {
            parameters = new Object[1];
            if (this.measureIndexes < 0) {
                return null;
            }
            parameters[0] = row.getMeasures()[this.measureIndexes];
        } else {
            parameters = new Object[]{this.measureIndexes < 0 ? null : row.getMeasures()[this.measureIndexes], row.getParameterValues()[this.parameterColIndex]};
        }
        return parameters;
    }

    private void addNode(Row4Aggregation row) throws DataException {
        Node node = new Node();
        node.row = row;
        if (this.aggrFunc != null) {
            node.accumulator = this.aggrFunc.newAccumulator();
            node.accumulator.start();
            while (row.nextMeasures()) {
                node.accumulator.onRow(this.getAccumulatorParameter(row));
            }
            node.row.clearMeasure();
        }
        if (this.lastNode != null) {
            node.preNode = this.lastNode;
            this.lastNode.nextNode = node;
            this.lastNode = node;
        } else {
            this.firstNode = node;
            this.lastNode = node;
        }
        RowHashKey hashKey = new RowHashKey(row.getLevelMembers(), node.row.getParameterValues());
        this.rowMap.put(hashKey, node);
        ++this.nodeSize;
    }

    private Node popNode() throws DataException {
        Node node = this.firstNode;
        this.firstNode = node.nextNode;
        if (this.firstNode != null) {
            this.firstNode.preNode = null;
        }
        node.nextNode = null;
        RowHashKey hashKey = new RowHashKey(node.row.getLevelMembers(), node.row.getParameterValues());
        this.rowMap.remove(hashKey);
        --this.nodeSize;
        if (node.accumulator != null) {
            node.accumulator.finish();
            node.row.getMeasures()[this.measureIndexes] = node.accumulator.getValue();
        }
        node.row.resetPosition();
        return node;
    }

    public List<Row4Aggregation> getAll() throws DataException {
        ArrayList<Row4Aggregation> rowList = new ArrayList<Row4Aggregation>();
        for (Node node : this.rowMap.values()) {
            if (node.accumulator != null) {
                node.accumulator.finish();
                node.row.getMeasures()[this.measureIndexes] = node.accumulator.getValue();
                node.row.resetPosition();
            }
            rowList.add(node.row);
        }
        return rowList;
    }
}

