/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.SummaryGroupLevelCalculator;
import org.eclipse.birt.data.engine.impl.document.QueryResults;
import org.eclipse.birt.data.engine.impl.document.ResultIterator;

public class ResultIterator2
extends ResultIterator {
    private int lowestGroupLevel;
    private int currRowIndex;
    private boolean isSummary;
    private SummaryGroupLevelCalculator groupLevelCalculator;

    public ResultIterator2(String tempDir, DataEngineContext context, IQueryResults queryResults, String queryResultID, int lowestGroupLevel, boolean isSummary, IBaseQueryDefinition qd) throws DataException {
        super(tempDir, context, queryResults, queryResultID, qd);
        this.lowestGroupLevel = lowestGroupLevel;
        this.currRowIndex = this.hasFirstNext ? 0 : -1;
        this.isSummary = isSummary;
        if (this.isSummary) {
            if (lowestGroupLevel == 0) {
                this.groupLevelCalculator = new SummaryGroupLevelCalculator(null);
            } else {
                int[][] groupIndex = new int[lowestGroupLevel + 1][];
                int i = 0;
                while (i <= lowestGroupLevel) {
                    groupIndex[i] = this.exprResultSet.getGroupStartAndEndIndex(i);
                    ++i;
                }
                this.groupLevelCalculator = new SummaryGroupLevelCalculator(groupIndex);
            }
        }
    }

    public ResultIterator2(String tempDir, DataEngineContext context, QueryResults queryResults, String queryResultID, String subQueryName, int currParentIndex, int lowestGroupLevel, IBaseQueryDefinition qd) throws DataException {
        super(tempDir, context, queryResults, queryResultID, subQueryName, currParentIndex, qd);
        this.lowestGroupLevel = lowestGroupLevel;
        this.currRowIndex = this.hasFirstNext ? 0 : -1;
    }

    @Override
    protected boolean doNext() throws DataException {
        boolean hasNext = false;
        boolean shouldMoveForward = false;
        int index = this.exprResultSet.getCurrentIndex();
        if (this.exprResultSet.getCurrentIndex() >= 0) {
            this.exprResultSet.skipToEnd(this.lowestGroupLevel);
            if (!this.isSummary && this.exprResultSet.getCurrentIndex() != index) {
                shouldMoveForward = false;
                hasNext = this.exprResultSet.getCurrentIndex() >= 0;
            } else {
                shouldMoveForward = true;
            }
        } else {
            shouldMoveForward = true;
        }
        if (shouldMoveForward) {
            hasNext = super.doNext();
        }
        if (hasNext) {
            ++this.currRowIndex;
        }
        return hasNext;
    }

    @Override
    public int getEndingGroupLevel() throws BirtException {
        if (this.isSummary) {
            return this.groupLevelCalculator.getEndingGroupLevel(this.exprResultSet.getCurrentIndex());
        }
        return super.getEndingGroupLevel();
    }

    @Override
    public int getRowIndex() throws BirtException {
        return this.currRowIndex;
    }

    @Override
    public void moveTo(int rowIndex) throws BirtException {
        if (rowIndex >= 0) {
            this.isFirstNext = false;
        }
        if (rowIndex < 0 || rowIndex < this.currRowIndex) {
            throw new DataException("data.engine.invalidRowIndex", rowIndex);
        }
        if (rowIndex == this.currRowIndex) {
            return;
        }
        int gapRows = rowIndex - this.currRowIndex;
        int i = 0;
        while (i < gapRows) {
            if (!this.next()) {
                throw new DataException("data.engine.invalidRowIndex", rowIndex);
            }
            ++i;
        }
    }
}

