/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.cubebuilder.dialog;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.helper.IDialogHelper;
import org.eclipse.birt.report.designer.internal.ui.dialogs.helper.IDialogHelperProvider;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.ui.cubebuilder.nls.Messages;
import org.eclipse.birt.report.designer.ui.cubebuilder.provider.CubeACLExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class GroupRenameDialog
extends BaseDialog {
    private String message;
    private Text text;
    private Text errorMessageText;
    private String errorMessage;
    private IDialogHelper helper;
    private DimensionHandle dimension;

    public GroupRenameDialog(Shell parentShell, String dialogTitle, String dialogMessage) {
        super(dialogTitle);
        this.message = dialogMessage;
    }

    public void setInput(DimensionHandle dimension) {
        this.dimension = dimension;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(composite, 0);
        container.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        if (this.message != null) {
            Label label = new Label(container, 64);
            label.setText(this.message);
            label.setLayoutData((Object)new GridData());
            label.setFont(parent.getFont());
        }
        this.text = new Text(container, 2052);
        if (this.dimension.getName() != null) {
            this.text.setText(this.dimension.getName());
        }
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.widthHint = 250;
        this.text.setLayoutData((Object)gd);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (GroupRenameDialog.this.text.getText().trim().length() == 0) {
                    GroupRenameDialog.this.getButton(0).setEnabled(false);
                    GroupRenameDialog.this.setErrorMessage(Messages.getString("RenameInputDialog.Message.BlankName"));
                } else if (!UIUtil.validateDimensionName((String)GroupRenameDialog.this.text.getText())) {
                    GroupRenameDialog.this.getButton(0).setEnabled(false);
                    GroupRenameDialog.this.setErrorMessage(Messages.getString("RenameInputDialog.Message.NumericName"));
                } else if (GroupRenameDialog.this.checkDuplicateName(GroupRenameDialog.this.text.getText())) {
                    GroupRenameDialog.this.getButton(0).setEnabled(false);
                    GroupRenameDialog.this.setErrorMessage(Messages.getString("RenameInputDialog.Message.DuplicateName"));
                } else {
                    GroupRenameDialog.this.getButton(0).setEnabled(true);
                    GroupRenameDialog.this.setErrorMessage(null);
                }
            }
        });
        if (this.text.getText().trim().length() == 0) {
            this.getButton(0).setEnabled(false);
            this.setErrorMessage(Messages.getString("RenameInputDialog.Message.BlankName"));
        } else if (!UIUtil.validateDimensionName((String)this.text.getText())) {
            this.getButton(0).setEnabled(false);
            this.setErrorMessage(Messages.getString("RenameInputDialog.Message.NumericName"));
        }
        this.createSecurityPart(container);
        this.errorMessageText = new Text(container, 72);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.errorMessageText.setLayoutData((Object)gd);
        this.errorMessageText.setBackground(this.errorMessageText.getDisplay().getSystemColor(22));
        this.setErrorMessage(this.errorMessage);
        GroupRenameDialog.applyDialogFont((Control)composite);
        UIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.cshelp.GroupRenameDialog_ID");
        return composite;
    }

    protected boolean checkDuplicateName(String name) {
        try {
            DimensionHandle handle = SessionHandleAdapter.getInstance().getReportDesignHandle().findDimension(name);
            if (handle != null && handle != this.dimension) {
                return true;
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return false;
    }

    private void createSecurityPart(Composite parent) {
        Object[] helperProviders = ElementAdapterManager.getAdapters((Object)this.dimension, IDialogHelperProvider.class);
        if (helperProviders != null) {
            int i = 0;
            while (i < helperProviders.length) {
                IDialogHelperProvider helperProvider = (IDialogHelperProvider)helperProviders[i];
                if (helperProvider != null && this.helper == null) {
                    this.helper = helperProvider.createHelper((Object)this, "Security Helper");
                    if (this.helper != null) {
                        this.helper.setProperty("Security Label", (Object)Messages.getString("GroupRenameDialog.Access.Control.List.Expression"));
                        this.helper.setProperty("Security Expression Context", (Object)this.dimension);
                        this.helper.setProperty("Security Expression Provider", (Object)new CubeACLExpressionProvider((DesignElementHandle)this.dimension));
                        this.helper.setProperty("Security Expression Property", (Object)this.dimension.getACLExpression());
                        this.helper.createContent(parent);
                        this.helper.addListener(24, new Listener(){

                            public void handleEvent(Event event) {
                                GroupRenameDialog.this.helper.update(false);
                            }
                        });
                        this.helper.update(true);
                    }
                }
                ++i;
            }
        }
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        if (this.errorMessageText != null && !this.errorMessageText.isDisposed()) {
            this.errorMessageText.setText(errorMessage == null ? " \n " : errorMessage);
            boolean hasError = errorMessage != null && StringConverter.removeWhiteSpaces((String)errorMessage).length() > 0;
            this.errorMessageText.setEnabled(hasError);
            this.errorMessageText.setVisible(hasError);
            this.errorMessageText.getParent().update();
            Button button = this.getButton(0);
            if (button != null) {
                button.setEnabled(errorMessage == null);
            }
        }
    }

    protected void okPressed() {
        try {
            this.dimension.setName(this.text.getText().trim());
        }
        catch (NameException e1) {
            ExceptionUtil.handle((Throwable)e1);
        }
        if (this.helper != null) {
            try {
                this.helper.validate();
                this.dimension.setExpressionProperty("ACLExpression", (Expression)this.helper.getProperty("Security Expression Property"));
            }
            catch (SemanticException e) {
                ExceptionUtil.handle((Throwable)e);
            }
        }
        super.okPressed();
    }
}

