/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.views.property.GroupPropertyHandleWrapper;
import org.eclipse.birt.report.designer.core.model.views.property.PropertySheetRootElement;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GroupElementHandle;
import org.eclipse.birt.report.model.api.GroupPropertyHandle;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

class AdvancedPropertyContentProvider
implements ITreeContentProvider {
    private static final String ROOT_DEFAUL_TITLE = Messages.getString((String)"ReportPropertySheetPage.Root.Default.Title");
    private int viewMode = 0;
    PropertySheetRootElement[] roots = new PropertySheetRootElement[1];

    AdvancedPropertyContentProvider() {
    }

    public void setViewMode(int mode) {
        this.viewMode = mode;
    }

    public int getViewMode() {
        return this.viewMode;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof List) {
            return ((List)parentElement).toArray();
        }
        if (parentElement instanceof PropertySheetRootElement) {
            ArrayList<Object> items = new ArrayList<Object>();
            GroupElementHandle handle = ((PropertySheetRootElement)parentElement).getModel();
            if (this.viewMode == 0) {
                HashMap<String, ArrayList<GroupPropertyHandleWrapper>> map = new HashMap<String, ArrayList<GroupPropertyHandleWrapper>>();
                Iterator it = handle.visiblePropertyIterator();
                while (it.hasNext()) {
                    GroupPropertyHandle property = (GroupPropertyHandle)it.next();
                    IElementPropertyDefn defn = property.getPropertyDefn();
                    if (defn.getGroupNameKey() == null) {
                        items.add(new GroupPropertyHandleWrapper(property));
                        continue;
                    }
                    ArrayList<GroupPropertyHandleWrapper> group = (ArrayList<GroupPropertyHandleWrapper>)map.get(defn.getGroupNameKey());
                    if (group == null) {
                        group = new ArrayList<GroupPropertyHandleWrapper>();
                        items.add(group);
                        map.put(defn.getGroupNameKey(), group);
                    }
                    group.add(new GroupPropertyHandleWrapper(property));
                }
            } else if (this.viewMode == 1) {
                Iterator it = handle.visiblePropertyIterator();
                while (it.hasNext()) {
                    GroupPropertyHandle property = (GroupPropertyHandle)it.next();
                    items.add(new GroupPropertyHandleWrapper(property));
                }
            } else if (this.viewMode == 2) {
                Iterator it = handle.visiblePropertyIterator();
                while (it.hasNext()) {
                    GroupPropertyHandle property = (GroupPropertyHandle)it.next();
                    if (property == null || property.getLocalStringValue() == null) continue;
                    items.add(new GroupPropertyHandleWrapper(property));
                }
            }
            return items.toArray();
        }
        return null;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof List && ((List)element).size() > 0 || element instanceof PropertySheetRootElement;
    }

    public Object[] getElements(Object input) {
        GroupElementHandle inputElement = DEUtil.getGroupElementHandle((List)DEUtil.getInputElements((Object)input));
        PropertySheetRootElement root = new PropertySheetRootElement(inputElement);
        String displayName = null;
        Object element = inputElement.getElements().get(0);
        if (element instanceof DesignElementHandle && ((displayName = ((DesignElementHandle)element).getDefn().getDisplayName()) == null || "".equals(displayName))) {
            displayName = ((DesignElementHandle)element).getDefn().getName();
        }
        if (displayName == null || "".equals(displayName)) {
            displayName = ROOT_DEFAUL_TITLE;
        }
        root.setDisplayName(displayName);
        this.roots[0] = root;
        return this.roots;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

