/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt;

import java.math.BigInteger;
import org.eclipse.birt.chart.model.util.ChartElementUtil;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;

public class ChartSpinner
extends Composite
implements Listener,
SelectionListener {
    protected EObject eParent = null;
    protected String sProperty = null;
    protected Spinner spinner = null;
    protected double dRatio = 1.0;
    protected Label lblLabel;
    protected Label lblEndLabel;

    public ChartSpinner(Composite parent, int styles, EObject obj, String property, boolean enabled) {
        this(parent, styles, obj, property, enabled, null, null);
    }

    public ChartSpinner(Composite parent, int styles, EObject eParent, String property, boolean enabled, String label, String endLabel) {
        super(parent, 0);
        this.eParent = eParent;
        this.sProperty = property;
        this.placeComponents(styles, enabled, label, endLabel);
        this.initListeners();
        if (this.lblLabel != null) {
            ChartUIUtil.addScreenReaderAccessbility((Control)this.spinner, this.lblLabel.getText());
        } else {
            ChartUIUtil.addScreenReaderAccessibility((Control)this, (Control)this.spinner);
        }
    }

    public void addScreenReaderAccessibility(String description) {
        ChartUIUtil.addScreenReaderAccessbility((Control)this.spinner, description);
    }

    protected void placeComponents(int styles, boolean enabled, String label, String endLabel) {
        int colNum = 1;
        if (label != null) {
            ++colNum;
        }
        if (endLabel != null) {
            ++colNum;
        }
        GridLayout gl = new GridLayout();
        gl.numColumns = colNum;
        gl.makeColumnsEqualWidth = false;
        gl.marginBottom = 0;
        gl.marginHeight = 0;
        gl.marginLeft = 0;
        gl.marginRight = 0;
        gl.marginTop = 0;
        gl.marginWidth = 0;
        this.setLayout((Layout)gl);
        if (label != null) {
            this.lblLabel = new Label((Composite)this, 0);
            this.lblLabel.setText(label);
        }
        this.spinner = new Spinner((Composite)this, styles);
        GridData gd = new GridData(1808);
        this.spinner.setLayoutData((Object)gd);
        this.setEnabled(enabled);
        if (endLabel != null) {
            this.lblEndLabel = new Label((Composite)this, 0);
            this.lblEndLabel.setText(endLabel);
        }
    }

    public Spinner getWidget() {
        return this.spinner;
    }

    protected void initListeners() {
        this.spinner.addSelectionListener((SelectionListener)this);
    }

    public void addListener(int eventType, Listener listener) {
        super.addListener(eventType, listener);
        if (this.spinner != null) {
            this.spinner.addListener(eventType, (Listener)this);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.spinner.setEnabled(enabled);
        if (this.lblLabel != null) {
            this.lblLabel.setEnabled(enabled);
        }
        if (this.lblEndLabel != null) {
            this.lblEndLabel.setEnabled(enabled);
        }
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.widget == this.spinner) {
            ChartElementUtil.setEObjectAttribute((EObject)this.eParent, (String)this.sProperty, (Object)ChartSpinner.convertNumber(this.eParent, this.sProperty, (double)this.spinner.getSelection() / this.dRatio), (boolean)false);
        }
    }

    public void handleEvent(Event event) {
        if (event.widget == this.spinner) {
            event.widget = this;
            Listener[] lis = this.getListeners(event.type);
            int i = lis.length - 1;
            while (i >= 0) {
                lis[i].handleEvent(event);
                --i;
            }
        }
    }

    public void setRatio(double ratio) {
        this.dRatio = ratio;
    }

    public static Number convertNumber(EObject eObj, String sProperty, double value) {
        EStructuralFeature esf = eObj.eClass().getEStructuralFeature(sProperty);
        String typeName = esf.getEType().getInstanceTypeName();
        if ("double".equalsIgnoreCase(typeName)) {
            return value;
        }
        if ("float".equalsIgnoreCase(typeName)) {
            return new Float(value);
        }
        if ("java.math.BigInteger".equalsIgnoreCase(typeName)) {
            return BigInteger.valueOf((long)value);
        }
        return (int)value;
    }
}

