/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.pojo.ui.impl.dialogs;

import org.eclipse.birt.data.oda.pojo.ui.i18n.Messages;
import org.eclipse.birt.data.oda.pojo.ui.util.HelpUtil;
import org.eclipse.birt.data.oda.pojo.ui.util.Utils;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ClassInputDialog
extends TrayDialog {
    private String input;
    private Text txtName;
    private TableViewer classTableViewer;
    private String[] classes;
    private String initValue;

    protected Control createDialogArea(Composite parent) {
        Composite top = new Composite(parent, 0);
        GridData gd = new GridData(1808);
        gd.widthHint = 600;
        gd.heightHint = 250;
        top.setLayoutData((Object)gd);
        top.setLayout((Layout)new GridLayout(1, false));
        Label l = new Label(top, 0);
        l.setText(Messages.getString("DataSet.ClassNameFilter"));
        this.txtName = new Text(top, 2048);
        this.txtName.setLayoutData((Object)new GridData(768));
        this.txtName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ClassInputDialog.this.classTableViewer.refresh();
                if (ClassInputDialog.this.classTableViewer.getElementAt(0) != null) {
                    ClassInputDialog.this.classTableViewer.setSelection((ISelection)new StructuredSelection(ClassInputDialog.this.classTableViewer.getElementAt(0)));
                }
            }
        });
        l = new Label(top, 0);
        l.setText(Messages.getString("DataSet.MatchingItems"));
        this.classTableViewer = new TableViewer(top, 2816);
        this.classTableViewer.getTable().setLayoutData((Object)new GridData(1808));
        this.classTableViewer.getTable().setHeaderVisible(false);
        this.classTableViewer.getTable().setLinesVisible(false);
        this.classTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
            }

            public Object[] getElements(Object arg0) {
                return ClassInputDialog.this.classes;
            }
        });
        this.classTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return Utils.getClassFlagImg();
            }

            public String getText(Object element) {
                IStructuredSelection ss = (IStructuredSelection)ClassInputDialog.this.classTableViewer.getSelection();
                Object selected = ss.getFirstElement();
                if (element != selected) {
                    return ClassInputDialog.getClassName((String)element);
                }
                return ClassInputDialog.getClassName((String)element) + " - " + ClassInputDialog.getPackagePath((String)element);
            }
        });
        this.classTableViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                String c1 = ClassInputDialog.getClassName((String)e1);
                String c2 = ClassInputDialog.getClassName((String)e2);
                return c1.compareTo(c2);
            }
        });
        this.classTableViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer arg0, Object arg1, Object arg2) {
                String filter = ClassInputDialog.this.txtName.getText().trim();
                if (filter.equals("")) {
                    return true;
                }
                return arg2.toString().toUpperCase().matches(org.eclipse.birt.data.oda.pojo.util.Utils.toRegexPattern((String)filter).toUpperCase());
            }
        });
        this.classTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                if (ss.size() == 1) {
                    if (ClassInputDialog.this.getButton(0) != null) {
                        ClassInputDialog.this.getButton(0).setEnabled(true);
                    }
                } else if (ClassInputDialog.this.getButton(0) != null) {
                    ClassInputDialog.this.getButton(0).setEnabled(false);
                }
                ClassInputDialog.this.classTableViewer.refresh();
            }
        });
        this.classTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection ss = (IStructuredSelection)ClassInputDialog.this.classTableViewer.getSelection();
                if (ss.getFirstElement() != null) {
                    ClassInputDialog.this.buttonPressed(0);
                }
            }
        });
        this.classTableViewer.setInput((Object)"");
        if (this.classTableViewer.getElementAt(0) != null) {
            this.classTableViewer.setSelection((ISelection)new StructuredSelection(this.classTableViewer.getElementAt(0)));
        }
        this.getShell().setText(Messages.getString("DataSet.ClassInputDialogTitle"));
        this.setInitValue();
        HelpUtil.setSystemHelp((Control)top, "org.eclipse.birt.cshelp.Dialog_POJO_Dataset_ClassInput_ID");
        return top;
    }

    public ClassInputDialog(Shell shell, String[] classNames, String initValue) {
        super(shell);
        this.classes = classNames;
        this.initValue = initValue;
    }

    protected void buttonPressed(int buttonId) {
        IStructuredSelection ss;
        String s;
        this.input = null;
        if (buttonId == 0 && (s = (String)(ss = (IStructuredSelection)this.classTableViewer.getSelection()).getFirstElement()) != null) {
            this.input = s;
        }
        super.buttonPressed(buttonId);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        IStructuredSelection ss = (IStructuredSelection)this.classTableViewer.getSelection();
        if (ss.getFirstElement() == null) {
            this.getButton(0).setEnabled(false);
        }
    }

    public String getInput() {
        return this.input;
    }

    protected boolean isResizable() {
        return true;
    }

    private void setInitValue() {
        this.txtName.setText(this.initValue);
        this.txtName.selectAll();
        this.classTableViewer.refresh();
        if (this.classTableViewer.getElementAt(0) != null) {
            this.classTableViewer.setSelection((ISelection)new StructuredSelection(this.classTableViewer.getElementAt(0)));
        }
    }

    private static String getClassName(String fullName) {
        assert (fullName != null);
        int index = fullName.lastIndexOf(46);
        if (index < 0) {
            return fullName;
        }
        return fullName.substring(index + 1);
    }

    private static String getPackagePath(String fullName) {
        assert (fullName != null);
        int index = fullName.lastIndexOf(46);
        if (index < 0) {
            return "";
        }
        return fullName.substring(0, index);
    }
}

