/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.core.security;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import org.eclipse.birt.data.engine.core.DataException;

public class ObjectSecurity {
    public static ObjectInputStream createObjectInputStream(InputStream is) throws IOException, DataException {
        try {
            return new ObjectInputStream(is);
        }
        catch (Exception typedException) {
            if (typedException instanceof IOException) {
                throw (IOException)typedException;
            }
            throw new DataException(typedException.getMessage());
        }
    }

    public static ObjectInputStream createObjectInputStream(InputStream is, final ClassLoader classLoader) throws IOException, DataException {
        try {
            return new ObjectInputStream(is){

                protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    return Class.forName(desc.getName(), false, classLoader);
                }
            };
        }
        catch (Exception typedException) {
            if (typedException instanceof IOException) {
                throw (IOException)typedException;
            }
            throw new DataException(typedException.getMessage());
        }
    }

    public static ObjectOutputStream createObjectOutputStream(OutputStream os) throws IOException, DataException {
        try {
            return new ObjectOutputStream(os);
        }
        catch (Exception typedException) {
            if (typedException instanceof IOException) {
                throw (IOException)typedException;
            }
            throw new DataException(typedException.getMessage());
        }
    }

    public static Object readObject(ObjectInputStream is) throws IOException, DataException, ClassNotFoundException {
        block5: {
            try {
                if (is != null) break block5;
                return null;
            }
            catch (Exception typedException) {
                if (typedException instanceof IOException) {
                    throw (IOException)typedException;
                }
                if (typedException instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)typedException;
                }
                throw new DataException(typedException.getMessage());
            }
        }
        return is.readObject();
    }
}

