/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs.expression;

import org.eclipse.birt.report.designer.internal.ui.dialogs.MessageLine;
import org.eclipse.birt.report.designer.internal.ui.util.ExpressionButtonUtil;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.ui.preferences.StatusInfo;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ExpressionEditor
extends BaseDialog {
    private MessageLine fStatusLine;
    private Text exprText;
    private Object contextObject;
    private boolean allowConstant;
    private IExpressionProvider provider;
    private Expression expression;

    public ExpressionEditor(String title) {
        super(title);
    }

    public void setInput(Object input, IExpressionProvider provider, boolean allowConstant) {
        this.contextObject = input;
        this.allowConstant = allowConstant;
        this.provider = provider;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 10;
        container.setLayout((Layout)layout);
        new Label(container, 0).setText(Messages.getString((String)"ExpressionEditor.Label.Expression"));
        this.exprText = new Text(container, 2050);
        GridData gd = new GridData();
        gd.widthHint = 200;
        gd.heightHint = this.exprText.computeSize((int)-1, (int)-1).y - this.exprText.getBorderWidth() * 2;
        this.exprText.setLayoutData((Object)gd);
        this.exprText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExpressionEditor.this.checkStatus();
            }
        });
        ExpressionButtonUtil.createExpressionButton(container, (Control)this.exprText, this.provider, this.contextObject, this.allowConstant, 8);
        ExpressionButtonUtil.initExpressionButtonControl((Control)this.exprText, this.expression);
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.ExpressionEditor_ID");
        return composite;
    }

    protected void updateStatus(IStatus status) {
        if (this.fStatusLine != null && !this.fStatusLine.isDisposed()) {
            this.updateButtonsEnableState(status);
            this.fStatusLine.setErrorStatus(status);
        }
    }

    private void checkStatus() {
        if (this.exprText.getText().length() == 0) {
            StatusInfo status = new StatusInfo("org.eclipse.birt.report.designer.ui", 4, Messages.getString((String)"ExpressionEditor.Error.EmptyExpression"));
            this.updateStatus(status);
        } else {
            StatusInfo status = new StatusInfo("org.eclipse.birt.report.designer.ui");
            this.updateStatus(status);
        }
    }

    protected Control createButtonBar(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginLeft = this.convertHorizontalDLUsToPixels(7);
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        composite.setFont(font);
        this.fStatusLine = new MessageLine(composite);
        this.fStatusLine.setAlignment(16384);
        GridData statusData = new GridData(768);
        this.fStatusLine.setErrorStatus(null);
        this.fStatusLine.setFont(font);
        this.fStatusLine.setLayoutData(statusData);
        super.createButtonBar(composite);
        this.checkStatus();
        return composite;
    }

    protected void updateButtonsEnableState(IStatus status) {
        Button okButton = this.getOkButton();
        if (okButton != null && !okButton.isDisposed()) {
            okButton.setEnabled(!status.matches(4));
        }
    }

    public void okPressed() {
        this.expression = ExpressionButtonUtil.getExpression((Control)this.exprText);
        super.okPressed();
    }

    public Expression getExpression() {
        return this.expression;
    }
}

