/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.impl;

import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.IXSDFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.XSDToFragmentConfiguration;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.impl.Fragment;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class XSDFragment
extends Fragment
implements IXSDFragment {
    private XSDToFragmentConfiguration config_;
    private XSDTypeDefinition typeDef_;
    private int seed_;

    public XSDFragment(String id, String name, XSDToFragmentConfiguration config) {
        super(id, name);
        this.config_ = config;
        if (this.config_ != null) {
            XSDComponent component = config.getXSDComponent();
            this.typeDef_ = component instanceof XSDTypeDefinition ? (XSDTypeDefinition)component : null;
        }
        this.seed_ = 0;
    }

    @Override
    public void setXSDToFragmentConfiguration(XSDToFragmentConfiguration config) {
        XSDComponent component;
        this.config_ = config;
        if (this.config_ != null && (component = config.getXSDComponent()) instanceof XSDTypeDefinition) {
            this.setXSDTypeDefinition((XSDTypeDefinition)component);
        }
    }

    @Override
    public XSDToFragmentConfiguration getXSDToFragmentConfiguration() {
        return this.config_;
    }

    @Override
    public void setXSDTypeDefinition(XSDTypeDefinition typeDef) {
        this.typeDef_ = typeDef;
    }

    @Override
    public XSDTypeDefinition getXSDTypeDefinition() {
        return this.typeDef_;
    }

    @Override
    public boolean setParameterValuesFromInstanceDocuments(Element[] instanceDocuments) {
        Element[] instanceDocumentsCopy = this.getInstanceDocumentsByTagName(instanceDocuments, this.getName());
        String[] params = new String[instanceDocumentsCopy.length];
        boolean paramsValid = this.internalEquals(instanceDocumentsCopy, instanceDocuments);
        int i = 0;
        while (i < instanceDocumentsCopy.length) {
            params[i] = "";
            NodeList nodeList = instanceDocumentsCopy[i].getChildNodes();
            if (nodeList.getLength() > 0) {
                Node node = nodeList.item(0);
                if (nodeList.getLength() > 1) {
                    paramsValid = false;
                }
                if (node.getNodeType() != 3) {
                    paramsValid = false;
                } else {
                    params[i] = node.getNodeValue();
                }
            } else {
                paramsValid = false;
            }
            ++i;
        }
        this.setParameterValues(this.getID(), params);
        return paramsValid && this.validateAllParameterValues();
    }

    protected Element[] getInstanceDocumentsByTagName(Element[] instanceDocuments, String tagName) {
        if (instanceDocuments == null) {
            return new Element[0];
        }
        Vector<Element> instancesCopy = new Vector<Element>();
        int i = 0;
        while (i < instanceDocuments.length) {
            String instanceTagName;
            if (instanceDocuments[i] != null && (instanceTagName = this.trimPrefix(instanceDocuments[i].getTagName())).equals(tagName)) {
                instancesCopy.add(instanceDocuments[i]);
            }
            ++i;
        }
        Object[] instances = new Element[instancesCopy.size()];
        instancesCopy.copyInto(instances);
        return instances;
    }

    protected String trimPrefix(String s) {
        String sCopy = new String(s);
        int colonIndex = sCopy.indexOf(":");
        if (colonIndex != -1 && colonIndex + 1 < sCopy.length() && !String.valueOf(sCopy.charAt(colonIndex + 1)).equals(":")) {
            sCopy = sCopy.substring(colonIndex + 1, sCopy.length());
        }
        return sCopy;
    }

    public Element[] genInstanceDocumentsForNil(boolean genXSIType, Hashtable namespaceTable, Document doc) {
        Element[] instanceDocuments = new Element[1];
        String tagName = this.getInstanceDocumentTagName(namespaceTable);
        int i = 0;
        while (i < instanceDocuments.length) {
            Element instanceDocument;
            instanceDocuments[i] = instanceDocument = doc.createElement(tagName);
            ++i;
        }
        return genXSIType ? this.addXSIType(instanceDocuments, namespaceTable) : instanceDocuments;
    }

    @Override
    public Element[] genInstanceDocumentsFromParameterValues(boolean genXSIType, Hashtable namespaceTable, Document doc) {
        String[] params = this.getParameterValues(this.getID());
        if (params == null) {
            return new Element[0];
        }
        Element[] instanceDocuments = new Element[params.length];
        String tagName = this.getInstanceDocumentTagName(namespaceTable);
        int i = 0;
        while (i < instanceDocuments.length) {
            Element instanceDocument = doc.createElement(tagName);
            Text textNode = doc.createTextNode(params[i]);
            instanceDocument.appendChild(textNode);
            instanceDocuments[i] = instanceDocument;
            ++i;
        }
        return genXSIType ? this.addXSIType(instanceDocuments, namespaceTable) : instanceDocuments;
    }

    @Override
    public Element setAttributesOnInstanceDocuments(Element instanceDocument, String attName) {
        String[] params = this.getParameterValues(this.getID());
        if (params == null) {
            return instanceDocument;
        }
        if (this.isAttributeInstanceNamespaceQualified()) {
            instanceDocument.setAttributeNS(this.config_.getXSDComponent().getSchema().getTargetNamespace(), attName, params[0]);
        } else {
            instanceDocument.setAttribute(attName, params[0]);
        }
        return instanceDocument;
    }

    @Override
    public boolean setAttributeParamsFromInstanceDocuments(Node attribute) {
        String[] params = new String[]{attribute.getNodeValue()};
        this.setParameterValues(this.getID(), params);
        return this.validateAllParameterValues();
    }

    @Override
    public String genID() {
        StringBuffer newID = new StringBuffer();
        newID.append(this.getID());
        newID.append("::");
        newID.append(this.seed_++);
        return newID.toString();
    }

    protected boolean isInstanceNamespaceQualified() {
        XSDSchema xsdSchema = this.config_.getXSDComponent().getSchema();
        return !this.config_.getIsWSDLPart() && this.config_.getPartEncoding() == 0 && xsdSchema.getElementFormDefault().getValue() == 0;
    }

    protected boolean isAttributeInstanceNamespaceQualified() {
        XSDSchema xsdSchema = this.config_.getXSDComponent().getSchema();
        return !this.config_.getIsWSDLPart() && this.config_.getPartEncoding() == 0 && xsdSchema.getAttributeFormDefault().getValue() == 0;
    }

    protected String getInstanceDocumentTagName(Hashtable namespaceTable) {
        StringBuffer tagName = new StringBuffer();
        if (this.isInstanceNamespaceQualified()) {
            String nsURI = this.config_.getXSDComponent().getSchema().getTargetNamespace();
            String prefix = this.getPrefixFromNamespaceURI(nsURI, namespaceTable);
            tagName.append(prefix);
            tagName.append(":");
        }
        tagName.append(this.getName());
        return tagName.toString();
    }

    protected Element[] addXSIType(Element[] instanceDocuments, Hashtable namespaceTable) {
        String xsdComponentName;
        XSDComponent xsdComponent = this.config_.getXSDComponent();
        if (instanceDocuments != null && xsdComponent instanceof XSDNamedComponent && (xsdComponentName = ((XSDNamedComponent)xsdComponent).getName()) != null && xsdComponentName.length() > 0) {
            int i = 0;
            while (i < instanceDocuments.length) {
                if (instanceDocuments[i] != null) {
                    String xsiURI = "http://www.w3.org/2001/XMLSchema-instance";
                    String xsiPrefix = this.getPrefixFromNamespaceURI(xsiURI, namespaceTable);
                    String xsiTypeURI = xsdComponent.getSchema().getTargetNamespace();
                    String xsiTypePrefix = this.getPrefixFromNamespaceURI(xsiTypeURI, namespaceTable);
                    StringBuffer attrName = new StringBuffer();
                    attrName.append(xsiPrefix);
                    attrName.append(":");
                    attrName.append("type");
                    StringBuffer attrValue = new StringBuffer();
                    attrValue.append(xsiTypePrefix);
                    attrValue.append(":");
                    attrValue.append(xsdComponentName);
                    instanceDocuments[i].setAttribute(attrName.toString(), attrValue.toString());
                }
                ++i;
            }
        }
        return instanceDocuments;
    }

    @Override
    public boolean validateAllParameterValues() {
        if (!super.validateAllParameterValues()) {
            return false;
        }
        String[] params = this.getParameterValues(this.getID());
        int length = params != null ? params.length : 0;
        int min = this.config_.getMinOccurs();
        int max = this.config_.getMaxOccurs();
        return length >= min && (max == -1 || length <= max);
    }

    protected String getPrefixFromNamespaceURI(String nsURI, Hashtable namespaceTable) {
        String prefix = (String)namespaceTable.get(nsURI);
        int i = 0;
        while (prefix == null || prefix.length() <= 0) {
            StringBuffer prefixCopy = new StringBuffer();
            prefixCopy.append("q");
            prefixCopy.append(String.valueOf(i));
            ++i;
            if (namespaceTable.contains(prefixCopy.toString())) continue;
            namespaceTable.put(nsURI, prefixCopy.toString());
            prefix = prefixCopy.toString();
        }
        return prefix;
    }

    protected Element setElementTagName(Element e, String tagName) {
        if (!e.getTagName().equals(tagName)) {
            try {
                Document doc = e.getOwnerDocument();
                NodeList children = e.getChildNodes();
                NamedNodeMap attributes = e.getAttributes();
                Element eCopy = doc.createElement(tagName);
                int i = 0;
                while (i < children.getLength()) {
                    Node child = children.item(i);
                    if (child != null) {
                        eCopy.appendChild(child.cloneNode(true));
                    }
                    ++i;
                }
                int j = 0;
                while (j < attributes.getLength()) {
                    Node attr = attributes.item(j);
                    if (attr != null && attr instanceof Attr) {
                        Attr attribute = (Attr)attr;
                        eCopy.setAttribute(attribute.getName(), attribute.getValue());
                    }
                    ++j;
                }
                return eCopy;
            }
            catch (Exception exception) {}
        }
        return e;
    }

    protected Element[] setElementsTagName(Element[] e, String tagName) {
        Element[] eCopy = new Element[e.length];
        int i = 0;
        while (i < eCopy.length) {
            eCopy[i] = this.setElementTagName(e[i], tagName);
            ++i;
        }
        return eCopy;
    }

    protected boolean internalEquals(Element[] instanceDocumentsCopy, Element[] instanceDocuments) {
        if (!this.config_.getIsWSDLPart()) {
            int lengthCopy;
            int length = instanceDocuments != null ? instanceDocuments.length : 0;
            int n = lengthCopy = instanceDocumentsCopy != null ? instanceDocumentsCopy.length : 0;
            return length == lengthCopy;
        }
        return true;
    }
}

