/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.index;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.report.engine.content.impl.BookmarkContent;
import org.eclipse.birt.report.engine.internal.index.IDocumentIndexReader;
import org.eclipse.birt.report.engine.internal.index.v0.DocumentIndexReaderV0;
import org.eclipse.birt.report.engine.internal.index.v1.DocumentIndexReaderV1;
import org.eclipse.birt.report.engine.internal.index.v2.DocumentIndexReaderV2;

public class DocumentIndexReader
implements IDocumentIndexReader {
    IDocumentIndexReader reader;

    public DocumentIndexReader(int version, HashMap<String, Long> bookmarks, HashMap<String, Long> reportlets, HashMap<String, Long> pageNumbers) throws IOException {
        if (version != 1) {
            throw new IOException("unsupporter version number:" + version);
        }
        this.reader = new DocumentIndexReaderV1(bookmarks, reportlets, pageNumbers);
    }

    public DocumentIndexReader(int version, IDocArchiveReader archive) throws IOException {
        switch (version) {
            case 0: {
                this.reader = new DocumentIndexReaderV0(archive);
                break;
            }
            case 2: {
                this.reader = new DocumentIndexReaderV2(archive);
                break;
            }
            default: {
                throw new IOException("unsupported version number:" + version);
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            finally {
                this.reader = null;
            }
        }
    }

    @Override
    public int getVersion() {
        return this.reader.getVersion();
    }

    @Override
    public long getOffsetOfBookmark(String bookmark) throws IOException {
        return this.reader.getOffsetOfBookmark(bookmark);
    }

    @Override
    public long getOffsetOfInstance(String instanceId) throws IOException {
        return this.reader.getOffsetOfInstance(instanceId);
    }

    @Override
    public long getPageOfBookmark(String bookmark) throws IOException {
        return this.reader.getPageOfBookmark(bookmark);
    }

    @Override
    public BookmarkContent getBookmark(String bookmark) throws IOException {
        return this.reader.getBookmark(bookmark);
    }

    @Override
    public List<String> getBookmarks() throws IOException {
        return this.reader.getBookmarks();
    }

    @Override
    public List<BookmarkContent> getBookmarkContents() throws IOException {
        return this.reader.getBookmarkContents();
    }
}

