/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.data.dte;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.olap.OLAPException;
import javax.olap.cursor.CubeCursor;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.olap.api.ICubeCursor;
import org.eclipse.birt.data.engine.olap.api.ICubeQueryResults;
import org.eclipse.birt.data.engine.olap.api.query.IBaseCubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ISubCubeQueryDefinition;
import org.eclipse.birt.report.engine.adapter.CubeUtil;
import org.eclipse.birt.report.engine.api.DataSetID;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.data.IDataEngine;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.ICubeResultSet;

public class CubeResultSet
implements ICubeResultSet {
    protected IBaseResultSet parent;
    protected DataSetID id;
    protected String cellId;
    protected IDataEngine dataEngine = null;
    private ExecutionContext context;
    private IBaseCubeQueryDefinition queryDefn;
    private ICubeCursor cube;
    private ICubeQueryResults queryResults;
    private String queryResultsID;
    protected static Logger logger = Logger.getLogger(CubeResultSet.class.getName());

    public CubeResultSet(IDataEngine dataEngine, ExecutionContext context, ICubeQueryDefinition queryDefn, ICubeQueryResults rsets) throws BirtException {
        this.parent = null;
        this.context = context;
        this.dataEngine = dataEngine;
        this.queryDefn = queryDefn;
        this.cube = rsets.getCubeCursor();
        this.id = rsets.getID() != null ? new DataSetID(rsets.getID()) : new DataSetID("cube");
        this.queryResults = rsets;
        this.queryResultsID = rsets.getID();
    }

    public CubeResultSet(IDataEngine dataEngine, ExecutionContext context, IBaseResultSet parent, ICubeQueryDefinition queryDefn, ICubeQueryResults rsets) throws BirtException {
        assert (parent != null);
        this.parent = parent;
        this.cube = rsets.getCubeCursor();
        this.id = rsets.getID() != null ? new DataSetID(rsets.getID()) : new DataSetID("cube");
        this.context = context;
        this.dataEngine = dataEngine;
        this.queryDefn = queryDefn;
        this.queryResults = rsets;
        this.queryResultsID = rsets.getID();
    }

    public CubeResultSet(IDataEngine dataEngine, ExecutionContext context, IBaseResultSet parent, ISubCubeQueryDefinition queryDefn, ICubeQueryResults rsets) throws BirtException {
        assert (parent != null);
        this.parent = parent;
        this.cube = rsets.getCubeCursor();
        this.id = rsets.getID() != null ? new DataSetID(rsets.getID()) : new DataSetID("cube");
        this.context = context;
        this.dataEngine = dataEngine;
        this.queryDefn = queryDefn;
        this.queryResults = rsets;
        this.queryResultsID = rsets.getID();
    }

    public String getQueryResultsID() {
        return this.queryResultsID;
    }

    @Override
    public CubeCursor getCubeCursor() {
        return this.cube;
    }

    @Override
    public String getCellIndex() {
        try {
            this.cellId = CubeUtil.getPositionID((CubeCursor)this.cube);
        }
        catch (OLAPException e) {
            this.context.addException(new EngineException("Error.CubePositionError", e));
        }
        return this.cellId;
    }

    @Override
    public void close() {
        try {
            if (this.queryResults != null) {
                this.queryResults.close();
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        try {
            if (this.cube != null) {
                this.cube.close();
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    @Override
    public Object evaluate(String expr) throws BirtException {
        return this.context.evaluate(expr);
    }

    @Override
    public Object evaluate(String language, String expr) throws BirtException {
        return this.context.evaluateInlineScript(language, expr);
    }

    @Override
    public Object evaluate(IBaseExpression expr) throws BirtException {
        if (expr instanceof IScriptExpression) {
            IScriptExpression scriptExpression = (IScriptExpression)expr;
            return this.context.evaluate(scriptExpression.getText());
        }
        if (expr instanceof IConditionalExpression) {
            return this.context.evaluateCondExpr((IConditionalExpression)expr);
        }
        return null;
    }

    @Override
    public DataSetID getID() {
        return this.id;
    }

    @Override
    public IBaseResultSet getParent() {
        return this.parent;
    }

    @Override
    public IBaseQueryResults getQueryResults() {
        return this.queryResults;
    }

    @Override
    public String getRawID() {
        return this.getCellIndex();
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public void skipTo(String cellIndex) throws BirtException {
        try {
            CubeUtil.positionCursor((CubeCursor)this.cube, cellIndex);
        }
        catch (OLAPException e) {
            throw new EngineException("Error.SkipError", e);
        }
    }

    @Override
    public IBaseCubeQueryDefinition getCubeQuery() {
        return this.queryDefn;
    }
}

