/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.runtime;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.swt.SWTException;

public class GUIException
extends BirtException {
    private static final long serialVersionUID = 1L;
    private static final String MSG_FILE_NOT_FOUND = Messages.getString("ExceptionHandler.Message.FileNotFound");
    private static final String MSG_UNKNOWN_HOST = Messages.getString("ExceptionHandler.Message.UnknownHost");
    private static final String MSG_OUT_OF_MEMORY = Messages.getString("ExceptionHandler.Message.OutOfMemory");
    private static final String MSG_UNEXPECTED_EXCEPTION_OCURR = Messages.getString("ExceptionHandler.Meesage.UnexceptedExceptionOccur");
    private static final String MSG_CAUSED_BY = Messages.getString("ExceptionHandler.Message.CausedBy");
    public static final String GUI_ERROR_CODE_IO = "Error.GUIException.invokedByIOException";
    public static final String GUI_ERROR_CODE_SWT = "Error.GUIException.invokedBySWTException";
    public static final String GUI_ERROR_CODE_OUT_OF_MEMORY = "Error.GUIException.invokedByOutOfMemory";
    public static final String GUI_ERROR_CODE_UNEXPECTED = "Error.GUIException.invokedByUnexpectedException";

    public static GUIException createGUIException(String pluginId, Throwable cause) {
        String errorCode = GUI_ERROR_CODE_UNEXPECTED;
        if (cause instanceof IOException) {
            errorCode = GUI_ERROR_CODE_IO;
        } else if (cause instanceof OutOfMemoryError) {
            errorCode = GUI_ERROR_CODE_OUT_OF_MEMORY;
        } else if (cause instanceof SWTException) {
            errorCode = GUI_ERROR_CODE_SWT;
        }
        GUIException ex = new GUIException(pluginId, errorCode, cause);
        if (errorCode != GUI_ERROR_CODE_UNEXPECTED) {
            ex.setSeverity(5);
        }
        return ex;
    }

    public static GUIException createGUIException(String pluginId, Throwable cause, String errorCode) {
        GUIException ex = new GUIException(pluginId, errorCode, cause);
        if (!GUI_ERROR_CODE_UNEXPECTED.equals(errorCode)) {
            ex.setSeverity(5);
        }
        return ex;
    }

    private GUIException(String pluginId, String errorCode, Throwable cause) {
        super(pluginId, errorCode, null);
        this.initCause(cause);
    }

    public String getMessage() {
        Object message = Messages.getString(this.getErrorCode());
        if (((String)message).equalsIgnoreCase(this.getErrorCode())) {
            message = this.getCause().getLocalizedMessage();
            if (this.getCause() instanceof UnknownHostException) {
                message = MSG_UNKNOWN_HOST + (String)message;
            } else if (this.getCause() instanceof FileNotFoundException) {
                message = MSG_FILE_NOT_FOUND + (String)message;
            } else if (this.getCause() instanceof OutOfMemoryError) {
                message = MSG_OUT_OF_MEMORY;
            }
            if (StringUtil.isBlank((String)message)) {
                message = MessageFormat.format(MSG_CAUSED_BY, this.getCause().getClass().getName());
            }
        }
        return message;
    }

    public String getLocalizedMessage() {
        return this.getMessage();
    }

    public String getReason() {
        String reason = null;
        reason = this.getCause() instanceof OutOfMemoryError ? MSG_OUT_OF_MEMORY : (this.getCause() instanceof IOException || this.getCause() instanceof SWTException ? this.getLocalizedMessage() : MSG_UNEXPECTED_EXCEPTION_OCURR);
        return reason;
    }
}

