/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.commands;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.designer.core.DesignerConstants;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.MetricUtility;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;

public class SetConstraintCommand
extends Command {
    private static Logger logger = Logger.getLogger(SetConstraintCommand.class.getName());
    private static final String TRANS_LABEL_SET_CONSTRAINT = Messages.getString("SetConstraintCommand.transLabel.setConstraint");
    private ReportItemHandle model;
    private static final String Command_Label_Resize = Messages.getString("SetConstraintCommand.commandLabel.ResizeCommand");
    private Dimension newSize;

    public SetConstraintCommand() {
        super(Command_Label_Resize);
    }

    public void execute() {
        CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
        stack.startTrans(TRANS_LABEL_SET_CONSTRAINT);
        try {
            if (DesignerConstants.TRACING_COMMANDS) {
                System.out.println("SetConstraintCommand >>  Starts. Target: " + DEUtil.getDisplayLabel(this.model) + ",New size: " + this.newSize.width + "," + this.newSize.height);
            }
            if (this.model instanceof TableHandle || this.model instanceof GridHandle) {
                HandleAdapterFactory.getInstance().getTableHandleAdapter(this.model).ajustSize(this.newSize);
            } else {
                if (this.newSize.width >= 0) {
                    MetricUtility.updateDimension(this.model.getWidth(), this.newSize.width);
                }
                if (this.newSize.height >= 0) {
                    MetricUtility.updateDimension(this.model.getHeight(), this.newSize.height);
                }
            }
            stack.commit();
            if (DesignerConstants.TRACING_COMMANDS) {
                System.out.println("SetConstraintCommand >> Finised.");
            }
        }
        catch (SemanticException e) {
            if (DesignerConstants.TRACING_COMMANDS) {
                System.out.println("SetConstraintCommand >> Failed.");
            }
            logger.log(Level.SEVERE, e.getMessage(), e);
            stack.rollback();
        }
    }

    public String getLabel() {
        return Command_Label_Resize;
    }

    public void setConstraint(Rectangle r) {
        this.setSize(r.getSize());
    }

    public void setModel(ReportItemHandle model) {
        this.model = model;
    }

    public void setSize(Dimension p) {
        this.newSize = p;
    }
}

