/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.report.designer.core.CorePlugin;
import org.eclipse.core.runtime.Platform;

public class DesignerConstants {
    private static final String FONT_FAMILY_COURIER_NEW = "Courier New";
    private static final String FONT_FAMILY_IMPACT = "Impact";
    private static final String FONT_FAMILY_COMIC_SANS_MS = "Comic Sans MS";
    private static final String FONT_FAMILY_ARIAL = "Arial";
    private static final String FONT_FAMILY_TIMES_NEW_ROMAN = "Times New Roman";
    public static final String KEY_NEWOBJECT = "newObject";
    public static final String NEWOBJECT_FROM_LIBRARY = "newObject from library";
    public static final String DIRECT_CREATEITEM = "direct create item";
    public static final String TABLE_ROW_NUMBER = "rowNumber";
    public static final String TABLE_COLUMN_NUMBER = "columnNumber";
    public static final String DATA_SOURCE_SCRIPT = "script";
    public static final String DATA_SET_SCRIPT = "ScriptSelectDataSet";
    public static final String DATA_SOURCE_XMLFILE = "org.eclipse.birt.report.data.oda.xml";
    public static final Map familyMap = new HashMap();
    public static final Map fontMap = new HashMap();
    public static final String[][] fontSizes;
    public static final boolean DEBUG;
    public static final boolean TRACING_COMMANDS;
    public static final boolean TRACING_MEDIATOR_COLLEAGUE_ADD;
    public static final boolean TRACING_MEDIATOR_COLLEAGUE_REMOVE;
    public static final boolean TRACING_MEDIATOR_GLOBAL_COLLEAGUE_ADD;
    public static final boolean TRACING_MEDIATOR_GLOBAL_COLLEAGUE_REMOVE;
    public static final boolean TRACING_MEDIATOR_NOTIFY;
    public static final boolean TRACING_MEDIATOR_STATE_POP;
    public static final boolean TRACING_MEDIATOR_STATE_PUSH;
    public static final boolean TRACING_MEDIATOR_STATE_RESTORE;
    public static final boolean TRACING_MEDIATOR_DISPOSE;
    public static final boolean TRACING_IMAGE_MANAGER_IMAGE_ADD;
    public static final boolean TRACING_IMAGE_MANAGER_IMAGE_REMOVE;

    static {
        familyMap.put("serif", FONT_FAMILY_TIMES_NEW_ROMAN);
        familyMap.put("sans-serif", FONT_FAMILY_ARIAL);
        familyMap.put("cursive", FONT_FAMILY_COMIC_SANS_MS);
        familyMap.put("fantasy", FONT_FAMILY_IMPACT);
        familyMap.put("monospace", FONT_FAMILY_COURIER_NEW);
        fontSizes = new String[][]{{"xx-small", "7"}, {"x-small", "8"}, {"small", "10"}, {"medium", "12"}, {"large", "14"}, {"x-large", "17"}, {"xx-large", "20"}};
        int i = 0;
        while (i < fontSizes.length) {
            fontMap.put(fontSizes[i][0], fontSizes[i][1]);
            ++i;
        }
        DEBUG = CorePlugin.getDefault().isDebugging();
        TRACING_COMMANDS = DesignerConstants.getDebugOption("commands");
        TRACING_MEDIATOR_COLLEAGUE_ADD = DesignerConstants.getDebugOption("mediator.addColleague");
        TRACING_MEDIATOR_COLLEAGUE_REMOVE = DesignerConstants.getDebugOption("mediator.removeColleague");
        TRACING_MEDIATOR_GLOBAL_COLLEAGUE_ADD = DesignerConstants.getDebugOption("mediator.addGlobalColleague");
        TRACING_MEDIATOR_GLOBAL_COLLEAGUE_REMOVE = DesignerConstants.getDebugOption("mediator.removeGlobalColleague");
        TRACING_MEDIATOR_NOTIFY = DesignerConstants.getDebugOption("mediator.notifyRequest");
        TRACING_MEDIATOR_STATE_POP = DesignerConstants.getDebugOption("mediator.popState");
        TRACING_MEDIATOR_STATE_PUSH = DesignerConstants.getDebugOption("mediator.pushState");
        TRACING_MEDIATOR_STATE_RESTORE = DesignerConstants.getDebugOption("mediator.restoreState");
        TRACING_MEDIATOR_DISPOSE = DesignerConstants.getDebugOption("mediator.dispose");
        TRACING_IMAGE_MANAGER_IMAGE_ADD = DesignerConstants.getDebugOption("imageManger.addImage");
        TRACING_IMAGE_MANAGER_IMAGE_REMOVE = DesignerConstants.getDebugOption("imageManger.removeImage");
    }

    public static boolean getDebugOption(String id) {
        boolean option = false;
        if (DEBUG) {
            option = "true".equalsIgnoreCase(Platform.getDebugOption((String)("org.eclipse.birt.report.designer.core/tracing/" + id)));
        }
        return option;
    }
}

