/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt;

import org.eclipse.birt.chart.model.impl.ChartModelHelper;
import org.eclipse.birt.chart.ui.swt.DataDefinitionTextManager;
import org.eclipse.birt.chart.ui.swt.SimpleTextTransfer;
import org.eclipse.birt.chart.ui.swt.interfaces.IExpressionButton;
import org.eclipse.birt.chart.util.ChartExpressionUtil;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class DataTextDropListener
extends DropTargetAdapter {
    private final Control txtDataDefn;
    private final IExpressionButton btnBuilder;

    public DataTextDropListener(Control txtDataDefn, IExpressionButton btnBuilder) {
        this.txtDataDefn = txtDataDefn;
        this.btnBuilder = btnBuilder;
        assert (txtDataDefn instanceof Text || txtDataDefn instanceof Combo || txtDataDefn instanceof CCombo);
    }

    public void dragEnter(DropTargetEvent event) {
        event.detail = 1;
        if ("win32".equals(Platform.getOS())) {
            Object object = null;
            Transfer[] transferAgents = ((DropTarget)event.widget).getTransfer();
            int i = 0;
            while (i < transferAgents.length) {
                Transfer transfer = transferAgents[i];
                if (transfer instanceof SimpleTextTransfer) {
                    object = SimpleTextTransfer.getInstance().nativeToJava(event.currentDataType);
                    break;
                }
                ++i;
            }
            if (object != null) {
                ChartExpressionUtil.ExpressionCodec expCodec = ChartModelHelper.instance().createExpressionCodec();
                expCodec.setType(this.btnBuilder.getExpressionType());
                expCodec.setBindingName(object.toString(), this.btnBuilder.isCube());
                if (!DataDefinitionTextManager.getInstance().isValidExpression(this.txtDataDefn, expCodec.getExpression())) {
                    event.detail = 0;
                }
            }
        }
    }

    public void dragOperationChanged(DropTargetEvent event) {
        event.detail = 1;
    }

    public void dragOver(DropTargetEvent event) {
        event.feedback = 9;
    }

    public void drop(DropTargetEvent event) {
        String bindingName = (String)event.data;
        if (!"win32".equals(Platform.getOS())) {
            ChartExpressionUtil.ExpressionCodec expCodec = ChartModelHelper.instance().createExpressionCodec();
            expCodec.setBindingName(bindingName, this.btnBuilder.isCube());
            if (!DataDefinitionTextManager.getInstance().isValidExpression(this.txtDataDefn, expCodec.getExpression())) {
                return;
            }
        }
        this.btnBuilder.setBindingName(bindingName, true);
    }
}

