/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.breadcrumb;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.core.mediator.IMediatorRequest;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.util.mediator.request.ReportRequest;
import org.eclipse.birt.report.designer.internal.ui.editors.breadcrumb.BreadcrumbViewTreeProvider;
import org.eclipse.birt.report.designer.internal.ui.editors.breadcrumb.BreadcrumbViewer;
import org.eclipse.birt.report.designer.internal.ui.editors.breadcrumb.EditorBreadcrumb;
import org.eclipse.birt.report.designer.internal.ui.editors.breadcrumb.providers.DefaultBreadcrumbNodeProvider;
import org.eclipse.birt.report.designer.internal.ui.editors.breadcrumb.providers.DesignerBreadcrumbNodeProvider;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.birt.report.designer.ui.views.ProviderFactory;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.validators.IValidationListener;
import org.eclipse.birt.report.model.api.validators.ValidationEvent;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.actions.ActionGroup;

public class ReportLayoutEditorBreadcrumb
extends EditorBreadcrumb
implements IValidationListener {
    private ProblemBreadcrumbViewer fViewer;
    private DefaultBreadcrumbNodeProvider provider;

    public ReportLayoutEditorBreadcrumb(GraphicalEditorWithFlyoutPalette editor) {
        super(editor);
    }

    public DefaultBreadcrumbNodeProvider getBreadcrumbNodeProvider(Object element) {
        if (this.provider == null) {
            this.provider = new DesignerBreadcrumbNodeProvider();
        }
        this.provider.setContext(element);
        return this.provider;
    }

    public void setBreadcrumbNodeProvider(DefaultBreadcrumbNodeProvider provider) {
        this.provider = provider;
    }

    @Override
    protected Object getCurrentInput() {
        return null;
    }

    @Override
    protected BreadcrumbViewer createViewer(Composite parent) {
        Object model;
        BreadcrumbViewTreeProvider provier = new BreadcrumbViewTreeProvider(this.getEditor());
        this.fViewer = new ProblemBreadcrumbViewer(parent, 256);
        this.fViewer.setContentProvider((IContentProvider)provier);
        this.fViewer.setLabelProvider((IBaseLabelProvider)provier);
        if (this.getEditor() != null && (model = this.getEditor().getGraphicalViewer().getRootEditPart().getContents().getModel()) instanceof ModuleHandle) {
            ((ModuleHandle)model).addValidationListener((IValidationListener)this);
        }
        return this.fViewer;
    }

    @Override
    public void dispose() {
        Object model;
        if (this.getEditor() != null && (model = this.getEditor().getGraphicalViewer().getRootEditPart().getContents().getModel()) instanceof ModuleHandle) {
            ((ModuleHandle)model).removeValidationListener((IValidationListener)this);
        }
        super.dispose();
    }

    @Override
    protected boolean reveal(Object element) {
        boolean flag = false;
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.getBreadcrumbNodeProvider(this.getEditor().getGraphicalViewer()).getRealModel(element));
        if (this.fViewer != null && (this.fViewer.getDropDownShell() == null || this.fViewer.getDropDownShell() != null && !this.fViewer.getDropDownShell().isDisposed())) {
            flag = true;
            ReportRequest r = new ReportRequest((Object)this);
            r.setSelectionObject(list);
            r.setType((Object)"selection");
            SessionHandleAdapter.getInstance().getMediator().notifyRequest((IMediatorRequest)r);
        }
        return flag;
    }

    @Override
    protected boolean open(Object element) {
        boolean flag = false;
        List list = this.getEditor().getGraphicalViewer().getSelectedEditParts();
        if (list.size() == 1) {
            Request request;
            if (this.getBreadcrumbNodeProvider(this.getEditor().getGraphicalViewer()).getEditPart(element) != list.get(0)) {
                return false;
            }
            EditPart editPart = (EditPart)list.get(0);
            if (editPart.understandsRequest(request = new Request((Object)"open"))) {
                editPart.performRequest(request);
                return true;
            }
        }
        return flag;
    }

    @Override
    protected ActionGroup createContextMenuActionGroup(ISelectionProvider selectionProvider) {
        return null;
    }

    @Override
    protected void activateBreadcrumb() {
    }

    @Override
    protected void deactivateBreadcrumb() {
    }

    @Override
    protected void createContextMenu(Object element, MenuManager manager) {
        Object model = this.getBreadcrumbNodeProvider(this.getEditor().getGraphicalViewer()).getRealModel(element);
        ProviderFactory.createProvider(model).createContextMenu(null, model, (IMenuManager)manager);
    }

    public void elementValidated(DesignElementHandle targetElement, ValidationEvent ev) {
        if (this.fBreadcrumbViewer != null && this.fBreadcrumbViewer.getControl() != null && !this.fBreadcrumbViewer.getControl().isDisposed()) {
            this.fBreadcrumbViewer.refresh();
        }
    }

    private class ProblemBreadcrumbViewer
    extends BreadcrumbViewer {
        public ProblemBreadcrumbViewer(Composite parent, int style) {
            super(parent, style);
        }

        @Override
        public void configureDropDownViewer(TreeViewer viewer, Object input) {
            BreadcrumbViewTreeProvider provier = new BreadcrumbViewTreeProvider(ReportLayoutEditorBreadcrumb.this.getEditor());
            viewer.setContentProvider((IContentProvider)provier);
            viewer.setLabelProvider((IBaseLabelProvider)provier);
        }

        @Override
        protected int buildItemChain(Object element) {
            if (element != null && !ReportLayoutEditorBreadcrumb.this.getBreadcrumbNodeProvider(ReportLayoutEditorBreadcrumb.this.getEditor().getGraphicalViewer()).validate(element)) {
                if (ReportLayoutEditorBreadcrumb.this.getEditor().getGraphicalViewer().getRootEditPart().getChildren().size() == 1) {
                    return super.buildItemChain(ReportLayoutEditorBreadcrumb.this.getEditor().getGraphicalViewer().getRootEditPart().getChildren().get(0));
                }
                return 0;
            }
            return super.buildItemChain(element);
        }
    }
}

