/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.cubebuilder.joins.editparts;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.eclipse.birt.report.designer.ui.cubebuilder.joins.editparts.NodeEditPartHelper;
import org.eclipse.birt.report.designer.ui.cubebuilder.joins.editpolicies.TableSelectionEditPolicy;
import org.eclipse.birt.report.designer.ui.cubebuilder.joins.figures.TableNodeFigure;
import org.eclipse.birt.report.designer.ui.cubebuilder.joins.figures.TablePaneFigure;
import org.eclipse.birt.report.designer.ui.cubebuilder.util.OlapUtil;
import org.eclipse.birt.report.designer.ui.cubebuilder.util.UIHelper;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.birt.report.model.api.olap.TabularHierarchyHandle;
import org.eclipse.birt.report.model.api.olap.TabularLevelHandle;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Polygon;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.tools.DragEditPartsTracker;

public class HierarchyNodeEditPart
extends NodeEditPartHelper
implements Listener {
    public TablePaneFigure scrollPane;
    public TableNodeFigure tableNode;
    private TabularCubeHandle cube;
    private DimensionHandle dimension;
    private TabularHierarchyHandle hierarchy;

    public HierarchyNodeEditPart(EditPart parent, TabularHierarchyHandle hierarchy) {
        this.setModel(hierarchy);
        this.setParent(parent);
        this.dimension = (DimensionHandle)hierarchy.getContainer();
        this.cube = (TabularCubeHandle)parent.getModel();
        this.hierarchy = hierarchy;
    }

    @Override
    protected IFigure createFigure() {
        String name = this.dimension.getName() + " (" + this.hierarchy.getDataSet().getName() + ")";
        this.tableNode = new TableNodeFigure(name);
        this.scrollPane = new TablePaneFigure(name);
        this.scrollPane.setContents((IFigure)this.tableNode);
        return this.scrollPane;
    }

    protected List getModelChildren() {
        ArrayList<ResultSetColumnHandle> childList = new ArrayList<ResultSetColumnHandle>();
        TabularLevelHandle[] levels = this.hierarchy.getContents("levels").toArray(new TabularLevelHandle[0]);
        if (levels != null) {
            int i = 0;
            while (i < levels.length) {
                ResultSetColumnHandle resultSetColumn;
                if (levels[i].getColumnName() != null && (resultSetColumn = OlapUtil.getDataField(this.hierarchy.getDataSet(), levels[i].getColumnName())) != null && !childList.contains(resultSetColumn)) {
                    boolean flag = true;
                    int j = 0;
                    while (j < childList.size()) {
                        ResultSetColumnHandle column = (ResultSetColumnHandle)childList.get(j);
                        if (column.getColumnName().equals(resultSetColumn.getColumnName())) {
                            flag = false;
                            break;
                        }
                        ++j;
                    }
                    if (flag) {
                        childList.add(resultSetColumn);
                    }
                }
                ++i;
            }
        }
        return childList;
    }

    protected void refreshVisuals() {
        Rectangle r;
        if (!UIHelper.existIntProperty(((ReportElementHandle)this.getModel()).getRoot(), UIHelper.getId(this.getModel(), this.cube), "x")) {
            int i;
            int displayWidth = 460;
            int displayHeight = 380;
            ArrayList<Object> childList = new ArrayList<Object>();
            if (this.getCube() != null) {
                childList.add(this.getCube().getDataSet());
                DimensionHandle[] dimensions = this.getCube().getContents("dimensions").toArray(new DimensionHandle[0]);
                i = 0;
                while (i < dimensions.length) {
                    TabularHierarchyHandle hierarchy = (TabularHierarchyHandle)dimensions[i].getDefaultHierarchy();
                    if (hierarchy != null && hierarchy.getDataSet() != null) {
                        childList.add(hierarchy);
                    }
                    ++i;
                }
            }
            ArrayList<Polygon> polygonList = new ArrayList<Polygon>();
            i = 0;
            while (i < childList.size()) {
                if (this.existPosX(childList.get(i))) {
                    polygonList.add(this.getPolygon(childList.get(i)));
                }
                ++i;
            }
            int width = this.getWidth(this.getModel());
            int height = this.getHeight(this.getModel());
            boolean contain = false;
            int x = 0;
            int y = 0;
            int i2 = 0;
            while (i2 < 100) {
                x = new Random().nextInt(displayWidth - width);
                y = new Random().nextInt(displayHeight - height);
                int j = 0;
                while (j < polygonList.size()) {
                    contain = true;
                    Polygon polygon = (Polygon)polygonList.get(j);
                    if (polygon.containsPoint(x, y) || polygon.containsPoint(x + width, y) || polygon.containsPoint(x + width, y + height) || polygon.containsPoint(x, y + height)) break;
                    contain = false;
                    ++j;
                }
                if (!contain) break;
                ++i2;
            }
            polygonList.clear();
            childList.clear();
            r = !contain ? new Rectangle(this.setPosX(x), this.setPosY(y), width, height) : new Rectangle(this.getPosX(this.getModel()), this.getPosY(this.getModel()), this.getWidth(this.getModel()), this.getHeight(this.getModel()));
        } else {
            r = new Rectangle(this.getPosX(this.getModel()), this.getPosY(this.getModel()), this.getWidth(this.getModel()), this.getHeight(this.getModel()));
        }
        this.getFigure().setBounds(r);
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)r);
    }

    private Polygon getPolygon(Object model) {
        Polygon polygon = new Polygon();
        int x = this.getPosX(model);
        int y = this.getPosY(model);
        int width = this.getWidth(model);
        int height = this.getHeight(model);
        polygon.addPoint(new Point(x - 50, y - 50));
        polygon.addPoint(new Point(x + width + 50, y - 50));
        polygon.addPoint(new Point(x + width + 50, y + height + 50));
        polygon.addPoint(new Point(x - 50, y + height + 50));
        return polygon;
    }

    private int getWidth(Object model) {
        int width = UIHelper.getIntProperty(((ReportElementHandle)model).getRoot(), UIHelper.getId(model, this.cube), "width");
        return width == 0 ? 150 : width;
    }

    private int getHeight(Object model) {
        int height = UIHelper.getIntProperty(((ReportElementHandle)model).getRoot(), UIHelper.getId(model, this.cube), "height");
        return height == 0 ? 200 : height;
    }

    private int getPosX(Object model) {
        int x = UIHelper.getIntProperty(((ReportElementHandle)model).getRoot(), UIHelper.getId(model, this.cube), "x");
        return x;
    }

    private int getPosY(Object model) {
        int y = UIHelper.getIntProperty(((ReportElementHandle)model).getRoot(), UIHelper.getId(model, this.cube), "y");
        return y;
    }

    private int setPosX(int x) {
        try {
            UIHelper.setIntProperty(((ReportElementHandle)this.getModel()).getRoot(), UIHelper.getId(this.getModel(), this.cube), "x", x);
        }
        catch (SemanticException e) {
            ExceptionUtil.handle((Throwable)e);
        }
        return x;
    }

    private int setPosY(int y) {
        try {
            UIHelper.setIntProperty(((ReportElementHandle)this.getModel()).getRoot(), UIHelper.getId(this.getModel(), this.cube), "y", y);
        }
        catch (SemanticException e) {
            ExceptionUtil.handle((Throwable)e);
        }
        return y;
    }

    private boolean existPosX(Object model) {
        return UIHelper.existIntProperty(((ReportElementHandle)model).getRoot(), UIHelper.getId(model, this.cube), "x");
    }

    @Override
    protected void createEditPolicies() {
        this.installEditPolicy("Selection Feedback", (EditPolicy)new TableSelectionEditPolicy());
    }

    @Override
    public IFigure getChopFigure() {
        return null;
    }

    public IFigure getContentPane() {
        return this.tableNode;
    }

    public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
        if (this.isActive() && !this.isDelete()) {
            this.refresh();
        }
    }

    public void deactivate() {
        super.deactivate();
        this.cube.getRoot().removeListener((Listener)this);
    }

    public void activate() {
        super.activate();
        this.cube.getRoot().addListener((Listener)this);
    }

    public DragTracker getDragTracker(Request req) {
        DragEditPartsTracker track = new DragEditPartsTracker((EditPart)this);
        return track;
    }

    public TabularCubeHandle getCube() {
        return this.cube;
    }
}

