/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.Bytes;
import com.mongodb.DBDecoderFactory;
import com.mongodb.DBEncoderFactory;
import com.mongodb.DefaultDBDecoder;
import com.mongodb.DefaultDBEncoder;
import com.mongodb.MongoClientOptions;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import javax.net.SocketFactory;

public class MongoOptions {
    public String description;
    public int connectionsPerHost;
    public int threadsAllowedToBlockForConnectionMultiplier;
    public int maxWaitTime;
    public int connectTimeout;
    public int socketTimeout;
    public boolean socketKeepAlive;
    public boolean autoConnectRetry;
    public long maxAutoConnectRetryTime;
    @Deprecated
    public boolean slaveOk;
    public ReadPreference readPreference;
    public DBDecoderFactory dbDecoderFactory;
    public DBEncoderFactory dbEncoderFactory;
    public boolean safe;
    public int w;
    public int wtimeout;
    public boolean fsync;
    public boolean j;
    public SocketFactory socketFactory;
    public boolean cursorFinalizerEnabled;
    public WriteConcern writeConcern;

    public MongoOptions() {
        this.reset();
    }

    public MongoOptions(MongoClientOptions options) {
        this.connectionsPerHost = options.getConnectionsPerHost();
        this.threadsAllowedToBlockForConnectionMultiplier = options.getThreadsAllowedToBlockForConnectionMultiplier();
        this.maxWaitTime = options.getMaxWaitTime();
        this.connectTimeout = options.getConnectTimeout();
        this.socketTimeout = options.getSocketTimeout();
        this.socketKeepAlive = options.isSocketKeepAlive();
        this.autoConnectRetry = options.isAutoConnectRetry();
        this.maxAutoConnectRetryTime = options.getMaxAutoConnectRetryTime();
        this.readPreference = options.getReadPreference();
        this.dbDecoderFactory = options.getDbDecoderFactory();
        this.dbEncoderFactory = options.getDbEncoderFactory();
        this.socketFactory = options.getSocketFactory();
        this.description = options.getDescription();
        this.cursorFinalizerEnabled = options.isCursorFinalizerEnabled();
        this.writeConcern = options.getWriteConcern();
        this.slaveOk = false;
    }

    public void reset() {
        this.connectionsPerHost = Bytes.CONNECTIONS_PER_HOST;
        this.threadsAllowedToBlockForConnectionMultiplier = 5;
        this.maxWaitTime = 120000;
        this.connectTimeout = 10000;
        this.socketTimeout = 0;
        this.socketKeepAlive = false;
        this.autoConnectRetry = false;
        this.maxAutoConnectRetryTime = 0L;
        this.slaveOk = false;
        this.readPreference = null;
        this.safe = false;
        this.w = 0;
        this.wtimeout = 0;
        this.fsync = false;
        this.j = false;
        this.dbDecoderFactory = DefaultDBDecoder.FACTORY;
        this.dbEncoderFactory = DefaultDBEncoder.FACTORY;
        this.socketFactory = SocketFactory.getDefault();
        this.description = null;
        this.cursorFinalizerEnabled = true;
    }

    public MongoOptions copy() {
        MongoOptions m = new MongoOptions();
        m.connectionsPerHost = this.connectionsPerHost;
        m.threadsAllowedToBlockForConnectionMultiplier = this.threadsAllowedToBlockForConnectionMultiplier;
        m.maxWaitTime = this.maxWaitTime;
        m.connectTimeout = this.connectTimeout;
        m.socketTimeout = this.socketTimeout;
        m.socketKeepAlive = this.socketKeepAlive;
        m.autoConnectRetry = this.autoConnectRetry;
        m.maxAutoConnectRetryTime = this.maxAutoConnectRetryTime;
        m.slaveOk = this.slaveOk;
        m.readPreference = this.readPreference;
        m.safe = this.safe;
        m.w = this.w;
        m.wtimeout = this.wtimeout;
        m.fsync = this.fsync;
        m.j = this.j;
        m.dbDecoderFactory = this.dbDecoderFactory;
        m.dbEncoderFactory = this.dbEncoderFactory;
        m.socketFactory = this.socketFactory;
        m.description = this.description;
        m.cursorFinalizerEnabled = this.cursorFinalizerEnabled;
        return m;
    }

    public WriteConcern getWriteConcern() {
        if (this.writeConcern != null) {
            return this.writeConcern;
        }
        if (this.w != 0 || this.wtimeout != 0 || this.fsync | this.j) {
            return new WriteConcern(this.w, this.wtimeout, this.fsync, this.j);
        }
        if (this.safe) {
            return WriteConcern.SAFE;
        }
        return WriteConcern.NORMAL;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoOptions options = (MongoOptions)o;
        if (this.autoConnectRetry != options.autoConnectRetry) {
            return false;
        }
        if (this.connectTimeout != options.connectTimeout) {
            return false;
        }
        if (this.connectionsPerHost != options.connectionsPerHost) {
            return false;
        }
        if (this.cursorFinalizerEnabled != options.cursorFinalizerEnabled) {
            return false;
        }
        if (this.fsync != options.fsync) {
            return false;
        }
        if (this.j != options.j) {
            return false;
        }
        if (this.maxAutoConnectRetryTime != options.maxAutoConnectRetryTime) {
            return false;
        }
        if (this.maxWaitTime != options.maxWaitTime) {
            return false;
        }
        if (this.safe != options.safe) {
            return false;
        }
        if (this.slaveOk != options.slaveOk) {
            return false;
        }
        if (this.socketKeepAlive != options.socketKeepAlive) {
            return false;
        }
        if (this.socketTimeout != options.socketTimeout) {
            return false;
        }
        if (this.threadsAllowedToBlockForConnectionMultiplier != options.threadsAllowedToBlockForConnectionMultiplier) {
            return false;
        }
        if (this.w != options.w) {
            return false;
        }
        if (this.wtimeout != options.wtimeout) {
            return false;
        }
        if (this.dbDecoderFactory != null ? !this.dbDecoderFactory.equals(options.dbDecoderFactory) : options.dbDecoderFactory != null) {
            return false;
        }
        if (this.dbEncoderFactory != null ? !this.dbEncoderFactory.equals(options.dbEncoderFactory) : options.dbEncoderFactory != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(options.description) : options.description != null) {
            return false;
        }
        if (this.readPreference != null ? !this.readPreference.equals(options.readPreference) : options.readPreference != null) {
            return false;
        }
        if (this.socketFactory != null ? !this.socketFactory.equals(options.socketFactory) : options.socketFactory != null) {
            return false;
        }
        return !(this.writeConcern != null ? !this.writeConcern.equals(options.writeConcern) : options.writeConcern != null);
    }

    public int hashCode() {
        int result = this.description != null ? this.description.hashCode() : 0;
        result = 31 * result + this.connectionsPerHost;
        result = 31 * result + this.threadsAllowedToBlockForConnectionMultiplier;
        result = 31 * result + this.maxWaitTime;
        result = 31 * result + this.connectTimeout;
        result = 31 * result + this.socketTimeout;
        result = 31 * result + (this.socketKeepAlive ? 1 : 0);
        result = 31 * result + (this.autoConnectRetry ? 1 : 0);
        result = 31 * result + (int)(this.maxAutoConnectRetryTime ^ this.maxAutoConnectRetryTime >>> 32);
        result = 31 * result + (this.slaveOk ? 1 : 0);
        result = 31 * result + (this.readPreference != null ? this.readPreference.hashCode() : 0);
        result = 31 * result + (this.dbDecoderFactory != null ? this.dbDecoderFactory.hashCode() : 0);
        result = 31 * result + (this.dbEncoderFactory != null ? this.dbEncoderFactory.hashCode() : 0);
        result = 31 * result + (this.safe ? 1 : 0);
        result = 31 * result + this.w;
        result = 31 * result + this.wtimeout;
        result = 31 * result + (this.fsync ? 1 : 0);
        result = 31 * result + (this.j ? 1 : 0);
        result = 31 * result + (this.socketFactory != null ? this.socketFactory.hashCode() : 0);
        result = 31 * result + (this.cursorFinalizerEnabled ? 1 : 0);
        result = 31 * result + (this.writeConcern != null ? this.writeConcern.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("description=").append(this.description).append(", ");
        buf.append("connectionsPerHost=").append(this.connectionsPerHost).append(", ");
        buf.append("threadsAllowedToBlockForConnectionMultiplier=").append(this.threadsAllowedToBlockForConnectionMultiplier).append(", ");
        buf.append("maxWaitTime=").append(this.maxWaitTime).append(", ");
        buf.append("connectTimeout=").append(this.connectTimeout).append(", ");
        buf.append("socketTimeout=").append(this.socketTimeout).append(", ");
        buf.append("socketKeepAlive=").append(this.socketKeepAlive).append(", ");
        buf.append("autoConnectRetry=").append(this.autoConnectRetry).append(", ");
        buf.append("maxAutoConnectRetryTime=").append(this.maxAutoConnectRetryTime).append(", ");
        buf.append("slaveOk=").append(this.slaveOk).append(", ");
        if (this.readPreference != null) {
            buf.append("readPreference").append(this.readPreference);
        }
        if (this.writeConcern != null) {
            buf.append("writeConcern").append(this.writeConcern);
        }
        buf.append("safe=").append(this.safe).append(", ");
        buf.append("w=").append(this.w).append(", ");
        buf.append("wtimeout=").append(this.wtimeout).append(", ");
        buf.append("fsync=").append(this.fsync).append(", ");
        buf.append("j=").append(this.j).append(", ");
        buf.append("cursorFinalizerEnabled=").append(this.cursorFinalizerEnabled);
        return buf.toString();
    }

    public synchronized String getDescription() {
        return this.description;
    }

    public synchronized void setDescription(String desc) {
        this.description = desc;
    }

    public synchronized int getConnectionsPerHost() {
        return this.connectionsPerHost;
    }

    public synchronized void setConnectionsPerHost(int connections) {
        this.connectionsPerHost = connections;
    }

    public synchronized int getThreadsAllowedToBlockForConnectionMultiplier() {
        return this.threadsAllowedToBlockForConnectionMultiplier;
    }

    public synchronized void setThreadsAllowedToBlockForConnectionMultiplier(int threads) {
        this.threadsAllowedToBlockForConnectionMultiplier = threads;
    }

    public synchronized int getMaxWaitTime() {
        return this.maxWaitTime;
    }

    public synchronized void setMaxWaitTime(int timeMS) {
        this.maxWaitTime = timeMS;
    }

    public synchronized int getConnectTimeout() {
        return this.connectTimeout;
    }

    public synchronized void setConnectTimeout(int timeoutMS) {
        this.connectTimeout = timeoutMS;
    }

    public synchronized int getSocketTimeout() {
        return this.socketTimeout;
    }

    public synchronized void setSocketTimeout(int timeoutMS) {
        this.socketTimeout = timeoutMS;
    }

    public synchronized boolean isSocketKeepAlive() {
        return this.socketKeepAlive;
    }

    public synchronized void setSocketKeepAlive(boolean keepAlive) {
        this.socketKeepAlive = keepAlive;
    }

    public synchronized boolean isAutoConnectRetry() {
        return this.autoConnectRetry;
    }

    public synchronized void setAutoConnectRetry(boolean retry) {
        this.autoConnectRetry = retry;
    }

    public synchronized long getMaxAutoConnectRetryTime() {
        return this.maxAutoConnectRetryTime;
    }

    public synchronized void setMaxAutoConnectRetryTime(long retryTimeMS) {
        this.maxAutoConnectRetryTime = retryTimeMS;
    }

    public synchronized DBDecoderFactory getDbDecoderFactory() {
        return this.dbDecoderFactory;
    }

    public synchronized void setDbDecoderFactory(DBDecoderFactory factory) {
        this.dbDecoderFactory = factory;
    }

    public synchronized DBEncoderFactory getDbEncoderFactory() {
        return this.dbEncoderFactory;
    }

    public synchronized void setDbEncoderFactory(DBEncoderFactory factory) {
        this.dbEncoderFactory = factory;
    }

    public synchronized boolean isSafe() {
        return this.safe;
    }

    public synchronized void setSafe(boolean isSafe) {
        this.safe = isSafe;
    }

    public synchronized int getW() {
        return this.w;
    }

    public synchronized void setW(int val) {
        this.w = val;
    }

    public synchronized int getWtimeout() {
        return this.wtimeout;
    }

    public synchronized void setWtimeout(int timeoutMS) {
        this.wtimeout = timeoutMS;
    }

    public synchronized boolean isFsync() {
        return this.fsync;
    }

    public synchronized void setFsync(boolean sync) {
        this.fsync = sync;
    }

    public synchronized boolean isJ() {
        return this.j;
    }

    public synchronized void setJ(boolean safe) {
        this.j = safe;
    }

    public void setWriteConcern(WriteConcern writeConcern) {
        this.writeConcern = writeConcern;
    }

    public synchronized SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public synchronized void setSocketFactory(SocketFactory factory) {
        this.socketFactory = factory;
    }

    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    public void setReadPreference(ReadPreference readPreference) {
        this.readPreference = readPreference;
    }

    public boolean isCursorFinalizerEnabled() {
        return this.cursorFinalizerEnabled;
    }

    public void setCursorFinalizerEnabled(boolean cursorFinalizerEnabled) {
        this.cursorFinalizerEnabled = cursorFinalizerEnabled;
    }
}

