/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.graph;

import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.GraphVisitor;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.Path;
import org.eclipse.draw2d.graph.ShortestPathRouter;
import org.eclipse.draw2d.graph.SubgraphBoundary;
import org.eclipse.draw2d.graph.VirtualNode;

class RouteEdges
extends GraphVisitor {
    RouteEdges() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void revisit(DirectedGraph g) {
        for (Edge edge : g.edges) {
            edge.start = new Point(edge.getSourceOffset() + edge.source.x, edge.source.y + edge.source.height);
            Node node = edge.source;
            if (node instanceof SubgraphBoundary) {
                void boundary;
                SubgraphBoundary cfr_ignored_0 = (SubgraphBoundary)node;
                SubgraphBoundary cfr_ignored_1 = (SubgraphBoundary)node;
                if (boundary.getParent().head == boundary) {
                    edge.start.y = boundary.getParent().y + boundary.getParent().insets.top;
                }
            }
            edge.end = new Point(edge.getTargetOffset() + edge.target.x, edge.target.y);
            if (edge.vNodes != null) {
                RouteEdges.routeLongEdge(edge, g);
                continue;
            }
            PointList list = new PointList();
            list.addPoint(edge.start);
            list.addPoint(edge.end);
            edge.setPoints(list);
        }
    }

    static void routeLongEdge(Edge edge, DirectedGraph g) {
        ShortestPathRouter router = new ShortestPathRouter();
        Path path = new Path(edge.start, edge.end);
        router.addPath(path);
        for (Node element : edge.vNodes) {
            Insets padding;
            Rectangle o;
            Node neighbor;
            VirtualNode node = (VirtualNode)element;
            if (node.left != null) {
                neighbor = node.left;
                o = new Rectangle(neighbor.x, neighbor.y, neighbor.width, neighbor.height);
                padding = g.getPadding(neighbor);
                o.width += padding.right + padding.left;
                o.width += edge.getPadding() * 2;
                o.x -= padding.left + edge.getPadding();
                o.union(o.getLocation().translate(-100000, 2));
                router.addObstacle(o);
            }
            if (node.right == null) continue;
            neighbor = node.right;
            o = new Rectangle(neighbor.x, neighbor.y, neighbor.width, neighbor.height);
            padding = g.getPadding(neighbor);
            o.width += padding.right + padding.left;
            o.width += edge.getPadding() * 2;
            o.x -= padding.left + edge.getPadding();
            o.union(o.getLocation().translate(100000, 2));
            router.addObstacle(o);
        }
        router.setSpacing(0);
        router.solve();
        edge.setPoints(path.getPoints());
    }
}

