/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui.views.repository;

import aQute.bnd.build.Workspace;
import aQute.bnd.exceptions.Exceptions;
import aQute.bnd.http.HttpClient;
import aQute.bnd.service.Actionable;
import aQute.bnd.service.Refreshable;
import aQute.bnd.service.RemoteRepositoryPlugin;
import aQute.bnd.service.RepositoryPlugin;
import aQute.bnd.service.clipboard.Clipboard;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.jar.JarFile;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.bnd.ui.Central;
import org.eclipse.pde.bnd.ui.FilterPanelPart;
import org.eclipse.pde.bnd.ui.HelpButtons;
import org.eclipse.pde.bnd.ui.HierarchicalLabel;
import org.eclipse.pde.bnd.ui.HierarchicalMenu;
import org.eclipse.pde.bnd.ui.RepositoryUtils;
import org.eclipse.pde.bnd.ui.Resources;
import org.eclipse.pde.bnd.ui.SWTUtil;
import org.eclipse.pde.bnd.ui.SelectionDragAdapter;
import org.eclipse.pde.bnd.ui.Workspaces;
import org.eclipse.pde.bnd.ui.dnd.GAVIPageListener;
import org.eclipse.pde.bnd.ui.model.repo.RepositoryBundle;
import org.eclipse.pde.bnd.ui.model.repo.RepositoryBundleVersion;
import org.eclipse.pde.bnd.ui.model.repo.RepositoryEntry;
import org.eclipse.pde.bnd.ui.model.repo.RepositoryTreeLabelProvider;
import org.eclipse.pde.bnd.ui.model.repo.SearchableRepositoryTreeContentProvider;
import org.eclipse.pde.bnd.ui.plugins.RepositoriesViewRefresher;
import org.eclipse.pde.bnd.ui.preferences.BndPreferences;
import org.eclipse.pde.bnd.ui.preferences.WorkspaceOfflineChangeAdapter;
import org.eclipse.pde.bnd.ui.views.ViewEventTopics;
import org.eclipse.pde.bnd.ui.views.repository.AdvancedSearchDialog;
import org.eclipse.pde.bnd.ui.views.repository.RepoDownloadJob;
import org.eclipse.pde.bnd.ui.wizards.AddFilesToRepositoryWizard;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.URLTransfer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.part.ViewPart;
import org.osgi.resource.Requirement;
import org.osgi.service.event.Event;
import org.osgi.service.repository.Repository;

public class RepositoriesView
extends ViewPart
implements RepositoriesViewRefresher.RefreshModel {
    private static final String DROP_TARGET = "dropTarget";
    private final FilterPanelPart filterPart = new FilterPanelPart(Resources.getScheduler());
    private SearchableRepositoryTreeContentProvider contentProvider;
    private TreeViewer viewer;
    private Control filterPanel;
    private GAVIPageListener dndgaviPageListener;
    private Action collapseAllAction;
    private Action refreshAction;
    private Action addBundlesAction;
    private Action advancedSearchAction;
    private Action downloadAction;
    private String advancedSearchState;
    private Action offlineAction;
    private final IEventBroker eventBroker = (IEventBroker)PlatformUI.getWorkbench().getService(IEventBroker.class);
    private final WorkspaceOfflineChangeAdapter workspaceOfflineListener = new WorkspaceOfflineChangeAdapter(){

        @Override
        public void workspaceOfflineChanged(boolean offline) {
            RepositoriesView.this.updateOfflineAction(offline);
            if (!offline) {
                RepositoriesView.this.viewer.setSelection(RepositoriesView.this.viewer.getSelection(), false);
            }
        }
    };
    private BndPreferences preferences;
    private Workspace workspace;
    private IObservableValue<String> workspaceName = new WritableValue();
    private IObservableValue<String> workspaceDescription = new WritableValue();

    public void createPartControl(final Composite parent) {
        final StackLayout stackLayout = new StackLayout();
        parent.setLayout((Layout)stackLayout);
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Composite defaultParent = toolkit.createComposite(parent, 0);
        FillLayout fill = new FillLayout();
        fill.marginHeight = 5;
        fill.marginWidth = 5;
        defaultParent.setLayout((Layout)fill);
        stackLayout.topControl = defaultParent;
        parent.layout();
        final Composite mainPanel = new Composite(parent, 0);
        this.filterPanel = this.filterPart.createControl(mainPanel, 5, 5);
        Tree tree = new Tree(mainPanel, 65538);
        this.filterPanel.setBackground(tree.getBackground());
        this.viewer = new TreeViewer(tree);
        this.dndgaviPageListener = new GAVIPageListener();
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService().addPartListener((IPartListener)this.dndgaviPageListener);
        this.contentProvider = new SearchableRepositoryTreeContentProvider(){

            @Override
            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                super.inputChanged(viewer, oldInput, newInput);
                if (newInput != null) {
                    stackLayout.topControl = mainPanel;
                    RepositoriesView.this.advancedSearchAction.setEnabled(true);
                    RepositoriesView.this.refreshAction.setEnabled(true);
                    RepositoriesView.this.collapseAllAction.setEnabled(true);
                    RepositoriesView.this.setPrefrences(RepositoriesView.this.getPreferences());
                    parent.layout();
                }
            }
        };
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        this.viewer.setLabelProvider((IBaseLabelProvider)new RepositoryTreeLabelProvider(false));
        this.getViewSite().setSelectionProvider((ISelectionProvider)this.viewer);
        RepositoriesViewRefresher.addViewer(this.viewer, this);
        this.filterPart.addPropertyChangeListener(event -> {
            String filter = (String)event.getNewValue();
            this.updatedFilter(filter);
        });
        ViewerDropAdapter dropAdapter = new ViewerDropAdapter((Viewer)this.viewer){

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                if (target == null) {
                    return false;
                }
                if (RepositoriesView.this.canDrop(target, transferType)) {
                    return true;
                }
                boolean valid = false;
                if (target instanceof RepositoryPlugin && ((RepositoryPlugin)target).canWrite()) {
                    if (URLTransfer.getInstance().isSupportedType(transferType)) {
                        return true;
                    }
                    if (LocalSelectionTransfer.getTransfer().isSupportedType(transferType)) {
                        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
                        if (selection instanceof IStructuredSelection) {
                            for (Object element : (IStructuredSelection)selection) {
                                if (element instanceof RepositoryBundle || element instanceof RepositoryBundleVersion) {
                                    valid = true;
                                } else if (element instanceof IFile) {
                                    valid = true;
                                } else {
                                    IFile file;
                                    if (!(element instanceof IAdaptable) || (file = (IFile)((IAdaptable)element).getAdapter(IFile.class)) == null) continue;
                                    valid = true;
                                }
                                break;
                            }
                        }
                    } else {
                        valid = true;
                    }
                }
                return valid;
            }

            public void dragEnter(DropTargetEvent event) {
                super.dragEnter(event);
                event.detail = 1;
            }

            public boolean performDrop(Object data) {
                File[] files;
                if (RepositoriesView.this.performDrop(this.getCurrentTarget(), this.getCurrentEvent().currentDataType, data)) {
                    RepositoriesView.this.viewer.refresh(this.getCurrentTarget(), true);
                    return true;
                }
                boolean copied = false;
                if (URLTransfer.getInstance().isSupportedType(this.getCurrentEvent().currentDataType)) {
                    try {
                        URL url = new URL((String)URLTransfer.getInstance().nativeToJava(this.getCurrentEvent().currentDataType));
                        File tmp = File.createTempFile("dwnl", ".jar");
                        Throwable throwable = null;
                        Object var6_15 = null;
                        try (HttpClient client = new HttpClient();){
                            Files.copy(client.connect(url), tmp.toPath(), new CopyOption[0]);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        if (RepositoriesView.isJarFile(tmp)) {
                            copied = RepositoriesView.this.addFilesToRepository((RepositoryPlugin)this.getCurrentTarget(), new File[]{tmp});
                        }
                        tmp.delete();
                        MessageDialog.openWarning(null, (String)"Unrecognized Artifact", (String)("The dropped URL is not recognized as a remote JAR file: " + url.toString()));
                    }
                    catch (Exception e) {
                        return false;
                    }
                } else if (data instanceof String[]) {
                    String[] paths = (String[])data;
                    File[] files2 = new File[paths.length];
                    int i = 0;
                    while (i < paths.length) {
                        files2[i] = new File(paths[i]);
                        ++i;
                    }
                    copied = RepositoriesView.this.addFilesToRepository((RepositoryPlugin)this.getCurrentTarget(), files2);
                } else if (data instanceof IResource[]) {
                    IResource[] resources = (IResource[])data;
                    File[] files3 = new File[resources.length];
                    int i = 0;
                    while (i < resources.length) {
                        files3[i] = resources[i].getLocation().toFile();
                        ++i;
                    }
                    copied = RepositoriesView.this.addFilesToRepository((RepositoryPlugin)this.getCurrentTarget(), files3);
                } else if (data instanceof IStructuredSelection && (files = RepositoriesView.convertSelectionToFiles((ISelection)((IStructuredSelection)data))) != null && files.length > 0) {
                    copied = RepositoriesView.this.addFilesToRepository((RepositoryPlugin)this.getCurrentTarget(), files);
                }
                return copied;
            }
        };
        dropAdapter.setFeedbackEnabled(false);
        dropAdapter.setExpandEnabled(false);
        this.viewer.addDropSupport(3, new Transfer[]{URLTransfer.getInstance(), FileTransfer.getInstance(), ResourceTransfer.getInstance(), LocalSelectionTransfer.getTransfer()}, (DropTargetListener)dropAdapter);
        this.viewer.addDragSupport(3, new Transfer[]{TextTransfer.getInstance(), LocalSelectionTransfer.getTransfer()}, (DragSourceListener)new SelectionDragAdapter((Viewer)this.viewer));
        this.viewer.addSelectionChangedListener(event -> {
            boolean writableRepoSelected = false;
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            Object element = selection.getFirstElement();
            if (element instanceof RepositoryPlugin) {
                RepositoryPlugin repo = (RepositoryPlugin)element;
                writableRepoSelected = repo.canWrite();
            }
            this.addBundlesAction.setEnabled(writableRepoSelected);
        });
        this.viewer.addDoubleClickListener(event -> {
            if (!event.getSelection().isEmpty()) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object element = selection.getFirstElement();
                if (element instanceof IAdaptable) {
                    URI uri = (URI)((IAdaptable)element).getAdapter(URI.class);
                    if (uri == null && element instanceof RepositoryEntry) {
                        boolean download = MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)"Repositories", (String)"This repository entry is unable to be opened because it has not been downloaded. Download and open it now?");
                        if (download) {
                            final RepositoryEntry entry = (RepositoryEntry)element;
                            Job downloadJob = new Job("Downloading repository entry " + entry.getBsn()){

                                protected IStatus run(IProgressMonitor monitor) {
                                    File repoFile = entry.getFile(true);
                                    if (repoFile != null && repoFile.exists()) {
                                        RepositoriesView.this.getSite().getShell().getDisplay().asyncExec(() -> RepositoriesView.this.openURI(repoFile.toURI()));
                                    }
                                    return Status.OK_STATUS;
                                }
                            };
                            downloadJob.setUser(true);
                            downloadJob.schedule();
                        }
                    } else if (uri != null) {
                        this.openURI(uri);
                    }
                } else if (element instanceof RepositoryPlugin) {
                    this.viewer.setExpandedState(element, !this.viewer.getExpandedState(element));
                }
            }
        });
        this.createContextMenu();
        GridLayout layout = new GridLayout(1, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        mainPanel.setLayout((Layout)layout);
        tree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.filterPanel.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createActions();
        this.fillToolBar(this.getViewSite().getActionBars().getToolBarManager());
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.refreshAction);
        this.eventBroker.subscribe(ViewEventTopics.REPOSITORIESVIEW_OPEN_ADVANCED_SEARCH.topic(), event -> this.handleOpenAdvancedSearch(event));
        ISelectionService selectionService = this.getSite().getWorkbenchWindow().getSelectionService();
        selectionService.addSelectionListener(new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                if (RepositoriesView.this.getSite().getPart() == part) {
                    return;
                }
                RepositoriesView.this.updateSelection(selection);
            }
        });
        this.updateSelection(selectionService.getSelection());
    }

    private void updateSelection(ISelection selection) {
        IProject project = this.getProject(selection);
        Workspace ws = Workspaces.getWorkspace(project).or(() -> Workspaces.getGlobalWorkspace()).orElse(null);
        if (this.workspace != ws) {
            this.workspace = ws;
            RepositoriesViewRefresher.refreshViewer(this.viewer, this);
            this.workspaceName.setValue((Object)Workspaces.getName(ws));
            this.workspaceDescription.setValue((Object)Workspaces.getDescription(ws));
        }
        BndPreferences pref = (BndPreferences)Adapters.adapt((Object)project, BndPreferences.class);
        this.setPrefrences(pref);
    }

    protected IProject getProject(ISelection selection) {
        IEditorInput editorInput;
        IEditorPart editor;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structured = (IStructuredSelection)selection;
            Object firstElement = structured.getFirstElement();
            IProject project = (IProject)Adapters.adapt((Object)firstElement, IProject.class);
            if (project != null) {
                return project;
            }
            IResource resource = (IResource)Adapters.adapt((Object)firstElement, IResource.class);
            if (resource != null) {
                return resource.getProject();
            }
            return null;
        }
        if (selection instanceof ITextSelection && (editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor()) != null && (editorInput = editor.getEditorInput()) instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)editorInput;
            return fileInput.getFile().getProject();
        }
        return null;
    }

    private void setPrefrences(BndPreferences preferences) {
        if (Objects.equals(this.preferences, preferences)) {
            return;
        }
        if (this.preferences != null) {
            this.preferences.removePropertyChangeListener(this.workspaceOfflineListener);
        }
        this.preferences = preferences;
        if (preferences == null) {
            this.offlineAction.setChecked(false);
            this.offlineAction.setToolTipText("Go Offline");
            this.offlineAction.setImageDescriptor(Resources.getImageDescriptor("connect.png"));
            this.offlineAction.setDisabledImageDescriptor(Resources.getImageDescriptor("connect_d.png"));
            this.offlineAction.setEnabled(false);
            return;
        }
        preferences.addPropertyChangeListener(this.workspaceOfflineListener);
        this.updateOfflineAction(preferences.isWorkspaceOffline());
    }

    protected void updateOfflineAction(boolean offline) {
        if (offline) {
            this.offlineAction.setChecked(true);
            this.offlineAction.setToolTipText("Go Online");
            this.offlineAction.setImageDescriptor(Resources.getImageDescriptor("disconnect.png"));
            this.offlineAction.setDisabledImageDescriptor(Resources.getImageDescriptor("disconnect_d.png"));
        } else {
            this.offlineAction.setChecked(false);
            this.offlineAction.setToolTipText("Go Offline");
            this.offlineAction.setImageDescriptor(Resources.getImageDescriptor("connect.png"));
            this.offlineAction.setDisabledImageDescriptor(Resources.getImageDescriptor("connect_d.png"));
        }
        this.offlineAction.setEnabled(true);
    }

    protected void openURI(URI uri) {
        IWorkbenchPage page = this.getSite().getPage();
        try {
            IFileStore fileStore = EFS.getLocalFileSystem().getStore(uri);
            IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
        }
        catch (PartInitException e) {
            ILog.get().error("Error opening editor for " + String.valueOf(uri), (Throwable)e);
        }
    }

    public void setFocus() {
        this.filterPart.setFocus();
    }

    private static File[] convertSelectionToFiles(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return new File[0];
        }
        IStructuredSelection structSel = (IStructuredSelection)selection;
        ArrayList<File> files = new ArrayList<File>(structSel.size());
        for (Object element : structSel) {
            if (element instanceof IFile) {
                files.add(((IFile)element).getLocation().toFile());
                continue;
            }
            if (!(element instanceof IAdaptable)) continue;
            IAdaptable adaptable = (IAdaptable)element;
            IFile ifile = (IFile)adaptable.getAdapter(IFile.class);
            if (ifile != null) {
                files.add(ifile.getLocation().toFile());
                continue;
            }
            File file = (File)adaptable.getAdapter(File.class);
            if (file == null) continue;
            files.add(file);
        }
        return files.toArray(new File[0]);
    }

    public void dispose() {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService().removePartListener((IPartListener)this.dndgaviPageListener);
        RepositoriesViewRefresher.removeViewer(this.viewer);
        BndPreferences preferences = this.getPreferences();
        if (preferences != null) {
            preferences.removePropertyChangeListener(this.workspaceOfflineListener);
        }
        super.dispose();
    }

    boolean addFilesToRepository(RepositoryPlugin repo, File[] files) {
        AddFilesToRepositoryWizard wizard = new AddFilesToRepositoryWizard(this.getWorkspace(), repo, files);
        WizardDialog dialog = new WizardDialog(this.getViewSite().getShell(), (IWizard)wizard);
        dialog.open();
        this.viewer.refresh((Object)repo);
        return true;
    }

    private void updatedFilter(String filterString) {
        this.contentProvider.setFilter(filterString);
        this.viewer.refresh();
        if (filterString != null) {
            this.viewer.expandToLevel(2);
        }
    }

    void createActions() {
        this.collapseAllAction = new Action(){

            public void run() {
                RepositoriesView.this.viewer.collapseAll();
            }
        };
        this.collapseAllAction.setEnabled(false);
        this.collapseAllAction.setText("Collapse All");
        this.collapseAllAction.setToolTipText("Collapse All");
        this.collapseAllAction.setImageDescriptor(Resources.getImageDescriptor("collapseall.png"));
        this.collapseAllAction.setDisabledImageDescriptor(Resources.getImageDescriptor("collapseall_d.png"));
        this.refreshAction = new Action(){

            public void run() {
                new WorkspaceJob("Refresh repositories"){

                    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                        if (monitor == null) {
                            monitor = new NullProgressMonitor();
                        }
                        monitor.subTask("Refresh all repositories");
                        try {
                            try {
                                (this).RepositoriesView.this.refreshAction.setEnabled(false);
                                Central.refreshPlugins(RepositoriesView.this.getWorkspace());
                            }
                            catch (Exception e) {
                                Throwable t = Exceptions.unrollCause((Throwable)e, InvocationTargetException.class);
                                ILog.get().error("Unexpected error in refreshing plugns", t);
                                IStatus iStatus = Status.error((String)"Failed to refresh plugins", (Throwable)t);
                                (this).RepositoriesView.this.refreshAction.setEnabled(true);
                                return iStatus;
                            }
                        }
                        finally {
                            (this).RepositoriesView.this.refreshAction.setEnabled(true);
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        };
        this.refreshAction.setEnabled(false);
        this.refreshAction.setText("Refresh");
        this.refreshAction.setToolTipText("Refresh Repositories Tree");
        this.refreshAction.setImageDescriptor(Resources.getImageDescriptor("arrow_refresh.png"));
        this.refreshAction.setDisabledImageDescriptor(Resources.getImageDescriptor("arrow_refresh_d.png"));
        this.addBundlesAction = new Action(){

            public void run() {
                RepositoryPlugin repo;
                IStructuredSelection selection = (IStructuredSelection)RepositoriesView.this.viewer.getSelection();
                Object element = selection.getFirstElement();
                if (element != null && element instanceof RepositoryPlugin && (repo = (RepositoryPlugin)element).canWrite()) {
                    AddFilesToRepositoryWizard wizard = new AddFilesToRepositoryWizard(RepositoriesView.this.getWorkspace(), repo, new File[0]);
                    WizardDialog dialog = new WizardDialog(RepositoriesView.this.getViewSite().getShell(), (IWizard)wizard);
                    dialog.open();
                    RepositoriesView.this.viewer.refresh((Object)repo);
                }
            }
        };
        this.addBundlesAction.setEnabled(false);
        this.addBundlesAction.setText("Add");
        this.addBundlesAction.setToolTipText("Add Bundles to Repository");
        this.addBundlesAction.setImageDescriptor(Resources.getImageDescriptor("add_obj.png"));
        this.addBundlesAction.setDisabledImageDescriptor(Resources.getImageDescriptor("add_obj_d.png"));
        this.advancedSearchAction = new Action("Advanced Search", 2){

            public void run() {
                if (RepositoriesView.this.advancedSearchAction.isChecked()) {
                    XMLMemento memento;
                    AdvancedSearchDialog dialog = new AdvancedSearchDialog(RepositoriesView.this.getSite().getShell());
                    if (RepositoriesView.this.advancedSearchState != null) {
                        try {
                            memento = XMLMemento.createReadRoot((Reader)new StringReader(RepositoriesView.this.advancedSearchState));
                            dialog.restoreState((IMemento)memento);
                        }
                        catch (Exception e) {
                            ILog.get().error("Failed to load dialog state", (Throwable)e);
                        }
                    }
                    if (dialog.open() == 0) {
                        Requirement req = dialog.getRequirement();
                        RepositoriesView.this.contentProvider.setRequirementFilter(req);
                        SWTUtil.recurseEnable(false, RepositoriesView.this.filterPanel);
                        RepositoriesView.this.viewer.refresh();
                        RepositoriesView.this.viewer.expandToLevel(2);
                    } else {
                        RepositoriesView.this.advancedSearchAction.setChecked(false);
                    }
                    try {
                        memento = XMLMemento.createWriteRoot((String)"search");
                        dialog.saveState((IMemento)memento);
                        CharArrayWriter writer = new CharArrayWriter();
                        memento.save((Writer)writer);
                        RepositoriesView.this.advancedSearchState = writer.toString();
                    }
                    catch (Exception e) {
                        ILog.get().error("Failed to save dialog state", (Throwable)e);
                    }
                } else {
                    RepositoriesView.this.contentProvider.setRequirementFilter(null);
                    SWTUtil.recurseEnable(true, RepositoriesView.this.filterPanel);
                    RepositoriesView.this.viewer.refresh();
                }
            }
        };
        this.advancedSearchAction.setEnabled(false);
        this.advancedSearchAction.setText("Advanced Search");
        this.advancedSearchAction.setToolTipText("Toggle Advanced Search");
        this.advancedSearchAction.setImageDescriptor(Resources.getImageDescriptor("search.png"));
        this.advancedSearchAction.setDisabledImageDescriptor(Resources.getImageDescriptor("search_d.png"));
        this.downloadAction = new Action(){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)RepositoriesView.this.viewer.getSelection();
                Set<RemoteRepositoryPlugin> repos = Collections.newSetFromMap(new IdentityHashMap());
                repos.addAll(this.selectionByType(selection, RemoteRepositoryPlugin.class));
                Set<RepositoryBundle> bundles = Collections.newSetFromMap(new IdentityHashMap());
                for (RepositoryBundle bundle : this.selectionByType(selection, RepositoryBundle.class)) {
                    if (repos.contains(bundle.getRepo())) continue;
                    bundles.add(bundle);
                }
                Set<RepositoryBundleVersion> bundleVersions = Collections.newSetFromMap(new IdentityHashMap());
                for (RepositoryBundleVersion bundleVersion : this.selectionByType(selection, RepositoryBundleVersion.class)) {
                    if (repos.contains(bundleVersion.getRepo())) continue;
                    bundleVersions.add(bundleVersion);
                }
                RepoDownloadJob downloadJob = new RepoDownloadJob(repos, bundles, bundleVersions);
                downloadJob.schedule();
            }

            private <T> List<T> selectionByType(IStructuredSelection selection, Class<T> type) {
                ArrayList result = new ArrayList(selection.size());
                for (Object item : selection) {
                    if (!type.isInstance(item)) continue;
                    Object cast = item;
                    result.add(cast);
                }
                return result;
            }
        };
        this.downloadAction.setEnabled(false);
        this.downloadAction.setText("Download Repository Content");
        this.downloadAction.setImageDescriptor(Resources.getImageDescriptor("download.png"));
        this.downloadAction.setDisabledImageDescriptor(Resources.getImageDescriptor("download_d.png"));
        this.offlineAction = new Action("Online/Offline Mode", 2){

            public void run() {
                BndPreferences preferences = RepositoriesView.this.getPreferences();
                if (preferences != null) {
                    preferences.setWorkspaceOffline(RepositoriesView.this.offlineAction.isChecked());
                }
            }
        };
        this.offlineAction.setEnabled(false);
        this.offlineAction.setToolTipText("Go Offline");
        this.offlineAction.setImageDescriptor(Resources.getImageDescriptor("connect.png"));
        this.offlineAction.setDisabledImageDescriptor(Resources.getImageDescriptor("connect_d.png"));
        this.viewer.addSelectionChangedListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            boolean enable = false;
            List list = selection.toList();
            for (Object item : list) {
                if (item instanceof RemoteRepositoryPlugin) {
                    enable = true;
                    break;
                }
                if (!(item instanceof RepositoryEntry) || ((RepositoryEntry)item).isLocal()) continue;
                enable = true;
                break;
            }
            this.downloadAction.setEnabled(enable);
        });
    }

    void createContextMenu() {
        MenuManager mgr = new MenuManager();
        Menu menu = mgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        mgr.add((IContributionItem)new GroupMarker("additions"));
        this.getSite().registerContextMenu(mgr, (ISelectionProvider)this.viewer);
        mgr.addMenuListener(manager -> {
            try {
                Object firstElement;
                manager.removeAll();
                IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
                if (!selection.isEmpty() && (firstElement = selection.getFirstElement()) instanceof Actionable) {
                    RepositoryPlugin rp = this.getRepositoryPlugin(firstElement);
                    Actionable act = (Actionable)firstElement;
                    HierarchicalMenu hmenu = new HierarchicalMenu();
                    this.addCopyToClipboardSubMenueEntries(act, rp, hmenu);
                    Map actions = act.actions(new Object[0]);
                    if (actions != null) {
                        for (Map.Entry e1 : actions.entrySet()) {
                            String label = (String)e1.getKey();
                            hmenu.add(new HierarchicalLabel<Action>(label.replace("&", "&&"), l -> this.createAction(l.getLeaf(), l.getDescription(), l.isEnabled(), l.isChecked(), rp, (Runnable)e1.getValue())));
                        }
                    }
                    hmenu.build(manager);
                }
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        });
    }

    private void fillToolBar(final IToolBarManager toolBar) {
        toolBar.add((IContributionItem)new ControlContribution("label"){

            protected Control createControl(Composite parent) {
                Composite composite = new Composite(parent, 0);
                composite.setLayout((Layout)new FillLayout());
                CLabel label = new CLabel(composite, 0x1000000);
                IChangeListener labelListener = e -> {
                    String newText;
                    String text = label.getText();
                    if (Objects.equals(text, newText = this.getLabelText())) {
                        return;
                    }
                    label.setText(newText);
                    label.setToolTipText((String)RepositoriesView.this.workspaceDescription.getValue());
                    toolBar.update(true);
                };
                IChangeListener tooltipListener = e -> {
                    String newText;
                    String text = label.getToolTipText();
                    if (Objects.equals(text, newText = (String)RepositoriesView.this.workspaceDescription.getValue())) {
                        return;
                    }
                    label.setToolTipText(newText);
                };
                label.addDisposeListener(e -> {
                    RepositoriesView.this.workspaceDescription.removeChangeListener(tooltipListener);
                    RepositoriesView.this.workspaceName.removeChangeListener(labelListener);
                });
                RepositoriesView.this.workspaceName.addChangeListener(labelListener);
                RepositoriesView.this.workspaceDescription.addChangeListener(tooltipListener);
                label.setText(this.getLabelText());
                label.setToolTipText((String)RepositoriesView.this.workspaceDescription.getValue());
                return composite;
            }

            private String getLabelText() {
                return Objects.requireNonNullElse((String)RepositoriesView.this.workspaceName.getValue(), "");
            }
        });
        toolBar.add((IAction)this.advancedSearchAction);
        toolBar.add((IAction)this.downloadAction);
        toolBar.add((IContributionItem)new Separator());
        toolBar.add((IAction)this.refreshAction);
        toolBar.add((IAction)this.collapseAllAction);
        toolBar.add((IAction)this.addBundlesAction);
        toolBar.add((IContributionItem)new Separator());
        toolBar.add((IAction)this.offlineAction);
        toolBar.add((IContributionItem)new Separator());
        toolBar.add((IAction)HelpButtons.HELP_BTN_REPOSITORIES);
        toolBar.add((IContributionItem)new Separator());
    }

    boolean canDrop(Object target, TransferData data) {
        try {
            Class<?> type = this.toJavaType(data);
            if (type != null) {
                target.getClass().getMethod(DROP_TARGET, type);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean performDrop(Object target, TransferData data, Object dropped) {
        try {
            Object java = this.toJava(data);
            if (java == null && (java = this.toJava(dropped)) == null) {
                return false;
            }
            try {
                Method m = target.getClass().getMethod(DROP_TARGET, java.getClass());
                Boolean invoke = (Boolean)m.invoke(target, java);
                if (!invoke.booleanValue()) {
                    return false;
                }
            }
            catch (NoSuchMethodException e) {
                return false;
            }
            RepositoryPlugin repositoryPlugin = this.getRepositoryPlugin(target);
            if (repositoryPlugin != null && repositoryPlugin instanceof Refreshable) {
                Central.refreshPlugin(this.getWorkspace(), (Refreshable)repositoryPlugin);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private Object toJava(Object dropped) {
        File file;
        IResource resource;
        IPath path;
        Object firstElement;
        IStructuredSelection selection;
        if (dropped instanceof IStructuredSelection && !(selection = (IStructuredSelection)dropped).isEmpty() && (firstElement = selection.getFirstElement()) instanceof IResource && (path = (resource = (IResource)firstElement).getRawLocation()) != null && (file = path.toFile()) != null) {
            return file;
        }
        return null;
    }

    Class<?> toJavaType(TransferData data) throws Exception {
        if (URLTransfer.getInstance().isSupportedType(data)) {
            return URI.class;
        }
        if (FileTransfer.getInstance().isSupportedType(data)) {
            return File[].class;
        }
        if (TextTransfer.getInstance().isSupportedType(data)) {
            return String.class;
        }
        if (ResourceTransfer.getInstance().isSupportedType(data)) {
            return String.class;
        }
        if (LocalSelectionTransfer.getTransfer().isSupportedType(data)) {
            Object firstElement;
            ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
            if (selection instanceof IStructuredSelection && (firstElement = ((IStructuredSelection)selection).getFirstElement()) instanceof IFile) {
                return File.class;
            }
            return null;
        }
        return null;
    }

    Object toJava(TransferData data) throws Exception {
        Object firstElement;
        ISelection selection;
        LocalSelectionTransfer local = LocalSelectionTransfer.getTransfer();
        if (local.isSupportedType(data) && (selection = LocalSelectionTransfer.getTransfer().getSelection()) instanceof IStructuredSelection && (firstElement = ((IStructuredSelection)selection).getFirstElement()) instanceof IFile) {
            IFile f = (IFile)firstElement;
            return f.getLocationURI();
        }
        if (URLTransfer.getInstance().isSupportedType(data)) {
            Object nativeUrl = URLTransfer.getInstance().nativeToJava(data);
            if (nativeUrl instanceof String) {
                String s = (String)nativeUrl;
                return new URI(s);
            }
        } else if (FileTransfer.getInstance().isSupportedType(data)) {
            Object nativeFiles = FileTransfer.getInstance().nativeToJava(data);
            if (nativeFiles instanceof String[]) {
                String[] str = (String[])nativeFiles;
                return Arrays.stream(str).map(File::new).toArray(File[]::new);
            }
        } else if (TextTransfer.getInstance().isSupportedType(data)) {
            return TextTransfer.getInstance().nativeToJava(data);
        }
        return null;
    }

    private RepositoryPlugin getRepositoryPlugin(Object element) {
        if (element instanceof RepositoryPlugin) {
            return (RepositoryPlugin)element;
        }
        if (element instanceof RepositoryBundle) {
            return ((RepositoryBundle)element).getRepo();
        }
        if (element instanceof RepositoryBundleVersion) {
            return ((RepositoryBundleVersion)element).getParentBundle().getRepo();
        }
        return null;
    }

    @Override
    public List<RepositoryPlugin> getRepositories() {
        return RepositoryUtils.listRepositories(this.getWorkspace(), true);
    }

    private static boolean isJarFile(File candidate) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (JarFile jar = new JarFile(candidate);){
                boolean bl = jar.getManifest() != null;
                return bl;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            return false;
        }
    }

    private Action createAction(String label, String description, boolean enabled, boolean checked, final RepositoryPlugin rp, final Runnable r) {
        Action a = new Action(label){

            public void run() {
                Job backgroundJob = new Job("Repository Action '" + this.getText() + "'"){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            r.run();
                            if (rp != null && rp instanceof Refreshable) {
                                Central.refreshPlugin(RepositoriesView.this.getWorkspace(), (Refreshable)rp, true);
                            }
                        }
                        catch (Exception e) {
                            ILog.get().error("Error executing: " + this.getName(), (Throwable)e);
                        }
                        monitor.done();
                        return Status.OK_STATUS;
                    }
                };
                backgroundJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        if (event.getResult().isOK()) {
                            (this).RepositoriesView.this.viewer.getTree().getDisplay().asyncExec(() -> (this).RepositoriesView.this.viewer.refresh());
                        }
                    }
                });
                backgroundJob.setUser(true);
                backgroundJob.setPriority(20);
                backgroundJob.schedule();
            }
        };
        a.setEnabled(enabled);
        if (description != null) {
            a.setDescription(description);
        }
        a.setChecked(checked);
        return a;
    }

    private void addCopyToClipboardSubMenueEntries(Actionable act, RepositoryPlugin rp, HierarchicalMenu hmenu) {
        Workspace registry = this.getWorkspace();
        if (registry == null) {
            return;
        }
        Clipboard clipboard = (Clipboard)registry.getPlugin(Clipboard.class);
        if (clipboard == null) {
            return;
        }
        if (act instanceof RepositoryBundleVersion) {
            RepositoryBundleVersion rbr = (RepositoryBundleVersion)act;
            hmenu.add(this.createContextMenueBsn(rp, clipboard, rbr));
            hmenu.add(this.createContextMenueCopyInfoRepoBundleVersion(act, rp, clipboard, rbr));
        }
        if (act instanceof RepositoryBundle) {
            RepositoryBundle rb = (RepositoryBundle)act;
            hmenu.add(this.createContextMenueCopyInfoRepoBundle(act, rp, clipboard, rb));
        }
        if (act instanceof Repository || act instanceof RepositoryPlugin) {
            hmenu.add(this.createContextMenueCopyInfoRepo(act, rp, clipboard));
        }
    }

    private HierarchicalLabel<Action> createContextMenueCopyInfoRepo(Actionable act, RepositoryPlugin rp, Clipboard clipboard) {
        return new HierarchicalLabel<Action>("Copy to clipboard :: Copy info", label -> this.createAction(label.getLeaf(), "Add general info about this entry to clipboard.", true, false, rp, () -> {
            StringBuilder info = new StringBuilder();
            try {
                String tooltipContent = act.tooltip(new Object[0]);
                if (tooltipContent != null && !tooltipContent.isBlank()) {
                    info.append(tooltipContent);
                    clipboard.copy((Object)info.toString());
                }
            }
            catch (Exception e) {
                throw Exceptions.duck((Throwable)e);
            }
        }));
    }

    private HierarchicalLabel<Action> createContextMenueCopyInfoRepoBundle(Actionable act, RepositoryPlugin rp, Clipboard clipboard, RepositoryBundle rb) {
        return new HierarchicalLabel<Action>("Copy to clipboard :: Copy info", label -> this.createAction(label.getLeaf(), "Add general info about this entry to clipboard.", true, false, rp, () -> {
            StringBuilder info = new StringBuilder();
            try {
                String tooltipContent = act.tooltip(new Object[]{rb.getBsn()});
                if (tooltipContent != null && !tooltipContent.isBlank()) {
                    info.append(tooltipContent);
                    clipboard.copy((Object)info.toString());
                } else {
                    info.append(rb.toString());
                    clipboard.copy((Object)info.toString());
                }
            }
            catch (Exception e) {
                throw Exceptions.duck((Throwable)e);
            }
        }));
    }

    private HierarchicalLabel<Action> createContextMenueCopyInfoRepoBundleVersion(Actionable act, RepositoryPlugin rp, Clipboard clipboard, RepositoryBundleVersion rbr) {
        return new HierarchicalLabel<Action>("Copy to clipboard :: Copy info", label -> this.createAction(label.getLeaf(), "Add general info about this entry to clipboard.", true, false, rp, () -> {
            StringBuilder info = new StringBuilder();
            try {
                String tooltipContent = act.tooltip(new Object[]{rbr.getBsn(), rbr.getVersion().toString()});
                if (tooltipContent != null && !tooltipContent.isBlank()) {
                    info.append(tooltipContent);
                }
            }
            catch (Exception e) {
                throw Exceptions.duck((Throwable)e);
            }
            if (!info.isEmpty()) {
                info.append('\n');
            }
            info.append(rbr.toString());
            clipboard.copy((Object)info.toString());
        }));
    }

    private HierarchicalLabel<Action> createContextMenueBsn(RepositoryPlugin rp, Clipboard clipboard, RepositoryBundleVersion rbr) {
        return new HierarchicalLabel<Action>("Copy to clipboard :: Copy bsn+version", label -> this.createAction(label.getLeaf(), "Copy bsn;version=version to clipboard.", true, false, rp, () -> {
            String rev = rbr.getBsn() + ";version=" + rbr.getVersion().toString();
            clipboard.copy((Object)rev);
        }));
    }

    private void handleOpenAdvancedSearch(Event event) {
        if (event == null) {
            return;
        }
        Object object = event.getProperty("org.eclipse.e4.data");
        if (object instanceof Requirement) {
            Requirement req = (Requirement)object;
            this.advancedSearchState = AdvancedSearchDialog.toNamespaceSearchPanelMemento(req).toString();
            this.advancedSearchAction.setChecked(true);
            this.advancedSearchAction.run();
        }
    }

    @Override
    public Workspace getWorkspace() {
        return this.workspace;
    }

    private BndPreferences getPreferences() {
        return this.preferences;
    }
}

