/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.utility.filename;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.eclipse.birt.report.utility.filename.IFilenameGenerator;

public class TimestampFilenameGenerator
implements IFilenameGenerator {
    private static final String DEFAULT_DATE_PATTERN = "yyyyMMdd-HHmmss";
    public String datePattern;

    public TimestampFilenameGenerator() {
        this(null);
    }

    public TimestampFilenameGenerator(String datePattern) {
        if (datePattern == null) {
            datePattern = DEFAULT_DATE_PATTERN;
        }
        this.datePattern = datePattern;
    }

    @Override
    public String getFilename(String baseName, String fileExtension, String outputType, Map options) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(this.datePattern);
        if (fileExtension == null) {
            fileExtension = "";
        }
        return baseName + "_" + dateFormatter.format(new Date()) + "." + fileExtension;
    }
}

