/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.doc.romdoc;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.birt.doc.romdoc.DocChoice;
import org.eclipse.birt.doc.romdoc.DocElement;
import org.eclipse.birt.doc.romdoc.DocObject;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefn;

public class DocProperty
extends DocObject {
    PropertyDefn defn;
    HashMap<String, String> notes = null;
    ArrayList<DocChoice> choices = null;

    public DocProperty(PropertyDefn propDefn) {
        this.defn = propDefn;
        IChoiceSet choiceSet = this.defn.getChoices();
        if (choiceSet == null) {
            return;
        }
        this.choices = new ArrayList();
        IChoice[] set = choiceSet.getChoices();
        int i = 0;
        while (i < set.length) {
            this.choices.add(new DocChoice(set[i]));
            ++i;
        }
    }

    @Override
    public String getName() {
        return this.defn.getName();
    }

    public String getType() {
        Object type = this.defn.getTypeCode() == 16 ? this.makeStructureLink(this.defn.getStructDefn(), "element") + " Structure" : (this.defn.getTypeCode() == 15 ? this.makeElementLink(this.defn.getTargetElementType().getName(), "element") + " Reference" : (this.defn.getTypeCode() == 5 ? this.makeTypeLink(this.defn.getType(), "element") + " (" + this.defn.getChoices().getName() + ")" : this.makeTypeLink(this.defn.getType(), "element")));
        if (this.defn.isList()) {
            type = "List of " + (String)type + "s";
        }
        return type;
    }

    public String getSince() {
        if (this.defn.getName().equals("style")) {
            return "1.0";
        }
        return this.defn.getSince();
    }

    public String getRequired() {
        return this.yesNo(this.defn.isValueRequired());
    }

    public String getDisplayName() {
        return this.defn.getDisplayName();
    }

    public String getJSType() {
        return null;
    }

    public String getDefaultValue() {
        String note = this.getNote("Default value");
        if (note != null) {
            return note;
        }
        Object value = this.defn.getDefault();
        if (value != null) {
            return value.toString();
        }
        return "None";
    }

    public String getInherited() {
        return this.yesNo(((ElementPropertyDefn)this.defn).canInherit());
    }

    public String getRuntimeSettable() {
        return this.yesNo(this.defn.isRuntimeSettable());
    }

    public boolean hasChoices() {
        return this.defn.getChoices() != null;
    }

    public String getVisibility(DocElement element) {
        if (element.getElementDefn().isPropertyReadOnly(this.defn.getName())) {
            return "Read-only";
        }
        if (element.getElementDefn().isPropertyVisible(this.defn.getName())) {
            return "Visible";
        }
        return "Hidden";
    }

    public String getGroup() {
        String group = ((ElementPropertyDefn)this.defn).getGroupName();
        if (group == null) {
            return "Top";
        }
        return group;
    }

    public void addNote(String key, String note) {
        if (this.notes == null) {
            this.notes = new HashMap();
        }
        this.notes.put(key.toLowerCase(), note);
    }

    public String getNote(String key) {
        if (this.notes == null) {
            return null;
        }
        return this.notes.get(key.toLowerCase());
    }

    public DocChoice findChoice(String name) {
        if (this.choices == null) {
            return null;
        }
        int i = 0;
        while (i < this.choices.size()) {
            DocChoice choice = this.choices.get(i);
            if (choice.getName().equals(name)) {
                return choice;
            }
            ++i;
        }
        return null;
    }

    public AbstractList<DocChoice> getChoices() {
        return this.choices;
    }

    public boolean isExpression() {
        return this.defn.getTypeCode() == 7;
    }

    public String getContext() {
        return this.defn.getContext();
    }

    public String getReturnType() {
        if (this.defn.getReturnType() == null) {
            return "None";
        }
        return this.defn.getReturnType();
    }
}

