/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.plugin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModelFactory;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ISharedPluginModel;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.build.Build;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.bundle.BundlePluginBase;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.natures.PDE;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModelBase;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.search.dependencies.AddNewBinaryDependenciesOperation;
import org.eclipse.pde.internal.ui.wizards.IProjectProvider;
import org.eclipse.pde.internal.ui.wizards.plugin.LibraryPluginFieldData;
import org.eclipse.pde.internal.ui.wizards.plugin.NewProjectCreationOperation;
import org.eclipse.pde.ui.IFieldData;
import org.eclipse.pde.ui.IPluginContentWizard;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.ui.wizards.datatransfer.ZipFileStructureProvider;
import org.osgi.framework.BundleException;

public class NewLibraryPluginCreationOperation
extends NewProjectCreationOperation {
    private static final String SOURCE_PREFIX = "source.";
    private final LibraryPluginFieldData fData;

    public NewLibraryPluginCreationOperation(LibraryPluginFieldData data, IProjectProvider provider, IPluginContentWizard contentWizard) {
        super(data, provider, contentWizard);
        this.fData = data;
    }

    private void addJar(File jarFile, IProject project, IProgressMonitor monitor) throws CoreException {
        String jarName = jarFile.getName();
        IFile file = project.getFile(jarName);
        monitor.subTask(NLS.bind((String)PDEUIMessages.NewProjectCreationOperation_copyingJar, (Object)jarName));
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (FileInputStream in = new FileInputStream(jarFile);){
                file.create((InputStream)in, true, monitor);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void adjustExportRoot(IProject project, IBundle bundle) throws CoreException {
        IResource[] resources;
        IResource[] iResourceArray = resources = project.members(false);
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (!(!(resource instanceof IFile) || ".project".equals(resource.getName()) || ".classpath".equals(resource.getName()) || "plugin.xml".equals(resource.getName()) || "build.properties".equals(resource.getName()))) {
                return;
            }
            ++n2;
        }
        this.removeExportRoot(bundle);
    }

    @Override
    protected void adjustManifests(IProgressMonitor monitor, IProject project, IPluginBase base) throws CoreException {
        IBundle bundle;
        super.adjustManifests(monitor, project, base);
        int units = this.fData.doFindDependencies() ? 4 : 2;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(units += this.fData.isUpdateReferences() ? 1 : 0));
        IBundle iBundle = bundle = base instanceof BundlePluginBase ? ((BundlePluginBase)base).getBundle() : null;
        if (bundle != null) {
            this.adjustExportRoot(project, bundle);
            subMonitor.worked(1);
            this.addExportedPackages(project, bundle);
            subMonitor.worked(1);
            if (this.fData.doFindDependencies()) {
                this.addDependencies(project, base.getModel(), (IProgressMonitor)subMonitor.split(2));
            }
            if (this.fData.isUpdateReferences()) {
                this.updateReferences((IProgressMonitor)subMonitor.split(1), project);
            }
        }
    }

    protected void updateReferences(IProgressMonitor monitor, IProject project) throws JavaModelException {
        IJavaProject currentProject = JavaCore.create((IProject)project);
        IPluginModelBase[] pluginstoUpdate = this.fData.getPluginsToUpdate();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)pluginstoUpdate.length);
        IPluginModelBase[] iPluginModelBaseArray = pluginstoUpdate;
        int n = pluginstoUpdate.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase element = iPluginModelBaseArray[n2];
            SubMonitor iterationMonitor = subMonitor.split(1).setWorkRemaining(2);
            IProject proj = element.getUnderlyingResource().getProject();
            if (!currentProject.getProject().equals((Object)proj)) {
                IJavaProject javaProject = JavaCore.create((IProject)proj);
                IClasspathEntry[] cp = javaProject.getRawClasspath();
                IClasspathEntry[] updated = this.getUpdatedClasspath(cp, currentProject);
                if (updated != null) {
                    javaProject.setRawClasspath(updated, (IProgressMonitor)iterationMonitor.split(1));
                }
                iterationMonitor.setWorkRemaining(1);
                try {
                    NewLibraryPluginCreationOperation.updateRequiredPlugins(javaProject, (IProgressMonitor)iterationMonitor.split(1), element);
                }
                catch (CoreException e) {
                    PDEPlugin.log(e);
                }
            }
            ++n2;
        }
    }

    private static void updateRequiredPlugins(IJavaProject javaProject, IProgressMonitor monitor, IPluginModelBase model) throws CoreException {
        IClasspathEntry[] entries = javaProject.getRawClasspath();
        ArrayList<IClasspathEntry> classpath = new ArrayList<IClasspathEntry>();
        ArrayList<IClasspathEntry> requiredProjects = new ArrayList<IClasspathEntry>();
        IClasspathEntry[] iClasspathEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (NewLibraryPluginCreationOperation.isPluginProjectEntry(entry)) {
                requiredProjects.add(entry);
            } else {
                classpath.add(entry);
            }
            ++n2;
        }
        if (requiredProjects.isEmpty()) {
            return;
        }
        IFile file = PDEProject.getManifest((IProject)javaProject.getProject());
        try {
            StringBuilder sb;
            Manifest manifest = new Manifest(file.getContents());
            String value = manifest.getMainAttributes().getValue("Require-Bundle");
            StringBuilder stringBuilder = sb = value != null ? new StringBuilder(value) : new StringBuilder();
            if (sb.length() > 0) {
                sb.append(",");
            }
            int i = 0;
            while (i < requiredProjects.size()) {
                IClasspathEntry entry = (IClasspathEntry)requiredProjects.get(i);
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(entry.getPath().segment(0));
                if (entry.isExported()) {
                    sb.append(";visibility:=reexport");
                }
                ++i;
            }
            manifest.getMainAttributes().putValue("Require-Bundle", sb.toString());
            ByteArrayOutputStream content = new ByteArrayOutputStream();
            manifest.write(content);
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
            file.setContents((InputStream)new ByteArrayInputStream(content.toByteArray()), true, false, (IProgressMonitor)subMonitor.split(1));
            javaProject.setRawClasspath(classpath.toArray(new IClasspathEntry[classpath.size()]), (IProgressMonitor)subMonitor.split(1));
        }
        catch (IOException | CoreException throwable) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isPluginProjectEntry(IClasspathEntry entry) {
        if (2 != entry.getEntryKind()) {
            return false;
        }
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject other = workspaceRoot.getProject(entry.getPath().segment(0));
        if (!PDE.hasPluginNature((IProject)other)) {
            return false;
        }
        if (PDEProject.getFragmentXml((IProject)other).exists()) {
            return false;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream is = PDEProject.getManifest((IProject)other).getContents();){
                Manifest mf = new Manifest(is);
                if (mf.getMainAttributes().getValue("Fragment-Host") == null) return true;
                return false;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException | CoreException throwable) {
            // empty catch block
        }
        return true;
    }

    private IClasspathEntry[] getUpdatedClasspath(IClasspathEntry[] cp, IJavaProject currentProject) {
        boolean exposed = false;
        int refIndex = -1;
        ArrayList<IClasspathEntry> result = new ArrayList<IClasspathEntry>();
        HashSet<Manifest> manifests = new HashSet<Manifest>();
        int i = 0;
        while (i < this.fData.getLibraryPaths().length) {
            try {
                Throwable throwable = null;
                Object var9_12 = null;
                try (JarFile jarFile = new JarFile(this.fData.getLibraryPaths()[i]);){
                    manifests.add(jarFile.getManifest());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                PDEPlugin.log(e);
            }
            ++i;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IClasspathEntry[] iClasspathEntryArray = cp;
        int n = cp.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry cpe = iClasspathEntryArray[n2];
            switch (cpe.getEntryKind()) {
                case 1: {
                    String path = null;
                    IPath location = root.getFile(cpe.getPath()).getLocation();
                    if (location != null) {
                        path = location.toString();
                    }
                    if (path == null) {
                        path = cpe.getPath().toString();
                    }
                    try {
                        Throwable throwable = null;
                        Object var15_23 = null;
                        try (JarFile jarFile = new JarFile(path);){
                            if (manifests.contains(jarFile.getManifest())) {
                                if (refIndex < 0) {
                                    refIndex = result.size();
                                    result.add(null);
                                }
                                exposed |= cpe.isExported();
                                break;
                            }
                            result.add(cpe);
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        PDEPlugin.log(e);
                    }
                    break;
                }
                default: {
                    result.add(cpe);
                }
            }
            ++n2;
        }
        if (refIndex >= 0) {
            result.set(refIndex, JavaCore.newProjectEntry((IPath)currentProject.getPath(), (boolean)exposed));
            return result.toArray(new IClasspathEntry[result.size()]);
        }
        return null;
    }

    @Override
    protected void createContents(IProgressMonitor monitor, IProject project) throws CoreException, JavaModelException, InvocationTargetException, InterruptedException {
        String[] paths = this.fData.getLibraryPaths();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(paths.length + 2));
        int i = paths.length - 1;
        while (i >= 0) {
            File jarFile = new File(paths[i]);
            if (this.fData.isUnzipLibraries()) {
                this.importJar(jarFile, (IResource)project, (IProgressMonitor)subMonitor.split(1));
            } else {
                this.addJar(jarFile, project, (IProgressMonitor)subMonitor);
            }
            --i;
        }
        IFile importedManifest = PDEProject.getManifest((IProject)project);
        if (importedManifest.exists()) {
            IFolder meta_inf;
            importedManifest.delete(true, false, (IProgressMonitor)subMonitor.split(1));
            subMonitor.setWorkRemaining(1);
            if (!this.fData.hasBundleStructure() && (meta_inf = project.getFolder("META-INF")).members().length == 0) {
                meta_inf.delete(true, false, (IProgressMonitor)subMonitor.split(1));
            }
        }
        subMonitor.setWorkRemaining(0);
    }

    @Override
    protected void fillBinIncludes(IProject project, IBuildEntry binEntry) throws CoreException {
        if (this.fData.hasBundleStructure()) {
            binEntry.addToken("META-INF/");
        } else {
            binEntry.addToken("plugin.xml");
        }
        if (this.fData.isUnzipLibraries()) {
            IResource[] resources;
            IResource[] iResourceArray = resources = project.members(false);
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                String resourceName = resource.getName();
                if (resource instanceof IFolder) {
                    if (!".settings".equals(resourceName) && !binEntry.contains(resourceName + "/")) {
                        binEntry.addToken(resourceName + "/");
                    }
                } else if (!(".project".equals(resourceName) || ".classpath".equals(resourceName) || "build.properties".equals(resourceName) || binEntry.contains(resourceName))) {
                    binEntry.addToken(resourceName);
                }
                ++n2;
            }
        } else {
            String[] libraryPaths;
            String[] stringArray = libraryPaths = this.fData.getLibraryPaths();
            int n = libraryPaths.length;
            int n3 = 0;
            while (n3 < n) {
                String libraryPath = stringArray[n3];
                File jarFile = new File(libraryPath);
                String name = jarFile.getName();
                if (!binEntry.contains(name)) {
                    binEntry.addToken(name);
                }
                ++n3;
            }
        }
    }

    @Override
    protected IClasspathEntry[] getInternalClassPathEntries(IJavaProject project, IFieldData data) {
        String[] libraryPaths = this.fData.isUnzipLibraries() ? new String[]{""} : this.fData.getLibraryPaths();
        IClasspathEntry[] entries = new IClasspathEntry[libraryPaths.length];
        int j = 0;
        while (j < libraryPaths.length) {
            File jarFile = new File(libraryPaths[j]);
            String jarName = jarFile.getName();
            IPath path = project.getProject().getFullPath().append(jarName);
            entries[j] = JavaCore.newLibraryEntry((IPath)path, null, null, (boolean)true);
            ++j;
        }
        return entries;
    }

    @Override
    protected int getNumberOfWorkUnits() {
        int numUnits = super.getNumberOfWorkUnits();
        return numUnits += this.fData.getLibraryPaths().length;
    }

    private void importJar(File jar, IResource destination, IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (ZipFile input = new ZipFile(jar);){
                ZipFileStructureProvider provider = new ZipFileStructureProvider(input);
                ImportOperation op = new ImportOperation(destination.getFullPath(), (Object)provider.getRoot(), (IImportStructureProvider)provider, pathString -> "ALL");
                op.run(monitor);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException(Status.error((String)NLS.bind((String)PDEUIMessages.NewProjectCreationOperation_errorImportingJar, (Object)jar), (Throwable)e));
        }
    }

    private void removeExportRoot(IBundle bundle) {
        String value = bundle.getHeader("Bundle-ClassPath");
        if (value == null) {
            value = ".";
        }
        try {
            ManifestElement[] elems = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)value);
            StringBuilder buff = new StringBuilder(value.length());
            int i = 0;
            while (i < elems.length) {
                if (!elems[i].getValue().equals(".")) {
                    buff.append(elems[i].getValue());
                }
                ++i;
            }
            bundle.setHeader("Bundle-ClassPath", buff.toString());
        }
        catch (BundleException bundleException) {
            // empty catch block
        }
    }

    @Override
    protected void setPluginLibraries(WorkspacePluginModelBase model) throws CoreException {
        IPluginBase pluginBase = model.getPluginBase();
        if (this.fData.isUnzipLibraries()) {
            IPluginLibrary library = model.getPluginFactory().createLibrary();
            library.setName(".");
            library.setExported(true);
            pluginBase.add(library);
        } else {
            String[] paths;
            String[] stringArray = paths = this.fData.getLibraryPaths();
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                File jarFile = new File(path);
                IPluginLibrary library = model.getPluginFactory().createLibrary();
                library.setName(jarFile.getName());
                library.setExported(true);
                pluginBase.add(library);
                ++n2;
            }
        }
    }

    @Override
    protected void createSourceOutputBuildEntries(WorkspaceBuildModel model, IBuildModelFactory factory) throws CoreException {
        if (this.fData.isUnzipLibraries()) {
            IBuildEntry entry = factory.createEntry("source..");
            entry.addToken(".");
            model.getBuild().add(entry);
            entry = factory.createEntry("output..");
            entry.addToken(".");
            model.getBuild().add(entry);
        }
    }

    private void addExportedPackages(IProject project, IBundle bundle) {
        String value = bundle.getHeader("Bundle-ClassPath");
        if (value == null) {
            value = ".";
        }
        try {
            ManifestElement[] elems = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)value);
            HashMap<String, List<String>> map = new HashMap<String, List<String>>();
            ManifestElement[] manifestElementArray = elems;
            int n = elems.length;
            int n2 = 0;
            while (n2 < n) {
                ManifestElement elem = manifestElementArray[n2];
                ArrayList<String> filter = new ArrayList<String>();
                filter.add("*");
                map.put(elem.getValue(), filter);
                ++n2;
            }
            Set<String> packages = this.getExports(project, map);
            String pkgValue = this.getCommaValuesFromPackagesSet(packages, this.fData.getVersion());
            bundle.setHeader("Export-Package", pkgValue);
        }
        catch (BundleException bundleException) {
            // empty catch block
        }
    }

    public Set<String> getExports(IProject proj, Map<String, List<String>> libs) {
        IFile buildProperties = PDEProject.getBuildProperties((IProject)proj);
        Build build = null;
        if (buildProperties != null) {
            WorkspaceBuildModel buildModel = new WorkspaceBuildModel(buildProperties);
            build = buildModel.getBuild();
        } else {
            build = new Build();
        }
        return this.findPackages(proj, libs, (IBuild)build);
    }

    private Set<String> findPackages(IProject proj, Map<String, List<String>> libs, IBuild build) {
        TreeSet<String> result = new TreeSet<String>();
        IJavaProject jp = JavaCore.create((IProject)proj);
        for (Map.Entry<String, List<String>> entry : libs.entrySet()) {
            String libName = entry.getKey();
            List<String> filter = entry.getValue();
            IBuildEntry libEntry = build.getEntry(SOURCE_PREFIX + libName);
            if (libEntry != null) {
                String[] tokens;
                String[] stringArray = tokens = libEntry.getTokens();
                int n = tokens.length;
                int n2 = 0;
                while (n2 < n) {
                    String token = stringArray[n2];
                    Object folder = null;
                    folder = token.equals(".") ? proj : proj.getFolder(token);
                    if (folder != null) {
                        this.addPackagesFromFragRoot(jp.getPackageFragmentRoot((IResource)folder), result, filter);
                    }
                    ++n2;
                }
                continue;
            }
            IResource res = proj.findMember(libName);
            if (res == null) continue;
            this.addPackagesFromFragRoot(jp.getPackageFragmentRoot(res), result, filter);
        }
        return result;
    }

    private void addPackagesFromFragRoot(IPackageFragmentRoot root, Collection<String> result, List<?> filter) {
        if (root == null) {
            return;
        }
        try {
            IJavaElement[] children;
            if (filter != null && !filter.contains("*")) {
                ListIterator<?> li = filter.listIterator();
                while (li.hasNext()) {
                    IPackageFragment frag;
                    String pkgName = li.next().toString();
                    if (pkgName.endsWith(".*")) {
                        pkgName = pkgName.substring(0, pkgName.length() - 2);
                    }
                    if ((frag = root.getPackageFragment(pkgName)) == null) continue;
                    result.add(pkgName);
                }
                return;
            }
            IJavaElement[] iJavaElementArray = children = root.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement child = iJavaElementArray[n2];
                IPackageFragment fragment = (IPackageFragment)child;
                String name = fragment.getElementName();
                if (fragment.hasChildren() && !result.contains(name)) {
                    result.add(name);
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }

    private void addDependencies(IProject project, ISharedPluginModel model, IProgressMonitor monitor) {
        if (!(model instanceof IBundlePluginModelBase)) {
            return;
        }
        final boolean unzip = this.fData.isUnzipLibraries();
        try {
            new AddNewBinaryDependenciesOperation(project, (IBundlePluginModelBase)model){

                @Override
                protected String[] findSecondaryBundles(IBundle bundle, Set<String> ignorePkgs) {
                    IPluginModelBase[] bases = PluginRegistry.getActiveModels();
                    String[] ids = new String[bases.length];
                    int i = 0;
                    while (i < bases.length) {
                        BundleDescription desc = bases[i].getBundleDescription();
                        ids[i] = desc == null ? bases[i].getPluginBase().getId() : desc.getSymbolicName();
                        ++i;
                    }
                    return ids;
                }

                @Override
                protected void addProjectPackages(IBundle bundle, Set<String> ignorePkgs) {
                    if (!unzip) {
                        super.addProjectPackages(bundle, ignorePkgs);
                    }
                    ArrayDeque<Object> stack = new ArrayDeque<Object>();
                    stack.push(this.fProject);
                    try {
                        while (!stack.isEmpty()) {
                            IResource[] children;
                            IContainer folder = (IContainer)stack.pop();
                            IResource[] iResourceArray = children = folder.members();
                            int n = children.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IResource child = iResourceArray[n2];
                                if (child instanceof IContainer) {
                                    stack.push(child);
                                } else if ("class".equals(((IFile)child).getFileExtension())) {
                                    String path = folder.getProjectRelativePath().toString();
                                    ignorePkgs.add(path.replace('/', '.'));
                                }
                                ++n2;
                            }
                        }
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
            }.run(monitor);
        }
        catch (InterruptedException | InvocationTargetException exception) {
            // empty catch block
        }
    }
}

