/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.command.ComplexPropertyCommand;
import org.eclipse.birt.report.model.command.PropertyCommand;
import org.eclipse.birt.report.model.core.StructureContext;
import org.eclipse.birt.report.model.metadata.StructPropertyDefn;
import org.eclipse.birt.report.model.util.StructureContextUtil;

public class MemberHandle
extends SimpleValueHandle {
    protected StructureContext memberContext;

    public MemberHandle(StructureHandle structHandle, StructPropertyDefn member) {
        super(structHandle.getElementHandle());
        if (!StructureContextUtil.isValidStructureHandle(structHandle)) {
            throw new RuntimeException("The structure is floating, and its handle is invalid!");
        }
        this.memberContext = StructureContextUtil.getMemberContext(structHandle, member);
        assert (this.memberContext != null);
    }

    @Override
    public IPropertyDefn getDefn() {
        return this.memberContext.getPropDefn();
    }

    @Override
    protected Object getRawValue() {
        return this.memberContext.getValue(this.getModule());
    }

    @Override
    public void setValue(Object value) throws SemanticException {
        PropertyCommand cmd = new PropertyCommand(this.getModule(), this.getElement());
        cmd.setMember(this.memberContext, value);
    }

    @Override
    public void removeItem(int posn) throws PropertyValueException {
        block3: {
            ComplexPropertyCommand cmd = new ComplexPropertyCommand(this.getModule(), this.getElement());
            try {
                cmd.removeItem(this.memberContext, posn);
            }
            catch (PropertyValueException e) {
                throw e;
            }
            catch (SemanticException e) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    @Override
    public void addItem(Object item) throws SemanticException {
        if (item == null) {
            return;
        }
        ComplexPropertyCommand cmd = new ComplexPropertyCommand(this.getModule(), this.getElement());
        cmd.addItem(this.memberContext, item);
    }

    @Override
    public IElementPropertyDefn getPropertyDefn() {
        return this.memberContext.getElementProp();
    }

    @Override
    public StructureContext getContext() {
        return this.memberContext;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isVisible() {
        return true;
    }
}

