/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.model.schematic;

import java.util.List;
import org.eclipse.birt.report.designer.core.model.DesignElementHandleAdapter;
import org.eclipse.birt.report.designer.core.model.IModelAdapterHelper;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.core.model.schematic.TableHandleAdapter;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class CellHandleAdapter
extends DesignElementHandleAdapter {
    public CellHandleAdapter(ReportElementHandle cellHandle, IModelAdapterHelper mark) {
        super((DesignElementHandle)cellHandle, mark);
    }

    public List getChildren() {
        return this.getCellHandle().getContent().getContents();
    }

    public int getRowNumber() {
        assert (this.getCellHandle().getContainer() instanceof RowHandle);
        return HandleAdapterFactory.getInstance().getRowHandleAdapter(this.getCellHandle().getContainer()).getRowNumber();
    }

    public int getColumnNumber() {
        assert (this.getCellHandle().getContainer() instanceof RowHandle);
        if (this.getCellHandle().getColumn() == 0) {
            TableHandleAdapter adapt = HandleAdapterFactory.getInstance().getTableHandleAdapter(this.getTableParent());
            TableHandleAdapter.RowUIInfomation info = adapt.getRowInfo(this.getHandle().getContainer());
            if (info == null) {
                adapt.reload();
                info = adapt.getRowInfo(this.getHandle().getContainer());
            }
            return info.getAllChildren().indexOf(this.getHandle()) + 1;
        }
        return this.getCellHandle().getColumn();
    }

    public int getRowSpan() {
        return this.getCellHandle().getRowSpan();
    }

    public int getColumnSpan() {
        return this.getCellHandle().getColumnSpan();
    }

    public Point getLocation() {
        return new Point(1, 1);
    }

    public Dimension getSize() {
        return new Dimension(60, 40);
    }

    public Rectangle getBounds() {
        return new Rectangle(this.getLocation().x, this.getLocation().y, this.getSize().width, this.getSize().height);
    }

    private CellHandle getCellHandle() {
        return (CellHandle)this.getHandle();
    }

    public void setColumnSpan(int colSpan) throws SemanticException {
        this.getCellHandle().setProperty("colSpan", (Object)colSpan);
    }

    public void setRowSpan(int rowSpan) throws SemanticException {
        this.getCellHandle().setProperty("rowSpan", (Object)rowSpan);
    }

    public Object getTableParent() {
        CellHandle handle = this.getCellHandle();
        while (handle != null) {
            if (handle instanceof TableHandle || handle instanceof GridHandle) {
                return handle;
            }
            handle = handle.getContainer();
        }
        return null;
    }
}

