/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.pojo.ui.impl.dialogs;

import java.util.Arrays;
import org.eclipse.birt.data.oda.pojo.querymodel.ConstantParameter;
import org.eclipse.birt.data.oda.pojo.querymodel.FieldSource;
import org.eclipse.birt.data.oda.pojo.querymodel.IMappingSource;
import org.eclipse.birt.data.oda.pojo.querymodel.IMethodParameter;
import org.eclipse.birt.data.oda.pojo.querymodel.MethodSource;
import org.eclipse.birt.data.oda.pojo.querymodel.VariableParameter;
import org.eclipse.birt.data.oda.pojo.ui.i18n.Messages;
import org.eclipse.birt.data.oda.pojo.ui.impl.dialogs.MethodParameterDialog;
import org.eclipse.birt.data.oda.pojo.ui.impl.models.ColumnDefinition;
import org.eclipse.birt.data.oda.pojo.ui.impl.models.OdaType;
import org.eclipse.birt.data.oda.pojo.ui.impl.providers.ColumnMappingPageHelper;
import org.eclipse.birt.data.oda.pojo.ui.util.HelpUtil;
import org.eclipse.birt.data.oda.pojo.ui.util.Utils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.ExceptionHandler;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;

public class ColumnMappingDialog
extends StatusDialog {
    private ColumnMappingPageHelper helper;
    private ColumnDefinition input;
    private Text txtName;
    private Text txtMappingPath;
    private ComboViewer comboTypes;
    private ColumnDefinition output;
    private TableViewer checkBoxViewer;
    private boolean containsParam;
    private boolean isEditMode;
    private Button editBtn;
    private String name;

    public ColumnMappingDialog(Shell shell, ColumnDefinition cd, ColumnMappingPageHelper helper, boolean isEditMode, boolean containsParameter) {
        super(shell);
        this.input = cd;
        this.helper = helper;
        this.containsParam = containsParameter;
        this.isEditMode = isEditMode;
    }

    protected void setColumnDefinition(ColumnDefinition column) {
        this.input = column;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 20;
        layout.marginHeight = 20;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        gd.minimumWidth = 300;
        composite.setLayoutData((Object)gd);
        Composite topArea = new Composite(composite, 0);
        GridLayout topLayout = new GridLayout(2, false);
        topLayout.marginWidth = 10;
        topLayout.horizontalSpacing = 20;
        topArea.setLayout((Layout)topLayout);
        GridData layoutData = new GridData(768);
        topArea.setLayoutData((Object)layoutData);
        Label columnLabel = new Label(topArea, 0);
        columnLabel.setText(Messages.getString("ColumnMappingDialog.Label.ColumnName"));
        this.txtName = new Text(topArea, 2048);
        this.txtName.setLayoutData((Object)new GridData(768));
        this.txtName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ColumnMappingDialog.this.name = ColumnMappingDialog.this.txtName.getText().trim();
                ColumnMappingDialog.this.validateSyntax();
            }
        });
        Label typeLabel = new Label(topArea, 0);
        typeLabel.setText(Messages.getString("ColumnMappingDialog.Label.Type"));
        this.comboTypes = new ComboViewer(topArea, 8);
        GridData comboData = new GridData(768);
        comboData.widthHint = 200;
        this.comboTypes.getCombo().setLayoutData((Object)comboData);
        this.comboTypes.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object arg0) {
                OdaType[] result = OdaType.values();
                Arrays.sort(result, new OdaType.OdaTypeComparator());
                return result;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
            }
        });
        this.comboTypes.setInput((Object)"");
        if (this.containsParam) {
            this.createParameterArea(composite);
        } else {
            Label methodLabel = new Label(topArea, 0);
            methodLabel.setText(Messages.getString("ColumnMappingDialog.Label.ColumnMethodField"));
            this.txtMappingPath = new Text(topArea, 2048);
            this.txtMappingPath.setLayoutData((Object)new GridData(768));
            this.txtMappingPath.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ColumnMappingDialog.this.validateSyntax();
                }
            });
        }
        if (this.input != null && this.input.getName() != null) {
            this.name = this.isEditMode ? this.input.getName() : this.helper.getDistinctName(this.input.getName());
            this.txtName.setText(this.name);
            if (!this.containsParam) {
                this.txtMappingPath.setText(this.input.getMappingPathText());
            } else {
                IMappingSource item = this.input.getMappingPath()[this.input.getMappingPath().length - 1];
                if (item instanceof MethodSource) {
                    this.checkBoxViewer.setInput((Object)((MethodSource)item));
                }
            }
            this.comboTypes.setSelection((ISelection)new StructuredSelection((Object)this.input.getType()));
        } else {
            this.comboTypes.setSelection((ISelection)new StructuredSelection((Object)OdaType.String));
        }
        this.getShell().setText(this.isEditMode ? Messages.getString("DataSet.EditColumnMapping") : Messages.getString("DataSet.AddColumnMapping"));
        HelpUtil.setSystemHelp((Control)composite, "org.eclipse.birt.cshelp.Dialog_POJO_Dataset_ColumnMapping_ID");
        return composite;
    }

    private void createParameterArea(Composite composite) {
        Composite paramArea = new Composite(composite, 0);
        GridLayout paramAreaLayout = new GridLayout(2, false);
        paramAreaLayout.marginWidth = 5;
        paramAreaLayout.marginHeight = 15;
        paramAreaLayout.horizontalSpacing = 15;
        paramArea.setLayout((Layout)paramAreaLayout);
        GridData layoutData = new GridData(1808);
        layoutData.horizontalSpan = 2;
        layoutData.heightHint = 200;
        paramArea.setLayoutData((Object)layoutData);
        this.createTreeViewer(paramArea);
        this.createRightArea(paramArea);
    }

    private void createRightArea(Composite paramArea) {
        Composite right = new Composite(paramArea, 0);
        right.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(1808);
        gd.heightHint = 200;
        right.setLayoutData((Object)gd);
        Label tableLabel = new Label(right, 0);
        tableLabel.setText(Messages.getString("ColumnMappingDialog.table.promptLabel"));
        GridData lableData = new GridData(768);
        tableLabel.setLayoutData((Object)lableData);
        Table table = new Table(right, 67589);
        GridData gridData = new GridData(1808);
        table.setLayoutData((Object)gridData);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn checkBoxColumn = new TableColumn(table, 16384);
        checkBoxColumn.setResizable(true);
        checkBoxColumn.setText(Messages.getString("ColumnMappingDialog.table.head.mapped"));
        checkBoxColumn.setWidth(70);
        TableColumn nameColumn = new TableColumn(table, 16384);
        nameColumn.setResizable(true);
        nameColumn.setText(Messages.getString("ColumnMappingDialog.table.head.name"));
        nameColumn.setWidth(80);
        TableColumn valueColumn = new TableColumn(table, 16384);
        valueColumn.setResizable(true);
        valueColumn.setText(Messages.getString("ColumnMappingDialog.table.head.value"));
        valueColumn.setWidth(80);
        TableColumn typeColumn = new TableColumn(table, 16384);
        typeColumn.setResizable(true);
        typeColumn.setText(Messages.getString("ColumnMappingDialog.table.head.dataType"));
        typeColumn.setWidth(80);
        this.checkBoxViewer = new TableViewer(table);
        this.checkBoxViewer.getTable().setLayoutData((Object)gd);
        TableProvider provider = new TableProvider();
        this.checkBoxViewer.setContentProvider((IContentProvider)provider);
        this.checkBoxViewer.setLabelProvider((IBaseLabelProvider)provider);
        this.checkBoxViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ColumnMappingDialog.this.editBtn.setEnabled(ColumnMappingDialog.this.checkBoxViewer.getTable().getSelectionCount() == 1);
            }
        });
        this.checkBoxViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ColumnMappingDialog.this.doEditPrameter();
            }
        });
        this.createButtonArea(right);
    }

    private void createButtonArea(Composite right) {
        Composite composite = new Composite(right, 0);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        this.editBtn = new Button(composite, 8);
        this.editBtn.setText(Messages.getString("ColumnMappingDialog.button.edit"));
        GridData gd = new GridData();
        gd.horizontalAlignment = 0x1000008;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = this.editBtn.computeSize((int)-1, (int)-1).x - this.editBtn.getBorderWidth() + 20;
        this.editBtn.setLayoutData((Object)gd);
        this.editBtn.setEnabled(false);
        this.editBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnMappingDialog.this.doEditPrameter();
            }
        });
    }

    private void createTreeViewer(Composite paramArea) {
        Composite left = new Composite(paramArea, 0);
        left.setLayout((Layout)new GridLayout(1, false));
        GridData data = new GridData(1808);
        data.widthHint = 150;
        left.setLayoutData((Object)data);
        Label label = new Label(left, 0);
        label.setText(Messages.getString("ColumnMappingDialog.Label.methodHierarchy"));
        final TreeViewer treeViewer = new TreeViewer(left, 2052);
        treeViewer.getTree().setLayoutData((Object)new GridData(1808));
        TreeProvider treeProvider = new TreeProvider();
        treeViewer.setLabelProvider((IBaseLabelProvider)treeProvider);
        treeViewer.setContentProvider((IContentProvider)treeProvider);
        if (this.input != null) {
            treeViewer.setInput((Object)this.input.getMappingPath());
        }
        treeViewer.expandAll();
        TreeItem[] items = treeViewer.getTree().getItems();
        TreeItem item = null;
        while (items.length > 0) {
            item = items[0];
            items = item.getItems();
        }
        if (item != null) {
            treeViewer.getTree().select(item);
        }
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object item;
                ColumnMappingDialog.this.editBtn.setEnabled(false);
                if (treeViewer.getTree().getSelectionCount() == 1 && (item = treeViewer.getTree().getSelection()[0].getData()) instanceof MethodSource) {
                    ColumnMappingDialog.this.checkBoxViewer.setInput((Object)((MethodSource)item));
                    ColumnMappingDialog.this.checkBoxViewer.refresh();
                }
            }
        });
    }

    protected void buttonPressed(int buttonId) {
        this.output = null;
        if (buttonId == 0) {
            IMappingSource[] sources = null;
            try {
                sources = this.containsParam ? this.input.getMappingPath() : Utils.getMappingSource(this.txtMappingPath.getText().trim());
            }
            catch (OdaException e) {
                ExceptionHandler.showException((Shell)this.getShell(), (String)e.getLocalizedMessage(), (String)e.getLocalizedMessage(), (Throwable)e);
                this.txtMappingPath.selectAll();
                this.txtMappingPath.setFocus();
                return;
            }
            this.output = new ColumnDefinition(sources, this.txtName.getText().trim(), this.getSelectedType());
        }
        super.buttonPressed(buttonId);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.validateSyntax();
    }

    private void doEditPrameter() {
        Object element;
        if (this.checkBoxViewer.getTable().getSelectionCount() == 1 && (element = ((StructuredSelection)this.checkBoxViewer.getSelection()).getFirstElement()) instanceof IMethodParameter) {
            MethodParameterDialog dialog = new MethodParameterDialog((IMethodParameter)element);
            dialog.setValidator(new MethodParameterDialog.IModifyValidator(){

                @Override
                public boolean validateInputValue(Object value, Object[] args) {
                    if (value instanceof VariableParameter && args.length >= 2) {
                        return ColumnMappingDialog.this.helper.isValidParamName((VariableParameter)value, (String)args[0], (String)args[1]);
                    }
                    return true;
                }
            });
            if (dialog.open() == 0) {
                ((MethodSource)this.checkBoxViewer.getInput()).updateMethodParameter((IMethodParameter)element, dialog.updateMethodParameter());
                this.checkBoxViewer.refresh();
            }
        }
    }

    private OdaType getSelectedType() {
        IStructuredSelection ss = (IStructuredSelection)this.comboTypes.getSelection();
        return (OdaType)((Object)ss.getFirstElement());
    }

    private void validateSyntax() {
        Status status = null;
        status = (!this.isEditMode || !this.input.getName().equals(this.name)) && !this.helper.isUniqueColumnName(this.name) ? this.getMiscStatus(4, Messages.getString("ColumnMappingDialog.error.DuplicatedColumnName")) : (Utils.isEmptyString(this.name) ? this.getMiscStatus(4, Messages.getString("ColumnMappingDialog.error.EmptyColumnName")) : (!this.containsParam && this.txtMappingPath != null && Utils.isEmptyString(this.txtMappingPath.getText()) ? this.getMiscStatus(4, Messages.getString("ColumnMappingDialog.error.EmptyMappingPath")) : this.getOKStatus()));
        if (status != null) {
            this.updateStatus((IStatus)status);
        }
    }

    private Status getMiscStatus(int severity, String message) {
        return new Status(severity, "org.eclipse.ui", severity, message, null);
    }

    private Status getOKStatus() {
        return this.getMiscStatus(0, "");
    }

    public ColumnDefinition getColumnDefinition() {
        return this.output;
    }

    protected boolean isResizable() {
        return true;
    }

    private static class TableProvider
    implements ITableLabelProvider,
    IStructuredContentProvider {
        private TableProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                if (element instanceof VariableParameter) {
                    return Utils.getOKIcon();
                }
                if (element instanceof ConstantParameter) {
                    return Utils.getFailIcon();
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof IMethodParameter) {
                IMethodParameter param = (IMethodParameter)element;
                if (columnIndex == 0) {
                    return null;
                }
                if (columnIndex == 1) {
                    return param instanceof VariableParameter ? ((VariableParameter)param).getName() : "N/A";
                }
                if (columnIndex == 2) {
                    return param.getStringValue() == null ? "" : param.getStringValue().toString();
                }
                return param.getDataType();
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof MethodSource) {
                return ((MethodSource)inputElement).getParameters();
            }
            return new Object[0];
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class TreeProvider
    implements ILabelProvider,
    ITreeContentProvider {
        private IMappingSource[] sources;
        private int count;

        private TreeProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof MethodSource) {
                return Utils.getMethodFlagImg();
            }
            if (element instanceof FieldSource) {
                return Utils.getFieldFlagImg();
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof FieldSource) {
                return ((FieldSource)element).getName();
            }
            if (element instanceof MethodSource) {
                return ((MethodSource)element).getName() + "(" + this.getParametersLabel((MethodSource)element) + ")";
            }
            return "";
        }

        private String getParametersLabel(MethodSource method) {
            if (method == null) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            IMethodParameter[] iMethodParameterArray = method.getParameters();
            int n = iMethodParameterArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethodParameter param = iMethodParameterArray[n2];
                sb.append(", ").append(param.getDataType());
                ++n2;
            }
            String result = sb.toString();
            if (result.length() > 0) {
                result = result.substring(2);
            }
            return result;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Object[] getChildren(Object parentElement) {
            if (this.count < this.sources.length) {
                return new Object[]{this.sources[this.count++]};
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.count < this.sources.length;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IMappingSource[]) {
                this.sources = (IMappingSource[])inputElement;
                this.count = 0;
                return this.getChildren((IMappingSource[])inputElement);
            }
            return new Object[0];
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

