/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.ui;

import com.ibm.icu.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.reportitem.ChartReportItemImpl;
import org.eclipse.birt.chart.reportitem.api.ChartCubeUtil;
import org.eclipse.birt.chart.reportitem.api.ChartItemUtil;
import org.eclipse.birt.chart.reportitem.ui.ChartReportItemUIFactory;
import org.eclipse.birt.chart.reportitem.ui.ChartReportItemUIUtil;
import org.eclipse.birt.chart.reportitem.ui.ChartXTabUIUtil;
import org.eclipse.birt.chart.reportitem.ui.DesignerRepresentation;
import org.eclipse.birt.chart.reportitem.ui.i18n.Messages;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.ReportElementFigure;
import org.eclipse.birt.report.designer.ui.extensions.ReportItemFigureProvider;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentEvent;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.widgets.Display;

public class ChartReportItemUIImpl
extends ReportItemFigureProvider {
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.reportitem/trace");
    private static Map<DesignElementHandle, Listener> listenerMap = new HashMap<DesignElementHandle, Listener>();

    public final IFigure createFigure(final ExtendedItemHandle eih) {
        try {
            eih.loadExtendedElement();
        }
        catch (ExtendedElementException eeex) {
            logger.log((Exception)((Object)eeex));
        }
        try {
            ChartReportItemImpl iri = (ChartReportItemImpl)eih.getReportItem();
            DesignerRepresentation dr = ChartReportItemUIFactory.instance().createFigure(iri);
            ChartReportItemUIUtil.refreshBackground(eih, dr);
            iri.setDesignerRepresentation((Object)dr);
            if (iri.isCopied() && ChartCubeUtil.isPlotChart((DesignElementHandle)eih)) {
                ExtendedItemHandle axisChart;
                DesignElementHandle oldPlotChart;
                AggregationCellHandle containerCell;
                AggregationCellHandle grandTotalCell;
                Object content;
                ChartWithAxes cwa = (ChartWithAxes)iri.getProperty("chart.instance");
                Axis yAxis = (Axis)((Axis)cwa.getAxes().get(0)).getAssociatedAxes().get(0);
                if (yAxis.getLineAttributes().isVisible() && ChartCubeUtil.findReferenceChart((ExtendedItemHandle)eih) == null && ChartCubeUtil.isAxisChart((DesignElementHandle)((DesignElementHandle)(content = ChartCubeUtil.getFirstContent((CrosstabCellHandle)(grandTotalCell = ChartXTabUIUtil.getGrandTotalAggregationCell((AggregationCellHandle)(containerCell = ChartCubeUtil.getXtabContainerCell((DesignElementHandle)eih)), (boolean)cwa.isTransposed())))))) && ((oldPlotChart = (axisChart = (ExtendedItemHandle)content).getElementProperty("hostChart")) == null || !oldPlotChart.equals(eih))) {
                    Display.getCurrent().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                axisChart.setProperty("hostChart", (Object)eih);
                                ChartReportItemUIImpl.this.addDeleteListenerToHostChart((DesignElementHandle)eih, listenerMap.get(axisChart));
                            }
                            catch (SemanticException e) {
                                logger.log((Exception)((Object)e));
                            }
                        }
                    });
                }
            } else if (ChartCubeUtil.isAxisChart((DesignElementHandle)eih)) {
                DesignElementHandle hostChart = eih.getElementProperty("hostChart");
                if (hostChart != null) {
                    Listener listener = this.createDeleteChartListener((DesignElementHandle)eih);
                    this.addDeleteListenerToHostChart(hostChart, listener);
                }
            } else {
                Chart cm = (Chart)iri.getProperty("chart.instance");
                if (cm != null) {
                    Bounds bo = cm.getBlock().getBounds();
                    NumberFormat nf = ChartUIUtil.getDefaultNumberFormatInstance();
                    if ((bo == null || bo.getWidth() == 0.0 || bo.getHeight() == 0.0) && (nf.format(212.0) + "pt").equals(eih.getWidth().getStringValue()) && (nf.format(130.0) + "pt").equals(eih.getHeight().getStringValue())) {
                        dr.needFitContainer = true;
                    }
                }
            }
            return dr;
        }
        catch (BirtException e) {
            logger.log((Exception)((Object)e));
            return null;
        }
    }

    private void addDeleteListenerToHostChart(DesignElementHandle hostChart, Listener listener) {
        DesignElementHandle cell = hostChart.getContainer();
        cell.addListener(listener);
        if (cell.getContainer() != null) {
            cell.getContainer().addListener(listener);
        }
    }

    public final void updateFigure(final ExtendedItemHandle eih, final IFigure ifg) {
        try {
            eih.loadExtendedElement();
            eih.getReportItem().setHandle(eih);
            ChartReportItemUIUtil.refreshBackground(eih, (ReportElementFigure)ifg);
            IDisplayServer idsSWT = ChartUIUtil.getDisplayServer();
            final int dpi = idsSWT.getDpiResolution();
            eih.loadExtendedElement();
            ChartReportItemImpl iri = (ChartReportItemImpl)eih.getReportItem();
            DesignerRepresentation dr = (DesignerRepresentation)((Object)iri.getDesignerRepresentation());
            if (dr.needFitContainer) {
                dr.needFitContainer = false;
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ChartReportItemUIImpl.this.resizeToFitContainer(eih, ifg, dpi);
                    }
                });
            }
            eih.getReportItem().setHandle(eih);
            ChartReportItemUIUtil.refreshBackground(eih, (ReportElementFigure)ifg);
            Bounds bounds = ChartItemUtil.computeChartBounds((ExtendedItemHandle)eih, (int)dpi);
            if (bounds == null) {
                return;
            }
            double dHeightInPixels = (double)dpi * bounds.getHeight() / 72.0;
            double dWidthInPixels = (double)dpi * bounds.getWidth() / 72.0;
            ((DesignerRepresentation)ifg).setDirty(true);
            Dimension newSize = ifg.getBounds().getCopy().getSize();
            if (dWidthInPixels >= 0.0) {
                newSize.width = (int)dWidthInPixels;
            }
            if (dHeightInPixels >= 0.0) {
                newSize.height = (int)dHeightInPixels;
            }
            ifg.setSize(newSize);
        }
        catch (BirtException ex) {
            logger.log((Exception)((Object)ex));
        }
    }

    private void resizeToFitContainer(ExtendedItemHandle eih, IFigure ifg, int dpi) {
        Chart cm = ChartItemUtil.getChartFromHandle((ExtendedItemHandle)eih);
        Chart cmNew = cm.copyInstance();
        CommandStack commandStack = eih.getRoot().getCommandStack();
        String TRANS_NAME = Messages.getString("ChartReportItemUIImpl.Command.ResizeChart");
        commandStack.startTrans(TRANS_NAME);
        Rectangle parentCA = ifg.getParent().getClientArea();
        Bounds parentBounds = BoundsImpl.create((double)0.0, (double)0.0, (double)parentCA.width, (double)parentCA.height).scaledInstance(72.0 / (double)dpi);
        parentBounds.setHeight(Math.max(130.0, Math.min(parentBounds.getHeight(), parentBounds.getWidth() / 2.0)));
        cmNew.getBlock().setBounds(parentBounds);
        NumberFormat nf = ChartUIUtil.getDefaultNumberFormatInstance();
        try {
            try {
                ((ChartReportItemImpl)eih.getReportItem()).executeSetModelCommand(eih, cm, cmNew);
                eih.setWidth(nf.format(parentBounds.getWidth()) + "pt");
                eih.setHeight(nf.format(parentBounds.getHeight()) + "pt");
            }
            catch (BirtException e) {
                logger.log((Exception)((Object)e));
                commandStack.commit();
            }
        }
        finally {
            commandStack.commit();
        }
    }

    public final void disposeFigure(ExtendedItemHandle eih, IFigure ifg) {
        logger.log(1, Messages.getString("ChartReportItemUIImpl.log.ReceivedNotification"));
        ((DesignerRepresentation)ifg).dispose();
        listenerMap.remove(eih);
    }

    private Listener createDeleteChartListener(final DesignElementHandle handleTarget) {
        if (listenerMap.containsKey(handleTarget)) {
            return listenerMap.get(handleTarget);
        }
        Listener listener = new Listener(){

            public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
                DesignElementHandle handleSource;
                ContentEvent cv;
                if (ev instanceof ContentEvent && (cv = (ContentEvent)ev).getAction() == 2 && ((handleSource = handleTarget.getElementProperty("hostChart")) == null || cv.getContent() == handleSource.getElement())) {
                    try {
                        if (handleTarget.getRoot() != null) {
                            handleTarget.dropAndClear();
                        }
                    }
                    catch (SemanticException e) {
                        logger.log((Exception)((Object)e));
                    }
                }
            }
        };
        listenerMap.put(handleTarget, listener);
        return listener;
    }
}

