/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.core.jsonpath;

import org.eclipse.json.jsonpath.IJSONPath;
import org.eclipse.wst.json.core.document.IJSONNode;
import org.eclipse.wst.json.core.document.IJSONPair;

public class JSONPathMatcher {
    public static boolean isMatch(IJSONNode node, IJSONPath path) {
        String name = null;
        String segment = null;
        String[] segments = path.getSegments();
        int i = segments.length - 1;
        while (i >= 0) {
            segment = segments[i];
            name = JSONPathMatcher.getName(node);
            if (name == null) {
                return false;
            }
            if (!segment.equals(name)) {
                return false;
            }
            node = node.getParentNode();
            --i;
        }
        return true;
    }

    public static String getName(IJSONNode node) {
        if (node == null) {
            return null;
        }
        if (node.getNodeType() == 2) {
            return ((IJSONPair)node).getName();
        }
        IJSONNode parent = node.getParentOrPairNode();
        if (parent == null) {
            return null;
        }
        switch (parent.getNodeType()) {
            case -1: {
                return "$";
            }
            case 2: {
                return ((IJSONPair)parent).getName();
            }
        }
        return null;
    }
}

