/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.preview.parameter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.ui.preview.parameter.AbstractParamGroup;
import org.eclipse.birt.report.designer.ui.preview.parameter.CascadingGroup;
import org.eclipse.birt.report.designer.ui.preview.parameter.ComboBoxParam;
import org.eclipse.birt.report.designer.ui.preview.parameter.IParamGroup;
import org.eclipse.birt.report.designer.ui.preview.parameter.IParameter;
import org.eclipse.birt.report.designer.ui.preview.parameter.ListBoxParam;
import org.eclipse.birt.report.designer.ui.preview.parameter.ParamGroup;
import org.eclipse.birt.report.designer.ui.preview.parameter.RadioParam;
import org.eclipse.birt.report.designer.ui.preview.parameter.ScalarParam;
import org.eclipse.birt.report.designer.ui.preview.parameter.StaticTextParam;
import org.eclipse.birt.report.engine.api.IEngineTask;
import org.eclipse.birt.report.engine.api.IGetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.model.api.CascadingParameterGroupHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.SlotHandle;

public class ParameterFactory {
    private IGetParameterDefinitionTask task = null;
    private static final String RADIO_BUTTON = "radio-button";
    private static final String TEXT_BOX = "text-box";
    private static final String LIST_BOX = "list-box";

    public ParameterFactory(IGetParameterDefinitionTask task) {
        this.task = task;
    }

    public List getRootChildren() {
        IReportRunnable runnable = this.task.getReportRunnable();
        if (runnable == null) {
            return null;
        }
        DesignElementHandle designHandle = runnable.getDesignHandle();
        if (designHandle == null) {
            return null;
        }
        assert (designHandle.getRoot() != null);
        List parameters = designHandle.getRoot().getParametersAndParameterGroups();
        Iterator iterator = parameters.iterator();
        ArrayList<Object> childrenList = new ArrayList<Object>();
        while (iterator.hasNext()) {
            AbstractParamGroup group;
            ParameterGroupHandle groupHandle;
            DesignElementHandle handle = (DesignElementHandle)iterator.next();
            if (handle instanceof ScalarParameterHandle) {
                ScalarParam param = this.createScalarParameter((ScalarParameterHandle)handle);
                childrenList.add(param);
                continue;
            }
            if (handle instanceof ParameterHandle) continue;
            if (handle instanceof CascadingParameterGroupHandle) {
                groupHandle = (ParameterGroupHandle)handle;
                group = new CascadingGroup(groupHandle);
                childrenList.add(group);
                this.createParameterGroup(group, groupHandle);
                continue;
            }
            if (!(handle instanceof ParameterGroupHandle)) continue;
            groupHandle = (ParameterGroupHandle)handle;
            group = new ParamGroup(groupHandle);
            childrenList.add(group);
            this.createParameterGroup(group, groupHandle);
        }
        return childrenList;
    }

    private void createParameterGroup(IParamGroup group, ParameterGroupHandle groupHandle) {
        assert (group != null);
        assert (groupHandle != null);
        SlotHandle slotHandle = groupHandle.getSlot(0);
        for (ParameterHandle handle : slotHandle) {
            this.createParameter(group, handle);
        }
    }

    private IParameter createParameter(IParamGroup parentGroup, ParameterHandle paramHandle) {
        assert (parentGroup != null);
        assert (paramHandle != null);
        ScalarParam param = null;
        if (paramHandle instanceof ScalarParameterHandle) {
            param = this.createScalarParameter((ScalarParameterHandle)paramHandle);
        }
        if (param != null) {
            parentGroup.addParameter(param);
        }
        return param;
    }

    private ScalarParam createScalarParameter(ScalarParameterHandle paramHandle) {
        ScalarParam param = null;
        String controlType = paramHandle.getControlType();
        if (controlType.equals(LIST_BOX)) {
            boolean mustMatch = paramHandle.isMustMatch();
            param = mustMatch ? new ListBoxParam(paramHandle, (IEngineTask)this.task) : new ComboBoxParam(paramHandle, (IEngineTask)this.task);
        } else if (controlType.equals(TEXT_BOX)) {
            param = new StaticTextParam(paramHandle, (IEngineTask)this.task);
        } else if (controlType.equals(RADIO_BUTTON)) {
            param = new RadioParam(paramHandle, (IEngineTask)this.task);
        }
        return param;
    }
}

