/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.ide.adapters;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.ui.wizards.INewLibraryCreationPage;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.command.LibraryChangeEvent;
import org.eclipse.birt.report.model.api.command.ResourceChangeEvent;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

class NewLibraryCreationPage
extends WizardNewFileCreationPage
implements INewLibraryCreationPage {
    private String fileExtension = "rptlibrary";
    private static final String OPENING_FILE_FOR_EDITING = Messages.getString((String)"NewLibraryWizard.text.OpenFileForEditing");
    private static final String CREATING = Messages.getString((String)"NewLibraryWizard.text.Creating");

    public void createControl(Composite parent) {
        super.createControl(parent);
        UIUtil.bindHelp((Control)this.getControl(), (String)"org.eclipse.birt.cshelp.NewLibraryWizard_ID");
    }

    public NewLibraryCreationPage(String pageName, IStructuredSelection selection) {
        super(pageName, selection);
        super.setFileExtension(this.fileExtension);
    }

    protected void createAdvancedControls(Composite parent) {
    }

    protected IStatus validateLinkedResource() {
        return new Status(0, ReportPlugin.getDefault().getBundle().getSymbolicName(), 0, "", null);
    }

    public boolean performFinish() {
        final IPath containerName = this.getContainerFullPath();
        String fn = this.getFileName();
        final String fileName = !Platform.getOS().equals("win32") ? (!fn.endsWith("." + this.fileExtension) ? String.valueOf(fn) + "." + this.fileExtension : fn) : (!fn.toLowerCase(Locale.getDefault()).endsWith("." + this.fileExtension) ? String.valueOf(fn) + "." + this.fileExtension : fn);
        if (Platform.getBundle((String)"org.eclipse.birt.resources") == null) {
            return true;
        }
        final String libraryFileName = UIUtil.getDefaultLibraryTemplate();
        if (libraryFileName == null) {
            return false;
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        NewLibraryCreationPage.this.doFinish(containerName, fileName, libraryFileName, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            ExceptionUtil.handle((Throwable)realException);
            return false;
        }
        return true;
    }

    private void doFinish(IPath containerName, String fileName, String sourceFileName, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(String.valueOf(CREATING) + fileName, 2);
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(containerName);
        IContainer container = null;
        if (resource == null || !resource.exists() || !(resource instanceof IContainer)) {
            IFolder folder = this.createFolderHandle(containerName);
            UIUtil.createFolder((IFolder)folder, (IProgressMonitor)monitor);
            container = folder;
        } else {
            container = (IContainer)resource;
        }
        final IFile file = container.getFile((IPath)new Path(fileName));
        try {
            String description;
            LibraryHandle handle = SessionHandleAdapter.getInstance().getSessionHandle().createLibraryFromTemplate(sourceFileName);
            if (ReportPlugin.getDefault().getEnableCommentPreference(file.getProject())) {
                handle.setStringProperty("comments", ReportPlugin.getDefault().getCommentPreference(file.getProject()));
            }
            if (ReportPlugin.getDefault().getDefaultUnitPreference(file.getProject()) != null) {
                handle.setStringProperty("units", ReportPlugin.getDefault().getDefaultUnitPreference(file.getProject()));
            }
            if (this.inPredifinedTemplateFolder(sourceFileName) && (description = handle.getDescription()) != null && description.trim().length() > 0) {
                handle.setDescription(Messages.getString((String)description));
            }
            UIUtil.addCreateBy((ModuleHandle)handle);
            handle.saveAs(file.getLocation().toOSString());
            handle.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        container.refreshLocal(2, monitor);
        monitor.worked(1);
        monitor.setTaskName(OPENING_FILE_FOR_EDITING);
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                IWorkbenchPage page = window.getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (Exception e) {
                    ExceptionUtil.handle((Throwable)e);
                }
            }
        });
        monitor.worked(1);
        this.fireLibraryChanged(fileName);
    }

    private void fireLibraryChanged(String fileName) {
        SessionHandleAdapter.getInstance().getSessionHandle().fireResourceChange((ResourceChangeEvent)new LibraryChangeEvent(fileName));
    }

    protected IFolder createFolderHandle(IPath folderPath) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        return workspaceRoot.getFolder(folderPath);
    }

    protected boolean inPredifinedTemplateFolder(String sourceFileName) {
        String predifinedDir = UIUtil.getFragmentDirectory();
        File predifinedFile = new File(predifinedDir);
        File sourceFile = new File(sourceFileName);
        return sourceFile.getAbsolutePath().startsWith(predifinedFile.getAbsolutePath());
    }

    public void updatePerspective(IConfigurationElement configElement) {
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)configElement);
    }

    protected boolean validatePage() {
        boolean rt = super.validatePage();
        if (rt) {
            String fn = this.getFileName();
            if (!Platform.getOS().equals("win32")) {
                IPath resourcePath = !fn.endsWith("." + this.fileExtension) ? this.getContainerFullPath().append(String.valueOf(this.getFileName()) + "." + this.fileExtension) : this.getContainerFullPath().append(this.getFileName());
                if (resourcePath.lastSegment().equals("." + this.fileExtension)) {
                    this.setErrorMessage(Messages.getString((String)"WizardNewReportCreationPage.Errors.nameEmpty"));
                    return false;
                }
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                if (workspace.getRoot().getFolder(resourcePath).exists() || workspace.getRoot().getFile(resourcePath).exists()) {
                    this.setErrorMessage(Messages.getString((String)"WizardNewReportCreationPage.Errors.nameExists"));
                    rt = false;
                }
            } else {
                IPath resourcePath = !fn.toLowerCase().endsWith(("." + this.fileExtension).toLowerCase()) ? this.getContainerFullPath().append(String.valueOf(this.getFileName()) + "." + this.fileExtension) : this.getContainerFullPath().append(this.getFileName());
                if (resourcePath.lastSegment().equals("." + this.fileExtension)) {
                    this.setErrorMessage(Messages.getString((String)"WizardNewReportCreationPage.Errors.nameEmpty"));
                    return false;
                }
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                if (workspace.getRoot().getFolder(resourcePath).getLocation().toFile().exists() || workspace.getRoot().getFile(resourcePath).getLocation().toFile().exists()) {
                    this.setErrorMessage(Messages.getString((String)"WizardNewReportCreationPage.Errors.nameExists"));
                    rt = false;
                }
            }
        }
        return rt;
    }
}

