/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.aggregation.AggregationUtil;
import org.eclipse.birt.data.engine.api.aggregation.AggregationManager;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ComparatorUtil;
import org.eclipse.birt.data.engine.executor.cache.SizeOfUtil;
import org.eclipse.birt.data.engine.i18n.DataResourceHandle;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultRow;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.api.MeasureInfo;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationFunctionDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.DimColumn;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationCalculator;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationResultRow;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.ColumnInfo;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.DiskSortedStackWrapper;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.ICubeDimensionReader;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.IDataSet4Aggregation;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.MergeRow4Aggregation;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.Row4Aggregation;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.Row4AggregationComparator;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.TimeFunctionCalculator;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.TimeResultRow;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Member;
import org.eclipse.birt.data.engine.olap.data.util.BufferedStructureArray;
import org.eclipse.birt.data.engine.olap.data.util.DiskSortedStack;

public class AggregationExecutor {
    private AggregationCalculator[] aggregationCalculators = null;
    private DiskSortedStackWrapper[] sortedFactRows = null;
    private TimeFunctionCalculator[] timeFunctionCalculator = null;
    private List allSortedFactRows = null;
    private MergeRow4Aggregation[] mergeRow4Aggregations = null;
    private int measureIndexes4Merge;
    private int parameterColIndex4Merge;
    private int[][] levelIndex = null;
    private DimColumn[] paraColumns = null;
    private ColumnInfo[] paraInfos;
    protected IDataSet4Aggregation dataSet4Aggregation;
    private ICubeDimensionReader cubeDimensionReader;
    protected static Logger logger = Logger.getLogger(AggregationExecutor.class.getName());
    public int maxDataObjectRows = -1;
    public long memoryCacheSize = 0L;
    public Row4Aggregation[] aggregationRow;
    private AggregationFunctionDefinition simpleFunc;
    private boolean existReferenceDate = false;
    private static String[] simpleFuncNames = new String[]{"SUM", "MAX", "MIN", "FIRST", "LAST"};

    public AggregationExecutor(ICubeDimensionReader cubeDimensionReader, IDataSet4Aggregation dataSet4Aggregation, AggregationDefinition[] aggregations, long memoryCacheSize) throws IOException, DataException {
        int i;
        Object[] params = new Object[]{dataSet4Aggregation, aggregations};
        logger.entering(AggregationExecutor.class.getName(), "AggregationExecutor", params);
        this.dataSet4Aggregation = dataSet4Aggregation;
        this.memoryCacheSize = memoryCacheSize > 0L ? memoryCacheSize : -memoryCacheSize;
        this.getParameterColIndex(aggregations);
        this.existReferenceDate = memoryCacheSize > 0L ? true : AggregationExecutor.existReferenceDate(aggregations);
        this.simpleFunc = this.getSimpleFunction(aggregations);
        this.aggregationCalculators = new AggregationCalculator[aggregations.length];
        int detailAggregationIndex = -1;
        int detailLevelNum = 0;
        if (aggregations.length > 2) {
            i = 0;
            while (i < aggregations.length) {
                if (aggregations[i].getLevels() != null && aggregations[i].getLevels().length > detailLevelNum) {
                    detailLevelNum = aggregations[i].getLevels().length;
                    detailAggregationIndex = i;
                }
                ++i;
            }
        }
        this.cubeDimensionReader = cubeDimensionReader;
        this.timeFunctionCalculator = new TimeFunctionCalculator[aggregations.length];
        i = 0;
        while (i < this.aggregationCalculators.length) {
            this.timeFunctionCalculator[i] = new TimeFunctionCalculator(aggregations[i], this.paraColumns, dataSet4Aggregation.getMetaInfo(), this.cubeDimensionReader, this.memoryCacheSize / 5L / (long)this.aggregationCalculators.length);
            this.aggregationCalculators[i] = i == detailAggregationIndex ? new AggregationCalculator(aggregations[i], this.paraColumns, dataSet4Aggregation.getMetaInfo(), cubeDimensionReader, this.memoryCacheSize / 10L) : new AggregationCalculator(aggregations[i], this.paraColumns, dataSet4Aggregation.getMetaInfo(), cubeDimensionReader, this.memoryCacheSize / 5L / (long)this.aggregationCalculators.length);
            ++i;
        }
        if (this.simpleFunc != null) {
            this.measureIndexes4Merge = dataSet4Aggregation.getMetaInfo().getMeasureIndex(this.simpleFunc.getMeasureName());
            this.parameterColIndex4Merge = AggregationUtil.needDataField(AggregationManager.getInstance().getAggregation(this.simpleFunc.getFunctionName())) ? AggregationExecutor.find(this.paraColumns, this.simpleFunc.getParaCol()) : -1;
        }
        this.sortedFactRows = new DiskSortedStackWrapper[aggregations.length];
        this.getAggregationLevelIndex();
        logger.exiting(AggregationExecutor.class.getName(), "AggregationExecutor");
    }

    private static boolean existReferenceDate(AggregationDefinition[] aggregations) throws DataException {
        int i = 0;
        while (i < aggregations.length) {
            AggregationFunctionDefinition[] aggrFunc = aggregations[i].getAggregationFunctions();
            if (aggrFunc != null) {
                int j = 0;
                while (j < aggrFunc.length) {
                    if (aggrFunc[j].getTimeFunction() != null && aggrFunc[j].getTimeFunction().getReferenceDate() != null || aggrFunc[j].getTimeFunctionFilter() != null && aggrFunc[j].getTimeFunctionFilter().getReferenceDate() != null) {
                        return true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }

    private static int find(DimColumn[] colArray, DimColumn col) {
        if (colArray == null || col == null) {
            return -1;
        }
        int i = 0;
        while (i < colArray.length) {
            if (col.equals(colArray[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AggregationFunctionDefinition getSimpleFunction(AggregationDefinition[] aggregations) throws DataException {
        AggregationFunctionDefinition func = null;
        int i = 0;
        while (i < aggregations.length) {
            AggregationFunctionDefinition[] aggrFunc = aggregations[i].getAggregationFunctions();
            if (aggrFunc != null) {
                int j = 0;
                while (j < aggrFunc.length) {
                    if (func == null && aggrFunc[j].getFilterEvalHelper() == null) {
                        func = aggrFunc[j];
                    } else if (func != null && !AggregationExecutor.equal(func, aggrFunc[j])) {
                        return null;
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (func == null) return null;
        if (!AggregationExecutor.isSimepleFunction(func.getFunctionName())) return null;
        if (this.existReferenceDate) return null;
        String mesureName = func.getMeasureName();
        try {
            MeasureInfo[] infos;
            MeasureInfo[] measureInfoArray = infos = this.dataSet4Aggregation.getMetaInfo().getMeasureInfos();
            int n = infos.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return func;
                }
                MeasureInfo info = measureInfoArray[n2];
                if (info.getMeasureName().equals(mesureName) && "SUM".equals(func.getFunctionName()) && 3 == info.getDataType()) {
                    return null;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return func;
    }

    private static boolean equal(AggregationFunctionDefinition func1, AggregationFunctionDefinition func2) {
        if (!(ComparatorUtil.isEqualObject(func1.getFunctionName(), func2.getFunctionName()) && ComparatorUtil.isEqualObject(func1.getMeasureName(), func2.getMeasureName()) && ComparatorUtil.isEqualObject(func1.getParaCol(), func2.getParaCol()) && ComparatorUtil.isEqualObject(func1.getParaValue(), func2.getParaValue()))) {
            return false;
        }
        return func1.getFilterEvalHelper() == null && func2.getFilterEvalHelper() == null;
    }

    private static boolean isSimepleFunction(String funcName) {
        int i = 0;
        while (i < simpleFuncNames.length) {
            if (simpleFuncNames[i].equals(funcName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public IAggregationResultSet[] execute(StopSign stopSign) throws IOException, DataException {
        this.populateSortedFactRows(stopSign);
        int i = 0;
        while (i < this.allSortedFactRows.size()) {
            DiskSortedStackWrapper diskSortedStackWrapper = (DiskSortedStackWrapper)this.allSortedFactRows.get(i);
            int[] calculatorIndexs = new int[this.sortedFactRows.length];
            int pos = 0;
            int j = 0;
            while (j < calculatorIndexs.length) {
                if (this.sortedFactRows[j] == diskSortedStackWrapper) {
                    calculatorIndexs[pos] = j;
                    ++pos;
                }
                ++j;
            }
            while (diskSortedStackWrapper.pop() != null && !stopSign.isStopped()) {
                Row4Aggregation row = (Row4Aggregation)diskSortedStackWrapper.getCurrentObject();
                int j2 = 0;
                while (j2 < pos) {
                    if (this.timeFunctionCalculator[calculatorIndexs[j2]].existTimeFunction()) {
                        this.timeFunctionCalculator[calculatorIndexs[j2]].onRow(row);
                    }
                    this.aggregationCalculators[calculatorIndexs[j2]].onRow(row);
                    ++j2;
                }
            }
            ++i;
        }
        IAggregationResultSet[] resultSets = new IAggregationResultSet[this.aggregationCalculators.length];
        boolean needPopulateMissingAggrResultSetRow = false;
        int i2 = 0;
        while (i2 < this.aggregationCalculators.length) {
            resultSets[i2] = new AggregationResultSet(this.aggregationCalculators[i2].aggregation, this.aggregationCalculators[i2].getResult(), this.getKeyNames(i2), this.getAttributeNames(i2));
            if (this.timeFunctionCalculator[i2].existTimeFunction()) {
                needPopulateMissingAggrResultSetRow = true;
            }
            ++i2;
        }
        if (needPopulateMissingAggrResultSetRow) {
            this.populateMissingAggrResultSetRows(resultSets);
        }
        i2 = 0;
        while (i2 < this.aggregationCalculators.length) {
            if (this.timeFunctionCalculator[i2].existTimeFunction()) {
                List<TimeResultRow> timeResultSet = this.timeFunctionCalculator[i2].getAggregationResultSet(resultSets[i2]);
                ((AggregationResultSet)resultSets[i2]).addTimeFunctionResultSet(timeResultSet);
            }
            ++i2;
        }
        this.dataSet4Aggregation.close();
        return resultSets;
    }

    private void populateEdgeMember(List<Member[]> edgeMember, IAggregationResultSet rs) throws IOException {
        int i = 0;
        while (i < rs.length()) {
            rs.seek(i);
            edgeMember.add(rs.getCurrentRow().getLevelMembers());
            ++i;
        }
    }

    private void populateMissingAggrResultSetRows(IAggregationResultSet[] rs) throws IOException {
        if (rs.length <= 2 || rs[0].getAggregationDefinition().getAggregationFunctions() != null || rs[1].getAggregationDefinition().getAggregationFunctions() != null) {
            return;
        }
        DimLevel[] edgeDimLevel1 = rs[0].getAllLevels();
        DimLevel[] edgeDimLevel2 = rs[1].getAllLevels();
        ArrayList<Member[]> edgeMember1 = new ArrayList<Member[]>();
        ArrayList<Member[]> edgeMember2 = new ArrayList<Member[]>();
        this.populateEdgeMember(edgeMember1, rs[0]);
        this.populateEdgeMember(edgeMember2, rs[1]);
        int i = 2;
        while (i < rs.length) {
            int[] coverLength;
            DimLevel[] dims;
            if (this.timeFunctionCalculator[i].existTimeFunction() && (dims = rs[i].getAllLevels()).length <= edgeDimLevel1.length + edgeDimLevel2.length && (coverLength = this.getTargetDimLevelCoverageOnEdges(dims, edgeDimLevel1, edgeDimLevel2))[0] != -1) {
                List<Member[]> targetMemberList = null;
                targetMemberList = coverLength[0] == 1 ? this.getTargetMemberList(edgeMember1, edgeMember2, coverLength) : this.getTargetMemberList(edgeMember2, edgeMember1, coverLength);
                BufferedStructureArray allRows = new BufferedStructureArray(AggregationResultRow.getCreator(), targetMemberList.size());
                int currentSeekRow = 0;
                int j = 0;
                while (j < targetMemberList.size()) {
                    Member[] currentTargetMember = targetMemberList.get(j);
                    if (currentSeekRow >= rs[i].length()) {
                        allRows.add(new AggregationResultRow(currentTargetMember, new Object[rs[i].getAggregationCount()]));
                    } else {
                        rs[i].seek(currentSeekRow);
                        IAggregationResultRow row = rs[i].getCurrentRow();
                        Member[] currentSeekMember = row.getLevelMembers();
                        if (this.isSameWithCurrentTargetMember(currentSeekMember, currentTargetMember)) {
                            allRows.add(row);
                            ++currentSeekRow;
                        } else {
                            allRows.add(new AggregationResultRow(currentTargetMember, new Object[rs[i].getAggregationCount()]));
                        }
                    }
                    ++j;
                }
                AggregationResultSet rsRow = new AggregationResultSet(rs[i].getAggregationDefinition(), rs[i].getAllLevels(), allRows, rs[i].getKeyNames(), rs[i].getAttributeNames());
                rs[i] = rsRow;
            }
            ++i;
        }
    }

    private boolean isSameWithCurrentTargetMember(Member[] currentSeekMember, Member[] currentTargetMember) {
        int i = 0;
        while (i < currentSeekMember.length) {
            if (!currentSeekMember[i].equals(currentTargetMember[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean existInTargetMemberArray(Member[] member, List<Member[]> list) {
        int i = 0;
        while (i < list.size()) {
            if (this.isSameWithCurrentTargetMember(list.get(i), member)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Member[] getMergedMembers(Member[] candidateMember1, Member[] candidateMember2) {
        Member[] targetCombinedMember = new Member[candidateMember1.length + candidateMember2.length];
        System.arraycopy(candidateMember1, 0, targetCombinedMember, 0, candidateMember1.length);
        System.arraycopy(candidateMember2, 0, targetCombinedMember, candidateMember1.length, candidateMember2.length);
        return targetCombinedMember;
    }

    private List<Member[]> getTargetMemberList(List<Member[]> edgeMember1, List<Member[]> edgeMember2, int[] coverLength) {
        ArrayList<Member[]> targetMemberArray = new ArrayList<Member[]>();
        int a = 0;
        while (a < edgeMember1.size()) {
            int b = 0;
            while (b < edgeMember2.size()) {
                Member[] candidateMember1 = edgeMember1.get(a);
                Member[] candidateMember2 = edgeMember2.get(b);
                if (coverLength[1] != candidateMember1.length || coverLength[2] != candidateMember2.length) {
                    Member[] targetCombinedMember = this.getMergedMembers(candidateMember1 = this.getTrimmedMembers(candidateMember1, coverLength[1]), candidateMember2 = this.getTrimmedMembers(candidateMember2, coverLength[2]));
                    if (!this.existInTargetMemberArray(targetCombinedMember, targetMemberArray)) {
                        targetMemberArray.add(targetCombinedMember);
                    }
                } else {
                    Member[] targetMember = this.getMergedMembers(candidateMember1, candidateMember2);
                    targetMemberArray.add(targetMember);
                }
                ++b;
            }
            ++a;
        }
        return targetMemberArray;
    }

    private Member[] getTrimmedMembers(Member[] member, int length) {
        Member[] target = new Member[length];
        int i = 0;
        while (i < length) {
            target[i] = member[i];
            ++i;
        }
        return target;
    }

    private int[] getTargetDimLevelCoverageOnEdges(DimLevel[] dims, DimLevel[] edgeDimLevel1, DimLevel[] edgeDimLevel2) {
        int[] coverDimLevelLength = new int[3];
        coverDimLevelLength[0] = -1;
        if (dims[0].equals(edgeDimLevel1[0])) {
            int i = 0;
            while (i < edgeDimLevel1.length && i < dims.length) {
                if (!dims[i].equals(edgeDimLevel1[i])) {
                    if (!dims[i].equals(edgeDimLevel2[0])) {
                        return coverDimLevelLength;
                    }
                    coverDimLevelLength[1] = i + 1;
                    break;
                }
                ++i;
            }
            if (i <= edgeDimLevel1.length) {
                coverDimLevelLength[1] = i;
            }
            int j = 0;
            while (j < edgeDimLevel2.length) {
                if (i >= dims.length) break;
                if (!dims[i].equals(edgeDimLevel2[j])) {
                    return coverDimLevelLength;
                }
                ++j;
                ++i;
            }
            coverDimLevelLength[2] = j;
            coverDimLevelLength[0] = 1;
            return coverDimLevelLength;
        }
        if (dims[0].equals(edgeDimLevel2[0])) {
            int i = 0;
            while (i < edgeDimLevel2.length && i < dims.length) {
                if (!dims[i].equals(edgeDimLevel2[i])) {
                    if (!dims[i].equals(edgeDimLevel1[0])) {
                        return coverDimLevelLength;
                    }
                    coverDimLevelLength[1] = i;
                    break;
                }
                ++i;
            }
            if (i <= edgeDimLevel2.length) {
                coverDimLevelLength[1] = i;
            }
            int j = 0;
            while (j < edgeDimLevel1.length) {
                if (i >= dims.length) break;
                if (!dims[i].equals(edgeDimLevel1[j])) {
                    return coverDimLevelLength;
                }
                ++j;
                ++i;
            }
            coverDimLevelLength[2] = j;
            coverDimLevelLength[0] = 0;
            return coverDimLevelLength;
        }
        return coverDimLevelLength;
    }

    private String[][] getKeyNames(int aggregationIndex) {
        String[][] result = new String[this.levelIndex[aggregationIndex].length / 2][];
        int[] tmpLevelIndex = this.levelIndex[aggregationIndex];
        int i = 0;
        while (i < this.levelIndex[aggregationIndex].length / 2) {
            result[i] = this.dataSet4Aggregation.getMetaInfo().getKeyNames(tmpLevelIndex[i * 2], tmpLevelIndex[i * 2 + 1]);
            ++i;
        }
        return result;
    }

    private String[][] getAttributeNames(int aggregationIndex) {
        String[][] result = new String[this.levelIndex[aggregationIndex].length / 2][];
        int[] tmpLevelIndex = this.levelIndex[aggregationIndex];
        int i = 0;
        while (i < this.levelIndex[aggregationIndex].length / 2) {
            result[i] = this.dataSet4Aggregation.getMetaInfo().getAttributeNames(tmpLevelIndex[i * 2], tmpLevelIndex[i * 2 + 1]);
            ++i;
        }
        return result;
    }

    private void populateSortedFactRows(StopSign stopSign) throws IOException, DataException {
        this.prepareSortedStacks();
        int measureCount = this.dataSet4Aggregation.getMetaInfo().getMeasureInfos().length;
        int factRowCount = 0;
        if (this.aggregationRow == null) {
            this.aggregationRow = new Row4Aggregation[this.allSortedFactRows.size()];
        }
        DiskSortedStackWrapper[] diskSortedStackWrapper = new DiskSortedStackWrapper[this.allSortedFactRows.size()];
        int i = 0;
        while (i < this.allSortedFactRows.size()) {
            diskSortedStackWrapper[i] = (DiskSortedStackWrapper)this.allSortedFactRows.get(i);
            ++i;
        }
        try {
            while (this.dataSet4Aggregation.next() && !stopSign.isStopped()) {
                i = 0;
                while (i < this.allSortedFactRows.size()) {
                    int[] levelIndex = diskSortedStackWrapper[i].levelIndex;
                    if (!this.dataSet4Aggregation.isDuplicatedRow()) {
                        Member[] members = this.getLevelMembers(levelIndex);
                        if (this.aggregationRow[i] != null) {
                            if (this.existReferenceDate) {
                                diskSortedStackWrapper[i].diskSortedStack.push(this.aggregationRow[i]);
                            } else {
                                Row4Aggregation popRow = this.mergeRow4Aggregations[i].push(this.aggregationRow[i]);
                                if (popRow != null) {
                                    diskSortedStackWrapper[i].diskSortedStack.push(popRow);
                                }
                            }
                        }
                        this.aggregationRow[i] = this.createRow4Aggregation();
                        this.aggregationRow[i].setLevelMembers(members);
                        if (this.aggregationRow[i].getLevelMembers() != null) {
                            this.aggregationRow[i].setMeasures(new Object[measureCount]);
                            int j = 0;
                            while (j < measureCount) {
                                this.aggregationRow[i].getMeasures()[j] = this.dataSet4Aggregation.getMeasureValue(j);
                                ++j;
                            }
                            this.aggregationRow[i].setParameterValues(this.getParameterValues());
                        }
                    } else {
                        Object[] measures = new Object[measureCount];
                        int j = 0;
                        while (j < measureCount) {
                            measures[j] = this.dataSet4Aggregation.getMeasureValue(j);
                            ++j;
                        }
                        this.aggregationRow[i].addMeasure(measures);
                        this.addPosition(this.aggregationRow[i]);
                    }
                    ++i;
                }
                if (this.maxDataObjectRows <= 0 || ++factRowCount <= this.maxDataObjectRows) continue;
                throw new DataException("data.engine.exceed.max.data.object.row");
            }
            i = 0;
            while (i < this.allSortedFactRows.size()) {
                if (this.aggregationRow[i] != null) {
                    if (this.existReferenceDate) {
                        diskSortedStackWrapper[i].diskSortedStack.push(this.aggregationRow[i]);
                    } else {
                        Row4Aggregation popRow = this.mergeRow4Aggregations[i].push(this.aggregationRow[i]);
                        if (popRow != null) {
                            diskSortedStackWrapper[i].diskSortedStack.push(popRow);
                        }
                    }
                }
                if (!this.existReferenceDate) {
                    List<Row4Aggregation> remainRows = this.mergeRow4Aggregations[i].getAll();
                    int j = 0;
                    while (j < remainRows.size()) {
                        diskSortedStackWrapper[i].diskSortedStack.push(remainRows.get(j));
                        ++j;
                    }
                    this.mergeRow4Aggregations[i] = null;
                }
                ++i;
            }
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
    }

    protected Row4Aggregation createRow4Aggregation() {
        Row4Aggregation aggregationRow = new Row4Aggregation();
        aggregationRow.setDimPos(this.dataSet4Aggregation.getDimensionPosition());
        return aggregationRow;
    }

    protected void addPosition(Row4Aggregation aggregationRow) {
    }

    Member[] getLevelMembers(int[] levelIndex) throws BirtException, IOException {
        Member[] result = new Member[levelIndex.length / 2];
        int i = 0;
        while (i < result.length) {
            int dim = levelIndex[i * 2];
            int level = levelIndex[i * 2 + 1];
            result[i] = this.dataSet4Aggregation.getMember(dim, level);
            if (result[i] == null) {
                return null;
            }
            ++i;
        }
        return result;
    }

    Object[] getParameterValues() throws BirtException, IOException {
        if (this.paraInfos == null || this.paraInfos.length == 0) {
            return null;
        }
        Object[] reValues = new Object[this.paraInfos.length];
        int i = 0;
        while (i < reValues.length) {
            Member member = this.dataSet4Aggregation.getMember(this.paraInfos[i].getDimIndex(), this.paraInfos[i].getLevelIndex());
            reValues[i] = this.paraInfos[i].isKey() ? member.getKeyValues()[this.paraInfos[i].getColumnIndex()] : member.getAttributes()[this.paraInfos[i].getColumnIndex()];
            ++i;
        }
        return reValues;
    }

    private void prepareSortedStacks() throws DataException, IOException {
        this.allSortedFactRows = new ArrayList();
        int levelSize = 0;
        int measureSize = 0;
        block0: while (true) {
            int maxLevelCount = -1;
            int aggregationIndex = -1;
            int[] levelSortType = null;
            int i = 0;
            while (i < this.aggregationCalculators.length) {
                if (this.sortedFactRows[i] == null && (this.aggregationCalculators[i].aggregation.getLevels() != null && this.aggregationCalculators[i].aggregation.getLevels().length > maxLevelCount || this.aggregationCalculators[i].aggregation.getLevels() == null && maxLevelCount == -1)) {
                    aggregationIndex = i;
                    maxLevelCount = this.aggregationCalculators[i].aggregation.getLevels() != null ? this.aggregationCalculators[i].aggregation.getLevels().length : 0;
                    levelSortType = this.aggregationCalculators[i].aggregation.getSortTypes();
                }
                ++i;
            }
            if (aggregationIndex == -1) break;
            if (this.memoryCacheSize != 0L) {
                if (levelSize == 0) {
                    levelSize = this.getLevelSize(this.aggregationCalculators[aggregationIndex].aggregation.getLevels());
                } else if (this.aggregationCalculators[aggregationIndex].aggregation.getLevels() != null) {
                    levelSize += SizeOfUtil.getArraySize(this.aggregationCalculators[aggregationIndex].aggregation.getLevels().length);
                }
                if (measureSize == 0) {
                    measureSize = this.getMeasureSize();
                } else if (this.dataSet4Aggregation.getMetaInfo().getMeasureInfos() != null) {
                    measureSize += SizeOfUtil.getArraySize(this.dataSet4Aggregation.getMetaInfo().getMeasureInfos().length);
                }
            }
            Row4AggregationComparator comparator = new Row4AggregationComparator(levelSortType);
            DiskSortedStack diskSortedStack = new DiskSortedStack(100, false, comparator, Row4Aggregation.getCreator());
            if (this.memoryCacheSize == 0L) {
                diskSortedStack.setBufferSize(10000);
                diskSortedStack.setUseMemoryOnly(true);
            }
            DiskSortedStackWrapper diskSortedStackReader = new DiskSortedStackWrapper(diskSortedStack, this.levelIndex[aggregationIndex]);
            this.allSortedFactRows.add(diskSortedStackReader);
            int i2 = 0;
            while (true) {
                if (i2 >= this.aggregationCalculators.length) continue block0;
                if (this.sortedFactRows[i2] == null && AggregationExecutor.cover(this.levelIndex[aggregationIndex], this.levelIndex[i2])) {
                    this.sortedFactRows[i2] = diskSortedStackReader;
                }
                ++i2;
            }
            break;
        }
        this.mergeRow4Aggregations = new MergeRow4Aggregation[this.allSortedFactRows.size()];
        int bufferSize = 10000;
        if (this.memoryCacheSize > 0L) {
            int rowSize = 16 + (4 + (levelSize + measureSize) - 1) / 8 * 8;
            bufferSize = (int)(this.memoryCacheSize * 4L / 5L / (long)rowSize);
            if (!this.existReferenceDate && this.simpleFunc == null) {
                bufferSize /= 5;
            }
            int i = 0;
            while (i < this.allSortedFactRows.size()) {
                DiskSortedStackWrapper diskSortedStackReader = (DiskSortedStackWrapper)this.allSortedFactRows.get(i);
                diskSortedStackReader.getDiskSortedStack().setBufferSize(bufferSize);
                ++i;
            }
        }
        int i = 0;
        while (i < this.allSortedFactRows.size()) {
            this.mergeRow4Aggregations[i] = new MergeRow4Aggregation(bufferSize, this.simpleFunc, this.measureIndexes4Merge, this.parameterColIndex4Merge);
            ++i;
        }
    }

    private int getMeasureSize() throws IOException {
        MeasureInfo[] measureInfo = this.dataSet4Aggregation.getMetaInfo().getMeasureInfos();
        if (measureInfo == null || measureInfo.length == 0) {
            return 0;
        }
        int[] dataType = new int[measureInfo.length];
        int i = 0;
        while (i < measureInfo.length) {
            dataType[i] = measureInfo[i].getDataType();
            ++i;
        }
        return SizeOfUtil.getObjectSize(dataType);
    }

    private int getLevelSize(DimLevel[] dimLevel) throws DataException {
        if (dimLevel == null || dimLevel.length == 0) {
            return 0;
        }
        int[] dataType = new int[dimLevel.length];
        int i = 0;
        while (i < dimLevel.length) {
            DimColumn dimColumn = null;
            dimColumn = dimLevel[i].getAttrName() == null ? new DimColumn(dimLevel[i].getDimensionName(), dimLevel[i].getLevelName(), dimLevel[i].getLevelName()) : new DimColumn(dimLevel[i].getDimensionName(), dimLevel[i].getLevelName(), dimLevel[i].getAttrName());
            ColumnInfo columnInfo = this.dataSet4Aggregation.getMetaInfo().getColumnInfo(dimColumn);
            dataType[i] = columnInfo.getDataType();
            ++i;
        }
        return SizeOfUtil.getObjectSize(dataType);
    }

    private static boolean cover(int[] dimensionIndex1, int[] dimensionIndex2) {
        if (dimensionIndex2 == null || dimensionIndex2.length == 0) {
            return true;
        }
        if (dimensionIndex1.length < dimensionIndex2.length) {
            return false;
        }
        int i = 0;
        while (i < dimensionIndex2.length) {
            if (dimensionIndex1[i] != dimensionIndex2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void getAggregationLevelIndex() throws DataException {
        if (this.aggregationCalculators == null) {
            return;
        }
        this.levelIndex = new int[this.aggregationCalculators.length][];
        int i = 0;
        while (i < this.aggregationCalculators.length) {
            DimLevel[] levels = this.aggregationCalculators[i].aggregation.getLevels();
            if (levels == null || levels.length == 0) {
                this.levelIndex[i] = new int[0];
            } else {
                int[] tmpLevelIndex = new int[levels.length * 2];
                int j = 0;
                while (j < tmpLevelIndex.length / 2) {
                    String dimensionName = levels[j].getDimensionName();
                    String levelName = levels[j].getLevelName();
                    int dimIndex = this.dataSet4Aggregation.getMetaInfo().getDimensionIndex(dimensionName);
                    if (dimIndex < 0) {
                        throw new DataException(String.valueOf(DataResourceHandle.getInstance().getMessage("data.olap.NonexistentDimension")) + dimensionName);
                    }
                    int levelIndex = this.dataSet4Aggregation.getMetaInfo().getLevelIndex(dimensionName, levelName);
                    if (levelIndex < 0) {
                        throw new DataException(String.valueOf(DataResourceHandle.getInstance().getMessage("data.olap.NonexistentLevel")) + "<" + dimensionName + " , " + levelName + ">");
                    }
                    tmpLevelIndex[j * 2] = dimIndex;
                    tmpLevelIndex[j * 2 + 1] = levelIndex;
                    ++j;
                }
                this.levelIndex[i] = tmpLevelIndex;
            }
            ++i;
        }
    }

    private void getParameterColIndex(AggregationDefinition[] aggregations) throws DataException {
        HashSet<DimColumn> paraCols = new HashSet<DimColumn>();
        int i = 0;
        while (i < aggregations.length) {
            AggregationFunctionDefinition[] functions = aggregations[i].getAggregationFunctions();
            if (functions != null) {
                int j = 0;
                while (j < functions.length) {
                    DimColumn paraCol = functions[j].getParaCol();
                    if (paraCol != null) {
                        paraCols.add(paraCol);
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (paraCols.size() == 0) {
            return;
        }
        this.paraColumns = new DimColumn[paraCols.size()];
        paraCols.toArray(this.paraColumns);
        this.paraInfos = new ColumnInfo[this.paraColumns.length];
        this.findColumnIndex();
    }

    private void findColumnIndex() throws DataException {
        if (this.paraColumns == null) {
            return;
        }
        IDataSet4Aggregation.MetaInfo metaInfo = this.dataSet4Aggregation.getMetaInfo();
        int i = 0;
        while (i < this.paraColumns.length) {
            this.paraInfos[i] = metaInfo.getColumnInfo(this.paraColumns[i]);
            ++i;
        }
    }

    public void setMaxDataObjectRows(int rowSize) {
        this.maxDataObjectRows = rowSize;
    }

    public int getMaxDataObjectRows() {
        return this.maxDataObjectRows;
    }

    public void setMemoryCacheSize(long memoryCacheSize) {
        this.memoryCacheSize = memoryCacheSize;
    }

    public int getMemoryCacheSize(int memoryCacheSize) {
        return memoryCacheSize;
    }
}

