/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.diag;

import java.sql.ResultSetMetaData;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Vector;
import org.apache.derby.diag.DiagUtil;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.CacheManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.jdbc.EmbedResultSetMetaData;
import org.apache.derby.impl.sql.GenericPreparedStatement;
import org.apache.derby.impl.sql.GenericStatement;
import org.apache.derby.impl.sql.conn.CachedStatement;
import org.apache.derby.vti.VTITemplate;

public final class StatementCache
extends VTITemplate {
    private int position = -1;
    private Vector<GenericPreparedStatement> data;
    private GenericPreparedStatement currentPs;
    private boolean wasNull;
    private static final ResultColumnDescriptor[] columnInfo = new ResultColumnDescriptor[]{EmbedResultSetMetaData.getResultColumnDescriptor("ID", 1, false, 36), EmbedResultSetMetaData.getResultColumnDescriptor("SCHEMANAME", 12, true, 128), EmbedResultSetMetaData.getResultColumnDescriptor("SQL_TEXT", 12, false, 32672), EmbedResultSetMetaData.getResultColumnDescriptor("UNICODE", -7, false), EmbedResultSetMetaData.getResultColumnDescriptor("VALID", -7, false), EmbedResultSetMetaData.getResultColumnDescriptor("COMPILED_AT", 93, true)};
    private static final ResultSetMetaData metadata = new EmbedResultSetMetaData(columnInfo);

    public StatementCache() throws StandardException {
        DiagUtil.checkAccess();
        LanguageConnectionContext languageConnectionContext = (LanguageConnectionContext)ContextService.getContextOrNull("LanguageConnectionContext");
        CacheManager cacheManager = languageConnectionContext.getLanguageConnectionFactory().getStatementCache();
        if (cacheManager != null) {
            Collection collection = cacheManager.values();
            this.data = new Vector(collection.size());
            for (CachedStatement cachedStatement : collection) {
                GenericPreparedStatement genericPreparedStatement = cachedStatement.getPreparedStatement();
                this.data.add(genericPreparedStatement);
            }
        }
    }

    @Override
    public boolean next() {
        if (this.data == null) {
            return false;
        }
        ++this.position;
        while (this.position < this.data.size()) {
            this.currentPs = this.data.get(this.position);
            if (this.currentPs != null) {
                return true;
            }
            ++this.position;
        }
        this.data = null;
        return false;
    }

    @Override
    public void close() {
        this.data = null;
        this.currentPs = null;
    }

    @Override
    public String getString(int n) {
        this.wasNull = false;
        switch (n) {
            case 1: {
                return this.currentPs.getObjectName();
            }
            case 2: {
                return ((GenericStatement)this.currentPs.statement).getCompilationSchema();
            }
            case 3: {
                String string = this.currentPs.getSource();
                string = StringUtil.truncate(string, 32672);
                return string;
            }
        }
        return null;
    }

    @Override
    public boolean getBoolean(int n) {
        this.wasNull = false;
        switch (n) {
            case 4: {
                return true;
            }
            case 5: {
                return this.currentPs.isValid();
            }
        }
        return false;
    }

    @Override
    public Timestamp getTimestamp(int n) {
        Timestamp timestamp = this.currentPs.getEndCompileTimestamp();
        this.wasNull = timestamp == null;
        return timestamp;
    }

    @Override
    public boolean wasNull() {
        return this.wasNull;
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return metadata;
    }
}

