/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.odf.style;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.engine.odf.style.StyleEntry;

public class StyleManager {
    private static final int MAX_TYPES = 8;
    private int[] lastIndex;
    private static final String[] styleNamePrefix = new String[]{"P", "T", "Table", "Column", "Row", "Cell", "Mpm", "Draw"};
    private Map<StyleEntry, String> styleToName;
    private List<StyleEntry> styleList;
    private String namePrefix;

    public StyleManager(String namePrefix) {
        this.namePrefix = namePrefix != null ? namePrefix : "";
        this.lastIndex = new int[8];
        int i = 0;
        while (i < 8) {
            this.lastIndex[i] = 0;
            ++i;
        }
        this.styleToName = new HashMap<StyleEntry, String>();
        this.styleList = new ArrayList<StyleEntry>();
    }

    public Collection<StyleEntry> getStyles() {
        return Collections.unmodifiableCollection(this.styleList);
    }

    public String addStyle(StyleEntry style) {
        return this.addStyle(null, style);
    }

    public String addStyle(String prefix, StyleEntry newStyleEntry) {
        if (newStyleEntry == null) {
            return null;
        }
        String existingStyleName = this.styleToName.get(newStyleEntry);
        if (existingStyleName != null && (prefix == null || existingStyleName.startsWith(prefix))) {
            newStyleEntry.setName(existingStyleName);
            return existingStyleName;
        }
        newStyleEntry.setName(this.generateName(prefix, newStyleEntry.getType()));
        newStyleEntry = (StyleEntry)newStyleEntry.clone();
        this.styleToName.put(newStyleEntry, newStyleEntry.getName());
        this.styleList.add(newStyleEntry);
        return newStyleEntry.getName();
    }

    private String generateName(String prefix, int type) {
        if (prefix == null) {
            prefix = "";
        }
        String stylePrefix = "Dummy";
        if (type < 0 || type > 8) {
            return "";
        }
        stylePrefix = styleNamePrefix[type];
        int n = type;
        this.lastIndex[n] = this.lastIndex[n] + 1;
        return String.valueOf(prefix) + this.namePrefix + stylePrefix + this.lastIndex[type];
    }
}

