/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.base.catalog;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.enablement.sybase.asa.JDBCASAPlugin;
import org.eclipse.datatools.enablement.sybase.asa.catalog.SybaseASACatalogUtils;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.AllowNullType;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.TypeOfDefault;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.impl.SybaseASABaseUserDefinedTypeImpl;
import org.eclipse.datatools.modelbase.sql.constraints.CheckConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.SQLConstraintsFactory;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.expressions.SQLExpressionsFactory;
import org.eclipse.datatools.modelbase.sql.expressions.SearchCondition;
import org.eclipse.datatools.modelbase.sql.expressions.SearchConditionDefault;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SybaseASACatalogBaseUserDefinedDataType
extends SybaseASABaseUserDefinedTypeImpl
implements ICatalogObject,
IAdaptable {
    public static final int BATCH_LOAD_THRESHHOLD = 10;
    private static final long serialVersionUID = 1757200934996274093L;
    protected Boolean UDTInfoLoaded = Boolean.FALSE;

    public Database getCatalogDatabase() {
        return this.getSchema().getCatalog().getDatabase();
    }

    public Connection getConnection() {
        return ((ICatalogObject)this.getCatalogDatabase()).getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Boolean bl = this.UDTInfoLoaded;
        synchronized (bl) {
            if (this.UDTInfoLoaded.booleanValue()) {
                this.UDTInfoLoaded = Boolean.FALSE;
            }
        }
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 10: {
                this.getPredefinedRepresentation();
                break;
            }
            case 14: {
                this.getDefaultType();
                break;
            }
            case 12: {
                this.getDefaultValue();
                break;
            }
            case 13: {
                this.getNullable();
            }
        }
        return super.eIsSet(eFeature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PredefinedDataType getPredefinedRepresentation() {
        Boolean bl = this.UDTInfoLoaded;
        synchronized (bl) {
            if (!this.UDTInfoLoaded.booleanValue()) {
                this.loadUDTInfo();
                this.UDTInfoLoaded = Boolean.TRUE;
            }
        }
        return super.getPredefinedRepresentation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeOfDefault getDefaultType() {
        Boolean bl = this.UDTInfoLoaded;
        synchronized (bl) {
            if (!this.UDTInfoLoaded.booleanValue()) {
                this.loadUDTInfo();
                this.UDTInfoLoaded = Boolean.TRUE;
            }
        }
        return super.getDefaultType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AllowNullType getNullable() {
        Boolean bl = this.UDTInfoLoaded;
        synchronized (bl) {
            if (!this.UDTInfoLoaded.booleanValue()) {
                this.loadUDTInfo();
                this.UDTInfoLoaded = Boolean.TRUE;
            }
        }
        return super.getNullable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDefaultValue() {
        Boolean bl = this.UDTInfoLoaded;
        synchronized (bl) {
            if (!this.UDTInfoLoaded.booleanValue()) {
                this.loadUDTInfo();
                this.UDTInfoLoaded = Boolean.TRUE;
            }
        }
        return super.getDefaultValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getConstraint() {
        Boolean bl = this.UDTInfoLoaded;
        synchronized (bl) {
            if (!this.UDTInfoLoaded.booleanValue()) {
                this.loadUDTInfo();
                this.UDTInfoLoaded = Boolean.TRUE;
            }
        }
        return super.getConstraint();
    }

    public EList getSuperConstraint() {
        return super.getConstraint();
    }

    private List getAllUDTs() {
        ArrayList allUDTs = new ArrayList();
        for (Schema s : this.getSchema().getDatabase().getSchemas()) {
            allUDTs.addAll(s.getUserDefinedTypes());
        }
        return allUDTs;
    }

    private boolean needBatchLoad(List allUDTs) {
        int numOfUDTNotLoaded = 0;
        for (SybaseASACatalogBaseUserDefinedDataType udt : allUDTs) {
            if (udt.UDTInfoLoaded.booleanValue() || ++numOfUDTNotLoaded < 10) continue;
            return true;
        }
        return false;
    }

    protected void loadUDTInfo() {
        boolean deliver;
        block6: {
            deliver = this.eDeliver();
            this.eSetDeliver(false);
            List allUDTs = this.getAllUDTs();
            boolean needBatchLoadStrategy = this.needBatchLoad(allUDTs);
            Connection conn = this.getConnection();
            Statement stmt = null;
            ResultSet rs = null;
            try {
                try {
                    rs = this.createUDTInfoResultSet(conn, needBatchLoadStrategy);
                    stmt = rs.getStatement();
                    while (rs.next()) {
                        this.processUDTInfoResultSet(rs, allUDTs);
                    }
                }
                catch (SQLException e) {
                    JDBCASAPlugin.getDefault().log(e);
                    SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
                throw throwable;
            }
            SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
        }
        this.eSetDeliver(deliver);
    }

    protected AllowNullType getNullType(char charNull) {
        switch (charNull) {
            case 'Y': {
                return AllowNullType.NULLABLE_LITERAL;
            }
            case 'N': {
                return AllowNullType.NOT_NULLABLE_LITERAL;
            }
        }
        return AllowNullType.DATABASE_DEFAULT_LITERAL;
    }

    protected ResultSet createUDTInfoResultSet(Connection conn, boolean needBatchLoadStrategy) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(needBatchLoadStrategy ? "SELECT TRIM(T.type_name) as type_name, TRIM(U.user_name) as user_name, TRIM(D.domain_name), T.width, T.scale, T.\"nulls\", T.\"default\", T.\"check\" FROM SYS.SYSUSERTYPE T JOIN SYS.SYSUSERPERMS U ON U.user_id = T.creator JOIN SYS.SYSDOMAIN D ON D.domain_id = T.domain_id WHERE D.domain_name <> 'java.lang.Object'" : "SELECT TRIM(T.type_name) as type_name, TRIM(U.user_name) as user_name, TRIM(D.domain_name), T.width, T.scale, T.\"nulls\", T.\"default\", T.\"check\" FROM SYS.SYSUSERTYPE T JOIN SYS.SYSUSERPERMS U ON U.user_id = T.creator JOIN SYS.SYSDOMAIN D ON D.domain_id = T.domain_id WHERE D.domain_name <> 'java.lang.Object' AND T.type_name = ?");
        if (!needBatchLoadStrategy) {
            stmt.setString(1, this.getName());
        }
        return stmt.executeQuery();
    }

    public static SQLObject getSQLObject(List sqlObjs, String objName) {
        for (SQLObject obj : sqlObjs) {
            if (!obj.getName().equals(objName)) continue;
            return obj;
        }
        return null;
    }

    protected void processUDTInfoResultSet(ResultSet rs, List allUDTs) throws SQLException {
        String typeName = rs.getString(1);
        SybaseASACatalogBaseUserDefinedDataType udt = (SybaseASACatalogBaseUserDefinedDataType)SybaseASACatalogBaseUserDefinedDataType.getSQLObject(allUDTs, typeName);
        if (udt == null || udt.UDTInfoLoaded.booleanValue()) {
            return;
        }
        String domainName = rs.getString(3);
        int width = rs.getInt(4);
        int scale = rs.getInt(5);
        char nulls = SybaseASACatalogUtils.getCharValue(rs.getString(6));
        String defaultValue = rs.getString(7);
        String check = rs.getString(8);
        DatabaseDefinition dbDefn = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase());
        PredefinedDataType pdt = SybaseASACatalogUtils.getASAPredefinedType(width, scale, domainName, dbDefn);
        AllowNullType nulltype = this.getNullType(nulls);
        TypeOfDefault td = null;
        if (defaultValue != null) {
            td = SybaseASACatalogUtils.isSystemDefault(defaultValue) ? TypeOfDefault.SYSTEM_DEFINED_LITERAL : TypeOfDefault.USER_DEFINED_LITERAL;
        }
        udt.setPredefinedRepresentation(pdt);
        udt.setNullable(nulltype);
        udt.setDefaultValue(defaultValue);
        udt.setDefaultType(td);
        udt.getSuperConstraint().clear();
        if (check != null && !check.equals("")) {
            CheckConstraint checkContr = SQLConstraintsFactory.eINSTANCE.createCheckConstraint();
            SearchConditionDefault sc = SQLExpressionsFactory.eINSTANCE.createSearchConditionDefault();
            sc.setSQL(check);
            checkContr.setSearchCondition((SearchCondition)sc);
            udt.getSuperConstraint().add((Object)checkContr);
        }
        udt.UDTInfoLoaded = Boolean.TRUE;
    }

    public Object getAdapter(Class adapter) {
        Object adapterObject = Platform.getAdapterManager().getAdapter((Object)this, adapter);
        if (adapterObject == null) {
            adapterObject = Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName());
        }
        return adapterObject;
    }
}

