/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service.template;

import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.prettyprint.cassandra.model.ExecutingKeyspace;
import me.prettyprint.cassandra.model.ExecutionResult;
import me.prettyprint.cassandra.model.HSlicePredicate;
import me.prettyprint.cassandra.model.thrift.ThriftConverter;
import me.prettyprint.cassandra.service.Operation;
import me.prettyprint.cassandra.service.OperationType;
import me.prettyprint.cassandra.service.template.SuperCfResult;
import me.prettyprint.cassandra.service.template.SuperCfResultWrapper;
import me.prettyprint.cassandra.service.template.SuperCfTemplate;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.exceptions.HectorException;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.ColumnParent;

public class ThriftSuperCfTemplate<K, SN, N>
extends SuperCfTemplate<K, SN, N> {
    public ThriftSuperCfTemplate(Keyspace keyspace, String columnFamily, Serializer<K> keySerializer, Serializer<SN> topSerializer, Serializer<N> subSerializer) {
        super(keyspace, columnFamily, keySerializer, topSerializer, subSerializer);
    }

    @Override
    protected SuperCfResult<K, SN, N> doExecuteSlice(K key, SN sColumnName, HSlicePredicate<SN> predicate) {
        SuperCfResultWrapper wrapper = new SuperCfResultWrapper(this.keySerializer, this.topSerializer, this.subSerializer, this.sliceInternal(key, predicate));
        if (sColumnName != null) {
            wrapper.applySuperColumn(sColumnName);
        }
        return wrapper;
    }

    @Override
    protected SuperCfResult<K, SN, N> doExecuteMultigetSlice(List<K> keys, HSlicePredicate<SN> predicate) {
        SuperCfResultWrapper wrapper = new SuperCfResultWrapper(this.keySerializer, this.topSerializer, this.subSerializer, this.multigetSliceInternal(keys, this.columnParent, predicate));
        return wrapper;
    }

    private ExecutionResult<Map<ByteBuffer, List<ColumnOrSuperColumn>>> sliceInternal(final K key, final HSlicePredicate<SN> workingSlicePredicate) {
        return ((ExecutingKeyspace)this.keyspace).doExecuteOperation(new Operation<Map<ByteBuffer, List<ColumnOrSuperColumn>>>(OperationType.READ){

            @Override
            public Map<ByteBuffer, List<ColumnOrSuperColumn>> execute(Cassandra.Client cassandra) throws HectorException {
                LinkedHashMap<ByteBuffer, List<ColumnOrSuperColumn>> cosc = new LinkedHashMap<ByteBuffer, List<ColumnOrSuperColumn>>();
                try {
                    ByteBuffer sKey = ThriftSuperCfTemplate.this.keySerializer.toByteBuffer(key);
                    cosc.put(sKey, cassandra.get_slice(sKey, ThriftSuperCfTemplate.this.columnParent, workingSlicePredicate.toThrift(), ThriftConverter.consistencyLevel(this.consistencyLevelPolicy.get(this.operationType))));
                }
                catch (Exception e) {
                    throw ThriftSuperCfTemplate.this.exceptionsTranslator.translate(e);
                }
                return cosc;
            }
        });
    }

    private ExecutionResult<Map<ByteBuffer, List<ColumnOrSuperColumn>>> multigetSliceInternal(final List<K> keys, final ColumnParent workingColumnParent, final HSlicePredicate<SN> workingSlicePredicate) {
        return ((ExecutingKeyspace)this.keyspace).doExecuteOperation(new Operation<Map<ByteBuffer, List<ColumnOrSuperColumn>>>(OperationType.READ){

            @Override
            public Map<ByteBuffer, List<ColumnOrSuperColumn>> execute(Cassandra.Client cassandra) throws HectorException {
                Map cosc;
                try {
                    List<ByteBuffer> sKeys = ThriftSuperCfTemplate.this.keySerializer.toBytesList(keys);
                    cosc = cassandra.multiget_slice(sKeys, workingColumnParent, workingSlicePredicate.toThrift(), ThriftConverter.consistencyLevel(this.consistencyLevelPolicy.get(this.operationType)));
                }
                catch (Exception e) {
                    throw ThriftSuperCfTemplate.this.exceptionsTranslator.translate(e);
                }
                return cosc;
            }
        });
    }
}

