/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service.template;

import me.prettyprint.hector.api.Serializer;
import org.apache.cassandra.thrift.IndexClause;
import org.apache.cassandra.thrift.IndexExpression;
import org.apache.cassandra.thrift.IndexOperator;

public class IndexedSlicesPredicate<K, N, V> {
    private Serializer<K> keySerializer;
    private Serializer<N> nameSerializer;
    private Serializer<V> valueSerializer;
    private IndexClause indexClause = new IndexClause();

    public IndexedSlicesPredicate(Serializer<K> keySerializer, Serializer<N> nameSerializer, Serializer<V> valueSerializer) {
        this.keySerializer = keySerializer;
        this.nameSerializer = nameSerializer;
        this.valueSerializer = valueSerializer;
    }

    public IndexedSlicesPredicate<K, N, V> count(int count) {
        this.indexClause.setCount(count);
        return this;
    }

    public IndexedSlicesPredicate<K, N, V> startKey(K key) {
        this.indexClause.setStart_key(this.keySerializer.toByteBuffer(key));
        return this;
    }

    public IndexedSlicesPredicate<K, N, V> addExpression(N columnName, IndexOperator op, V value) {
        this.indexClause.addToExpressions(new IndexExpression(this.nameSerializer.toByteBuffer(columnName), op, this.valueSerializer.toByteBuffer(value)));
        return this;
    }

    public IndexClause toThrift() {
        if (!this.indexClause.isSetStart_key()) {
            this.indexClause.setStart_key(new byte[0]);
        }
        return this.indexClause;
    }
}

