/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service.template;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import me.prettyprint.cassandra.model.ExecutionResult;
import me.prettyprint.cassandra.model.HColumnImpl;
import me.prettyprint.cassandra.serializers.ByteBufferSerializer;
import me.prettyprint.cassandra.service.template.AbstractResultWrapper;
import me.prettyprint.cassandra.service.template.ColumnFamilyResult;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.HColumn;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;

public class ColumnFamilyResultWrapper<K, N>
extends AbstractResultWrapper<K, N> {
    private Map<N, HColumn<N, ByteBuffer>> columns;
    private Iterator<Map.Entry<ByteBuffer, List<ColumnOrSuperColumn>>> rows;
    private Map.Entry<ByteBuffer, List<ColumnOrSuperColumn>> entry;
    private boolean hasEntries;

    public ColumnFamilyResultWrapper(Serializer<K> keySerializer, Serializer<N> columnNameSerializer, ExecutionResult<Map<ByteBuffer, List<ColumnOrSuperColumn>>> executionResult) {
        super(keySerializer, columnNameSerializer, executionResult);
        this.rows = executionResult.get().entrySet().iterator();
        if (this.hasNext()) {
            this.next();
        }
        this.hasEntries = this.getColumnNames() != null && this.getColumnNames().size() > 0;
    }

    @Override
    public Collection<N> getColumnNames() {
        return this.columns == null ? null : this.columns.keySet();
    }

    @Override
    public ByteBuffer getColumnValue(N columnName) {
        HColumn<N, ByteBuffer> col = this.getColumn(columnName);
        return col != null ? col.getValue().duplicate() : null;
    }

    @Override
    public HColumn<N, ByteBuffer> getColumn(N columnName) {
        return this.columns.get(columnName);
    }

    private void applyToRow(List<ColumnOrSuperColumn> cosclist) {
        this.hasEntries = cosclist.size() > 0;
        Iterator<ColumnOrSuperColumn> iterator = cosclist.iterator();
        while (iterator.hasNext()) {
            ColumnOrSuperColumn cosc = iterator.next();
            if (cosc.isSetSuper_column()) {
                this.applySuper(cosc);
            } else {
                this.applyStandard(cosc.getColumn());
            }
            iterator.remove();
        }
    }

    private void applySuper(ColumnOrSuperColumn cosc) {
        Iterator tcolumns = cosc.getSuper_column().getColumnsIterator();
        while (tcolumns.hasNext()) {
            this.applyStandard((Column)tcolumns.next());
        }
    }

    private void applyStandard(Column cosc) {
        Object colName = this.columnNameSerializer.fromByteBuffer(cosc.name.duplicate());
        HColumn<N, ByteBuffer> column = this.columns.get(colName);
        if (column == null) {
            column = new HColumnImpl(cosc, this.columnNameSerializer, ByteBufferSerializer.get());
        } else {
            ((HColumnImpl)column).apply(cosc);
        }
        this.columns.put(colName, column);
    }

    @Override
    public K getKey() {
        return (K)this.keySerializer.fromByteBuffer(this.entry.getKey().duplicate());
    }

    @Override
    public ColumnFamilyResult<K, N> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more rows left on this HColumnFamily");
        }
        this.entry = this.rows.next();
        this.columns = new LinkedHashMap<N, HColumn<N, ByteBuffer>>();
        this.applyToRow(this.entry.getValue());
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.rows.hasNext();
    }

    @Override
    public void remove() {
        this.rows.remove();
    }

    @Override
    public boolean hasResults() {
        return this.hasEntries;
    }
}

